/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate suppress directory filter
 */

#include <ac/assert.h>

#include <tar/input/filter/suppr_direc.h>


tar_input_filter_suppress_directories::~tar_input_filter_suppress_directories()
{
}


tar_input_filter_suppress_directories::tar_input_filter_suppress_directories(
	tar_input *arg) :
    tar_input_filter(arg)
{
}


int
tar_input_filter_suppress_directories::read_header(tar_header &h)
{
    for (;;)
    {
	if (!tar_input_filter::read_header(h))
	    return 0;
	if (h.type != tar_header::type_directory)
	    return 1;
	read_header_padding();
	/*
	 * We would need to skip the data, if directories *had*
	 * data, but they dont.
	 */
	assert(h.size == 0);
	read_data_padding();
    }
}
