/* -*- mode: c; c-file-style: "gnu" -*-
 * options.h -- compile-time options for Thy
 * Copyright (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file options.h
 * Compile-time options for Thy.
 *
 * This header contains the defines that decide which features get
 * compiled in. Most of them can be enabled or disabled with the
 * appropriate --enable-[foo], --disable-[foo] argument to configure.
 *
 * The idea here is that if THY_OPTION_[something] is defined, that
 * feature should be compiled in. If THY_OPTION_NO[something] is
 * defined, the feature should be left out. This is acomplished by
 * undefining THY_OPTION_[something] if THY_OPTION_NO[something] is
 * defined.
 *
 * Pretty awkward, but autoconf, for some reason, does not allow me to
 * define anything to something else than `1'.
 */

#ifndef _THY_OPTIONS_H
#define _THY_OPTIONS_H 1 /**< options.h multi-inclusion guard. */

#include "system.h"

/** Support for forking into the background */
#ifndef THY_OPTION_FORK
#define THY_OPTION_FORK 1
#endif

#if THY_OPTION_NOFORK
#undef THY_OPTION_FORK
#endif

/** Support request logging */
#ifndef THY_OPTION_LOGGING
#define THY_OPTION_LOGGING 1
#endif

#if THY_OPTION_NOLOGGING
#undef THY_OPTION_LOGGING
#endif

/** Support logging */
#ifndef THY_OPTION_ALL_LOGGING
#define THY_OPTION_ALL_LOGGING 1
#endif

#if THY_OPTION_NOALL_LOGGING
#undef THY_OPTION_ALL_LOGGING
#endif

/** TLS support */
#ifndef THY_OPTION_TLS
#define THY_OPTION_TLS 1
#endif

#if THY_OPTION_NOTLS
#undef THY_OPTION_TLS
#endif

/** Zlib & on-the-fly compression support */
#ifndef THY_OPTION_ZLIB
#define THY_OPTION_ZLIB 1
#endif

#if THY_OPTION_NOZLIB
#undef THY_OPTION_ZLIB
#endif

/** uname() reporting in the server version */
#ifndef THY_OPTION_UNAME
#define THY_OPTION_UNAME 0
#endif

#if THY_OPTION_NOUNAME
#undef THY_OPTION_UNAME
#endif

/** Ident lookup support */
#ifndef THY_OPTION_IDENT
#define THY_OPTION_IDENT 0
#endif

#if THY_OPTION_NOIDENT
#undef THY_OPTION_IDENT
#endif

/** Use libmagic if mime type cannot be determined. */
#ifndef THY_OPTION_FILE_MAGIC
#define THY_OPTION_FILE_MAGIC 0
#endif

#if THY_OPTION_NOFILE_MAGIC
#undef THY_OPTION_FILE_MAGIC
#endif

/** Support for the TRACE method.
 * @note This requires extra memory! */
#ifndef THY_OPTION_TRACE
#define THY_OPTION_TRACE 0
#endif

#if THY_OPTION_NOTRACE
#undef THY_OPTION_TRACE
#endif

/** Debug (for profiling and the like) mode */
#ifndef BHC_OPTION_DEBUG
#define BHC_OPTION_DEBUG 0
#endif

#if BHC_OPTION_NODEBUG
#undef BHC_OPTION_DEBUG
#endif

#if defined(BHC_OPTION_DEBUG) && BHC_OPTION_DEBUG != 0
#define THY_OPTION_DEBUG 1
#else
#undef THY_OPTION_DEBUG
#endif

#endif /* !_THY_OPTIONS_H */
