//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef BLOCK_HH
#define BLOCK_HH

#include <vector>
using std::vector;

/** This indexes the elements from zero. Be careful while indexing
    it. Start from zero.*/
class Block {
public:
  Block(){}
  Block( const int initSize );
  ~Block(){}

  void *getElement(const int index);
  void *operator[](const int index);
  void addElement(void *newElement);
  void removeElement(const int index);
  int getNumberOfElements() const;
  void reset();
  Block &operator=(const Block &);
  
private:
  /** The array pointer pointing to Valid Location */
  vector<void *> expandableArray;

  void *find(void *);
};

#endif


