#include "TyvisPluginLoader.hh"
#include "VHDLApplication.hh"
#include <clutils/PluginManager.h>

TyvisPluginLoader &
TyvisPluginLoader::instance(){
  static TyvisPluginLoader *singleton = new TyvisPluginLoader();
  return *singleton;
}

VHDLApplication *
TyvisPluginLoader::getVHDLApplication( const string &pluginFileName ){
  VHDLApplication *retval = 0;
  
  _savant_entity_elab *entityElab = loadEntityElab( pluginFileName );
  if( entityElab != 0 ){
    retval = new VHDLApplication( entityElab );
  }

  return retval;
}

TyvisPluginLoader::TyvisPluginLoader(){}

TyvisPluginLoader::~TyvisPluginLoader(){}

_savant_entity_elab *
TyvisPluginLoader::loadEntityElab( const string &pluginFileName ){
  _savant_entity_elab *retval = 0;

  PluginManager *mm = PluginManager::instance();
  retval = reinterpret_cast<_savant_entity_elab *>(mm->loadPlugin( pluginFileName ));
  if( retval == 0 ){
    std::cerr << pluginFileName << " could not be loaded, error is \"" <<
      mm->getLastError() << "\"." << std::endl;
  }

  return retval;
}
