/* ==================================================== ======== ======= *
 *
 *  umenuImpl.hpp
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _umenuImpl_hpp_
#define	_umenuImpl_hpp_
//pragma ident	"@(#)umenuImpl.hpp	ubit:03.05.00"


class UMenuCtrl {
  friend class UMenu;
  friend class UMenubar;

  class UFlow& iflow;
  // stack of menus that are currently being grabbed
  // (the size of this stack is CASCADED_MENU_MAX_COUNT+1)
  UGroup **menu_stack; 
  int    menu_count;
  UView  *active_opener, *possible_opener, *possible_closer;
  UMenu  *active_menu, *possible_opener_menu, *possible_closer_menu;
  uptr<UTimer> open_timer, close_timer;  // uptr: dont destroy Timers

public:
  UMenuCtrl(class UFlow*);
  ~UMenuCtrl();

  bool isActive() const;
  ///< is a menu active ?

  bool isActive(UGroup *menu) const;
  ///< is 'this' menu active?.

  UMenu* getActiveMenu() const {return active_menu;}
  ///< returns the menu that is active (null otherwise).

  // NB: closeSubMenus calls closeAllMenus if menu is not found
  void closeSubMenus(UMenu* );
  void closeAllMenus(bool stop_auto_open_mode);
  void activateMenu(UView *opener, UMenu*, UGroup* menuGroup);

  void enterMenuOpener(UEvent&, UMenu*);
  void enterMenubarChild(UEvent&, bool inside_menubar);
  void leaveMenubarChild(UEvent&, bool inside_menubar);
  void enterMenuChild(UEvent&, UMenu*);
  void leaveMenuChild(UEvent&);
  void relaxMenuChild(UEvent&);
  
  void openMenuAfterDelay();
  void closeMenuAfterDelay();
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

