/* ==================================================== ======== ======= *
 *
 *  uwinImpl.hh  [Window Implementation]
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uwinImpl_hh
#define	_uwinImpl_hh
//pragma ident	"@(#)uwin.hh	ubit:03.04.00"
#include <ubit/uprop.hpp>
#include <ubit/ugraph.hpp>

/* ==================================================== ======== ======= */

class USoftwinImpl {
  friend class UWin;
  friend class UHardwinImpl;

  UPos pos;
  UView* current_winview;

public:
  USoftwinImpl(class UWin&);
  ~USoftwinImpl();

  void update(const class UUpdate& upmode, class UWin*, class UView* winview);
};

/* ==================================================== ======== ======= */

class UHardwinImpl {
  friend class UWin;
  friend class USoftwinImpl;

  class UWinGraph& wingraph; 
  class ULink* sub_softwins;

public:
  UHardwinImpl(class UWin&);
  ~UHardwinImpl();

  class UWinGraph* getWinGraph() const {return &wingraph;} 
  class UNatWin*   getNatWin()   const {return wingraph.getNatWin();}

  class ULink*  getSoftwinLink() const {return sub_softwins;} 
  class UGroup* getSoftwins() const;
  void  removeSoftwin(UWin* softwin);
  void  addSoftwin(UWin* softwin, UWin* hardwin, UView* hardwin_view);

  void  update(const class UUpdate &mode, class UWin*, class UView* winview);
  void  updateImpl(const class UUpdate& upmode, class UWin*,
		   class UView* winview, bool impose_size, u_dim w, u_dim h);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

