#include "CirculateInitializationMessage.h"
#include "DeserializerManager.h"

void 
CirculateInitializationMessage::serialize( SerializedInstance *addTo ) const {
  KernelMessage::serialize( addTo );
}

Serializable *
CirculateInitializationMessage::deserialize( SerializedInstance *data ){
  unsigned int sender = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  return new CirculateInitializationMessage( sender,
					     dest );
}

const string &
CirculateInitializationMessage::getCirculateInitializationMessageType(){
  static const string circulateInitializationMessageType = "CirculateInitializationMessage";
  return circulateInitializationMessageType;
}

void 
CirculateInitializationMessage::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getCirculateInitializationMessageType(),
							 &deserialize );
}
