#ifndef EVENT_ID_H
#define EVENT_ID_H

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include <iostream>

class EventId {
  friend class Event;
  friend class DefaultEvent;
  friend class NegativeEventMessage;

  friend std::ostream &operator<<( std::ostream &os, const EventId &toPrint );

public:
  EventId() : val( getNextId() ){}
  virtual ~EventId(){}  

  /**
     Constructor used in constructing vectors of EventIds.
  */
  EventId( const EventId &initFrom ) : val( initFrom.val ){}
  
  /**
     This is also required for containers of EventIds.
  */
  EventId &operator=( const EventId &initFrom ){ val = initFrom.val; return *this; }
  
  /**
     This is really the only function of EventId that should normally be
     used by applications.
  */
  bool operator==( const EventId &compareTo ) const {
    return val == compareTo.val;
  }
  bool operator!=( const EventId &compareTo ) const {
    return val != compareTo.val;
  }

private:
  static int getNextId(){
    static int idVal1 = 0;
    return idVal1++;
  }

  EventId( const unsigned int initVal ) : val( initVal ){}
  
  unsigned int val;
};

inline std::ostream &
operator<<( std::ostream &os, const EventId &toPrint ){
  os << toPrint.val;
  return os;
}


#endif
