#ifndef INPUT_SET_OBJECT_H
#define INPUT_SET_OBJECT_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "State.h"
#include "SetObject.h"

/** The InputSetObject Class.

    This class is used for encapsulating events in the Input
    queue. This class is derived from the SetObject base class and
    redefines the comparison operators. Used exclusively in the append
    queue and the sender queue implementations.
*/
template <class Element>
class InputSetObject : public SetObject< Element > {
public:
   /**@name Public Class Methods of InputSetObject. */
   //@{

   /** Constructor.

       @param currentTime Current time  of event.
       @param currentElement Element to be encapsulated.
       @param senderID sender object if of the element.
   */
   InputSetObject(const VTime& currentTime, Element* currentElement,
                  const OBJECT_ID& id) :
      SetObject< Element >(currentTime, currentElement), senderID(id){}

   /** Constructor.

       @param currentTime Current time  of event.
       @param currentElement Element to be encapsulated.
   */
   InputSetObject(const VTime& currentTime, Element* currentElement):
      SetObject< Element >(currentTime, currentElement){}

   /** Constructor.

       @param currentTime Current time  of event.
   */
   InputSetObject(const VTime& currentTime):
      SetObject< Element >(currentTime, NULL){}

   /** Constructor.

       @param senderID sender Object id of the event.
   */
   InputSetObject(const OBJECT_ID& id) :
      SetObject< Element >(0, NULL), senderID(id){}

   /// Destructor.
   ~InputSetObject(){}

   /// Overloaded operator <
   friend bool operator<(const InputSetObject& a, const InputSetObject& b){
     return ((a.time < b.time) ? true : ((a.time == b.time) ? (a.senderID < b.senderID) : false));
   }
  
   /// Overloaded operator ==
   friend bool operator==(const InputSetObject& a, const InputSetObject& b){
      return (a.time == b.time) && (a.senderID == b.senderID);
   }
  
   /// Overloaded operator >
   friend bool operator>(const InputSetObject& a, const InputSetObject& b){
     return ((a.time > b.time) ? true : ((a.time == b.time) ? (a.senderID > b.senderID) : false));
   }
  
   /// Overloaded operator <<
   friend ostream& operator<<(ostream& os, const InputSetObject& a){
      return os << a.time;
   }

   //@} // End of Public Class Methods of InputSetObject.

protected:
   /**@name Protected Class Attributes of InputSetObject. */
   //@{

   ///OBJECT_ID of the process created this element(senderID)
   OBJECT_ID senderID;

   //@} // End of Protected Class Attributes of InputSetObject.

};

#endif
