#include "PartitionInfo.h"

PartitionInfo::PartitionInfo( unsigned int numPartitions ) :
  myNumberOfPartitions( numPartitions ),
  myObjectSets( new vector<vector<SimulationObject *> *> ){}


unsigned int 
PartitionInfo::getNumberOfPartitions() const {
  return myNumberOfPartitions;
}

vector<SimulationObject *> *
PartitionInfo::getObjectSet( unsigned int setNumber ) const {
  return (*myObjectSets)[setNumber];
}

void 
PartitionInfo::addPartition( unsigned int partitionNumber,
			     vector<SimulationObject *> *toAdd ){
  myObjectSets->reserve( partitionNumber + 1 );
  myObjectSets->insert( myObjectSets->begin() + partitionNumber,  toAdd );
}

