#ifndef PARTITIONER_H
#define PARTITIONER_H

// Copyright (c) Clifton Labs, Inc.
// All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors:
//          Dale E. Martin              dmartin@cliftonlabs.com

#include <vector>
using std::vector;
class SimulationObject;
class PartitionInfo;

class Partitioner {
public:
  /**
     Partition the objects.  Caller is responsible for deleting both the
     arguments and the returned PartitionInfo.
  */
  virtual const PartitionInfo *partition( const vector<SimulationObject *> *objects,
					  const unsigned int numLPs ) const = 0;

  virtual ~Partitioner() = 0;

protected:
  Partitioner(){}
};

#endif
