#ifndef PERIODIC_STATE_MANAGER_H
#define PERIODIC_STATE_MANAGER_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "StateManagerImplementationBase.h"

class SimulationObject;

/** The PeriodicStateManager class.

    The PeriodicStateManager class is an implementation of the
    abstract StateManager class. It implements a state manager that
    saves states Periodicly depending on a state period that is an
    input parameter. By default, this state period is one (i.e. save
    state for every event execution).

*/
class PeriodicStateManager : public StateManagerImplementationBase {
public:

  /**@name Public Class Methods of PeriodicStateManager. */
  //@{

  /** Constructor.
      
      @param numObjects Number of simulation objects.
      @param period State saving period (default = 0).
  */
  PeriodicStateManager( SimulationManager *simMgr,
			unsigned int period = 0);
  
  /// Destructor
  ~PeriodicStateManager();
  
  /** Save the state of the object at the specified time.

      @param currentTime Current time of state saving.
      @param object Simulation object for which to save the state.
  */
  void saveState( const VTime &currentTime, SimulationObject* object);

  void configure( SimulationConfiguration & ){}
  
  //@} // End of Public Class Methods of PeriodicStateManager.

};

#endif
