// Copyright (c) 2000 Clifton Labs, Inc.
// All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors:
//          Dale E. Martin              dmartin@cliftonlabs.com

#include "TerminateToken.h"
#include "DeserializerManager.h"

TerminateToken::TerminateToken(	unsigned int source,
				unsigned int dest,
				unsigned int terminator,
				TokenState state )
  : KernelMessage( source,
		   dest ),
    myState( state ),
    myTerminator( terminator ){}

const string &
TerminateToken::getTerminateTokenType(){
  static string typeString( "TerminateToken" );
  return typeString;
}


void
TerminateToken::serialize( SerializedInstance *addTo ) const {
  KernelMessage::serialize( addTo );
  addTo->addUnsigned( myTerminator );
  addTo->addInt( myState );
}


Serializable *
TerminateToken::deserialize( SerializedInstance *data ){
  // Pull the data - have to do this outside of the constructor arguments
  // so that the data comes out ordered.
  unsigned int source = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  unsigned int terminator = data->getUnsigned();
  int state = data->getInt();

  return new TerminateToken( source,
			     dest,
			     terminator,
			     TerminateToken::TokenState( state ) );

}

void 
TerminateToken::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getTerminateTokenType(),
							 &deserialize );
}
