#ifndef TIME_WARP_CENTRALIZED_EVENT_SET_H
#define TIME_WARP_CENTRALIZED_EVENT_SET_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "TimeWarpEventSet.h"

class Event;
class SimulationObject;

/** The TimeWarpCentralizedEventSet abstract base class.

    This is the abstract base class for all Time Warp specific
    centralized event set implementations in the kernel. Centralized
    EventSet implementations share a single queue across all
    simulation objects in a simulation manager. Different Time Warp
    centralized event set implementations must be derived from this
    abstract class.

*/
class TimeWarpCentralizedEventSet : public TimeWarpEventSet {
public:
  /**@name Public Class Methods of TimeWarpCentralizedEventSet. */
  //@{
   
  /// Virtual Destructor
  virtual ~TimeWarpCentralizedEventSet(){};

  //@} // End of Public Class Methods of TimeWarpCentralizedEventSet.

protected:

  /**@name Protected Class Methods of TimeWarpCentralizedEventSet. */
  //@{

  /// Default Constructor
  TimeWarpCentralizedEventSet() {};

  //@} // End of Protected Class Methods of TimeWarpCentralizedEventSet.
};

#endif 
