#ifndef NETWORK_MESSAGE_H
#define NETWORK_MESSAGE_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Jorgen Dahl                 dahlj@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "eclmplCommonInclude.h"

/** The NetworkMessage class.

*/
class NetworkMessage {
public:

  /// Default Constructor.
  NetworkMessage() { userDataSize = 0; userData = NULL; }
  
  /// Constructor.
  NetworkMessage(const unsigned int &size, char *data);

  /// Destructor.
  virtual ~NetworkMessage();

  virtual char *serialize() const;
  virtual void serializedUserDataSize(char *buf, int &nrBytes) const;
  virtual void deserialize(char *msg);

  void setUserDataSize(const unsigned int &dataSize) { userDataSize = dataSize; }
  unsigned int getUserDataSize() const { return userDataSize; }
  void setUserData(char *data) { userData = data; }
  char *getUserData() const { return userData; }

  friend ostream& operator<< (ostream& os, const NetworkMessage& msg);
protected:
  unsigned int userDataSize;
  char *userData;
};
#endif
