#ifndef NULL_VISUALIZATION_MANAGER_H
#define NULL_VISUALIZATION_MANAGER_H


// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: 
//          
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "VisualizationManager.h"

/** The NullVisualizationManager class.

    This is the class for visualization thingies.  More documentation to
    follow... 

        "It Better" -DJ

*/
class NullVisualizationManager : public VisualizationManager {
 public:

  /**@name Public Class Methods of NullVisualizationManager. */
  //@{

  /** Default constructor.

      @param void
   */
  NullVisualizationManager(TimeWarpSimMgrWithVisualization *);

  /// destructor
  ~NullVisualizationManager();

  virtual int openVisualizationObject(const char *name, 
				      VisualizationManager::DisplayKind kind, 
				      VisualizationManager::VisualizationTools vizTools) = 0;
 
  virtual int openVisualizationObject(const char *name, 
				      VisualizationManager::DisplayKind kind, 
				      VisualizationManager::VisualizationTools
				      vizTools, VisualizationManager::DataType,
				      void *);

  virtual void closeVisualizationObject(int);

  virtual void addListener(int, void *);
  virtual void updateVisalizationValue(int);
};

#endif
