#!/usr/local/bin/perl
# edit_host.cgi
# Display users and groups on some host

require './cluster-useradmin-lib.pl';
&ReadParse();
&ui_print_header(undef, $text{'host_title'}, "");

@hosts = &list_useradmin_hosts();
($host) = grep { $_->{'id'} == $in{'id'} } @hosts;
$server = &foreign_call("servers", "get_server", $in{'id'});
@packages = @{$host->{'packages'}};

# Show host details
print "<form action=delete_host.cgi>\n";
print "<input type=hidden name=id value=$in{'id'}>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'host_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'host_name'}</b></td>\n";
if ($server->{'id'}) {
	printf "<td><a href='/servers/link.cgi/%s/'>%s</a></td>\n",
		$server->{'id'}, $server->{'desc'} ? "$server->{'desc'} ($server->{'host'}:$server->{'port'})" : "$server->{'host'}:$server->{'port'}";
	}
else {
	print "<td><a href=/>$text{'this_server'}</a></td>\n";
	}

if ($server->{'id'}) {
	print "<td><b>$text{'host_type'}</b></td> <td>\n";
	foreach $t (@servers::server_types) {
		print $t->[1] if ($t->[0] eq $server->{'type'});
		}
	print "</td>\n";
	}
print "</tr>\n";

print "<tr> <td><b>$text{'host_users'}</b></td>\n";
printf "<td>%d</td>\n", scalar(@{$host->{'users'}});

print "<td><b>$text{'host_groups'}</b></td>\n";
printf "<td>%d</td> </tr>\n", scalar(@{$host->{'groups'}});

print "</table></td></tr></table><br>\n";
print "<input type=submit value='$text{'host_delete'}'></form>\n";

# Show users and groups
print "<hr>\n";
print "<h3>$text{'host_ulist'}</h3>\n";
print "<table width=100% border>\n";
print "<tr $tb> <td><b>$text{'index_users'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
foreach $u (@{$host->{'users'}}) {
	if ($i%4 == 0) { print "<tr>\n"; }
	print "<td><a href=\"edit_user.cgi?user=$u->{'user'}&",
	      "host=$server->{'id'}\">$u->{'user'}</a></td>\n";
	if ($i%4 == 3) { print "</tr>\n"; }
	$i++;
	}
print "</table></td> </tr></table>\n";

print "<h3>$text{'host_glist'}</h3>\n";
print "<table width=100% border>\n";
print "<tr $tb> <td><b>$text{'index_groups'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
foreach $g (@{$host->{'groups'}}) {
	if ($j%4 == 0) { print "<tr>\n"; }
	print "<td><a href=\"edit_group.cgi?group=$g->{'group'}&",
	      "host=$server->{'id'}\">$g->{'group'}</a></td>\n";
	if ($j%4 == 3) { print "</tr>\n"; }
	$j++;
	}
print "</table></td> </tr></table>\n";

&ui_print_footer("", $text{'index_return'});

