#!/usr/bin/perl

require './snort-lib.pl';

#
# YOU MUST UPDATE THIS ARRAY WHEN ADDING CHOICES!
#
# Below are the remaining Yes/No options.  To add more, just include the name here
# which will be the access key AND should correspond to a lang entry acl_(name)
my @opts=('text','ruletog','net','ruleedit','pp','ruleadd','out','ruledel','apply','ruleview');

# acl_security_form(&options)
# Output HTML for editing global security options
sub acl_security_form
{
   # Determine if user can change All, Selected, or Unselected rules
   local $m = $_[0]->{'rules'} eq '*' ? 0 :
              $_[0]->{'rules'} =~ /^\!/ ? 2 : 1;

   # Ruleset permissions are stored in a single value (rules)
   # If the value is set to "*", the user can edit all rulesets
   # If a user can edit selected rulesets, rules will contain the list
   #   delimited by spaces
   # If a user can edit al rules except those selected, the list of
   # rulesets will have "!" in front of each ruleset

   print "<tr> <td valign=top><b>$text{'acl_rules'}</b></td>\n";
   print "<td colspan=3><table cellpadding=0 cellspacing=0> <tr><td valign=top>\n";
   printf "<input type=radio name=rules_def value=1 %s> %s<br>\n",
        $m == 0 ? 'checked' : '', $text{'acl_rall'};
   printf "<input type=radio name=rules_def value=0 %s> %s<br>\n",
        $m == 1 ? 'checked' : '', $text{'acl_rsel'};
   printf "<input type=radio name=rules_def value=2 %s> %s</td>\n",
        $m == 2 ? 'checked' : '', $text{'acl_rnsel'};

   print "<td><select name=rules multiple size=4 width=150>\n";

   # Lets grab the current set of rules
   local $conf = &get_config("rule");
   local ($r, %rcan);

   # Create a test array for rulesets that were previously selected
   map { $rcan{$_}++ } split(/\s+/, $_[0]->{'rules'});

   # Output the select options, adding selected where appropriate
   foreach $r (sort keys %$conf) {
      printf "<option value='%s' %s>%s\n", $r,
              $rcan{$r} ? "selected" : "", $r;
   }
   print "</select></td> </tr></table></td></tr>\n";

   # Now we'll output the Y/N choices in 2 columns of settings (4 cols total)

   local $tr_flag = 1;  # Used to include table TR where appropriate
   local $set_name;

   foreach $choice (@opts) {
      if ($tr_flag) {
         print "<tr>";  $tr_flag = 0;
      } else {
         $tr_flag = 1;
      }
      $set_name = "acl_" . $choice;
      print "<td><b>$text{$set_name}</b></td> <td>\n";
      printf "<input type=radio name=$choice value=1 %s> $text{'yes'}\n",
         $_[0]->{$choice} ? "checked" : "";
      printf "<input type=radio name=$choice value=0 %s> $text{'no'}</td>\n",
         $_[0]->{$choice} ? "" : "checked";
   }  
}

# acl_security_save(&options)
# Parse the form for global security options
sub acl_security_save
{

   # Borrowed from bind8 config code
   # This allows us to easily store rulesets user can update
   if ($in{'rules_def'} == 1) {
      $_[0]->{'rules'} = "*";
   } elsif ($in{'rules_def'} == 2) {
      $_[0]->{'rules'} = join(" ", "!", split(/\0/, $in{'rules'}));
   } else {
      $_[0]->{'rules'} = join(" ", split(/\0/, $in{'rules'}));
   }

   # Now store all the Yes/No choices
   foreach $key (@opts) { $_[0]->{$key} = $in{$key}; }
}

