/* Include for the header types from proftpd */

/* Magic tag that identifies it as correct runtime file */
#define PROFTPD_MAGIC	0xDEADBEEF


typedef struct {
  unsigned long r_magic;		/* always 0xdeadbeef */
  unsigned long r_version;		/* version of proftpd created with */
  unsigned long r_size;			/* Size of each entry (including first) */
} logrun_header_t;

/* Structure used for writing to /var/run/proftpd-*
 */

typedef struct {
  pid_t	pid;
  uid_t uid;
  gid_t gid;
  unsigned int server_ip;
  unsigned short server_port;
  time_t idle_since;
  char user[100],op[200];
  unsigned long transfer_size,transfer_complete;
  char address[80],cwd[100];
  char spare[100];
} logrun_t;

