// $Id: ETEdit.h,v 1.1 2002/02/17 00:28:19 nekeme Exp $
#ifndef WE_ETNEW_H

#include "EntityTool.h"
#include "Command.h"

class ETEdit : public EntityTool
{
      Entity *m_Entity;
  public:
      ETEdit (World *world);
      virtual ~ETEdit();
      
      /// Apply tool at (x,z)
      virtual void Apply3D (Ark::Vector3 newpos, const Ark::Collision &col);
      
      /// Update or reset tool
      virtual void Update();
      
   public:
      /// Create a command with a correct state.
      virtual Command* CreateCommand();
};

/// Entity command: edit
class ECEdit : public Command
{
      World *m_World;
      Entity *m_Entity;

   public:
      ECEdit (World *world, Entity *entity);
      virtual ~ECEdit();

      /// Return the command type.
      virtual std::string Type() const;

      /// Execute this command.
      virtual void Execute();

      /// Undo the action done by this command.
      virtual void Unexecute();
};

#endif

