#ifndef __FreeBSD__
#include <unistd.h>
#endif /* FreeBSD */

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>

int u_sleep(unsigned long int microSeconds)
{
      unsigned int Seconds , uSec;
      int nfds=0;
      struct timeval Timer;

      if(microSeconds == (unsigned long) 0)
	return 0;

      if( (microSeconds < (unsigned long) 0) 
	 || microSeconds > (unsigned long) 4000000)
	{
	      errno = ERANGE;
	      perror("u_sleep time out of range(0 -> 4000000)");
	      return -1;
	}
      
      Seconds = microSeconds/(unsigned long) 1000000;
      
      uSec = microSeconds %(unsigned long) 1000000;
      
      Timer.tv_sec = Seconds;
      Timer.tv_usec = uSec;
      
      if(select(nfds , NULL, NULL, NULL,&Timer) < 0)
	{
	      perror("u_sleep (select) failed ");
	      return -1;
	}
      return 0;
}

      
	
