/*
 * Program XBLAST V2.5.15 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * March 25th 1999
 * started August 1993
 *
 * File: sprite.c
 * sprite  management
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: sprite.c,v 1.2 1999/03/25 20:07:07 xblast Exp $
 * $Log: sprite.c,v $
 * Revision 1.2  1999/03/25 20:07:07  xblast
 * New Bomb animation frame inserted, showing blasting bomb
 *
 * Revision 1.1  1998/01/03 14:08:26  xblast
 * Initial revision
 *
 */

#include <stdlib.h>
#include <stdio.h>
#define _SPRITE_C
#include "include.h"
#include "mytypes.h"
#include "graphics.h"
#include "map.h"
#include "sprite.h"
/*
 * local variables
 */
AnySprite *sprite_first = NULL;
AnySprite *sprite_last  = NULL;

/*
 * local function: create sprite
 */
#ifdef __STDC__
static Sprite *
create_sprite (int type,
	       PFV draw,
	       PFR rect,
	       int x, 
	       int y,
	       int ysort,
	       int mode)
#else
static Sprite *
create_sprite (type, draw, rect, x, y, ysort, mode)
  int type;
  PFV draw;
  PFR rect;
  int x, y, ysort;
  int mode;
#endif
{
  AnySprite *ptr;
  AnySprite *other;
  /* alloc memory */
  if (NULL == (ptr = (AnySprite *) malloc(sizeof(Sprite) ) ) ) {
    return NULL;
  }

  /* init values */
  ptr->type = type;
  ptr->dirty = TRUE;
  ptr->draw = draw;
  ptr->rect = rect;
  ptr->x = x;
  ptr->y = y;
  ptr->ysort = ysort;
  ptr->mode = mode;
  ptr->next = NULL;
  ptr->prev = NULL;

  /* store sprite in list */
  if (NULL == sprite_first) {
    sprite_first = sprite_last = ptr;
  } else {
    for (other=sprite_first; other != NULL; other = other->next) {
      /* list is sorted by inccreasing (y+ysort) value */
      if ( (other->ysort + other->y) > (ptr->ysort + ptr->y) ) {
	if (NULL == other->prev) {
	  /* start of list */
	  sprite_first = ptr;
	  ptr->prev = NULL;
	} else {
	  other->prev->next = ptr;
	  ptr->prev = other->prev;
	}
	ptr->next = other;
	other->prev = ptr;
	return (Sprite *)ptr;
      }
    }
    sprite_last->next = ptr;
    ptr->prev = sprite_last;
    sprite_last = ptr;
  }

  return (Sprite *)ptr;
}
	       


/*
 * public function: create_player_sprite
 */
#ifdef __STDC__
Sprite *
create_player_sprite (int player,
		      int x, 
		      int y,
		      int anime,
		      int mode)
#else
Sprite *
create_player_sprite (player, x, y, anime, mode)
  int player, x, y, anime, mode;
#endif
{
  Sprite *ptr;

  ptr = create_sprite (STPlayer, draw_player_sprite, rect_player_sprite, 
		       x, y, BLOCK_HEIGHT, mode);
  if (NULL == ptr) {
    return NULL;
  }

  ptr->player.anime = anime;
  ptr->player.player = player;

  return ptr;
}

		

/*
 * public function: create_bomb_sprite
 */
#ifdef __STDC__
Sprite *
create_bomb_sprite (int bomb,
		    int x, 
		    int y,
		    int anime,
		    int mode)
#else
Sprite *
create_bomb_sprite (bomb, x, y, anime, mode)
  int bomb, x, y, anime, mode;
#endif
{
  Sprite *ptr;

  ptr = create_sprite (STBomb, draw_bomb_sprite, rect_bomb_sprite, 
		       x, y, BASE_Y/2, mode);
  if (NULL == ptr) {
    return NULL;
  }

  ptr->bomb.anime = anime;
  ptr->bomb.bomb  = bomb;

  return ptr;
}


/*
 * public function delete_sprite
 */
#ifdef __STDC__
void
delete_sprite (Sprite *spr)
#else
void
delete_sprite (spr)
  Sprite *spr;
#endif
{
  if (NULL == spr->any.prev) {
    sprite_first=spr->any.next;
  } else {
    spr->any.prev->next = spr->any.next;
  }
  if (NULL == spr->any.next) {
    sprite_last=spr->any.prev;
  } else {
    spr->any.next->prev = spr->any.prev;
  }
  if (spr->any.mode & SPM_MAPPED) {
    /* mark tiles on position */
    mark_maze_sprite (spr);
  }
  free(spr);
}

/*
 * local function swap_sprite_prev
 */
#ifdef __STDC__
void 
swap_sprite_prev (AnySprite *ptr)
#else
void 
swap_sprite_prev (ptr) 
  AnySprite *ptr;
#endif
{
  AnySprite *prev;

  if (NULL == (prev = ptr->prev) ) {
    return;
  }

  /* references from outside */
  if (prev->prev != NULL) {
    prev->prev->next = ptr;
  } else {
    sprite_first = ptr;
  }
  if (ptr->next != NULL) {
    ptr->next->prev = prev;
  } else {
    sprite_last = prev;
  }
  /* internal refs */
  prev->next = ptr->next;
  ptr->prev = prev->prev;

  prev->prev = ptr;
  ptr->next  = prev;
}



/*
 * public function: move_sprite
 */
#ifdef __STDC__
void
move_sprite (Sprite *sprite, 
	     int x, int y)
#else
void
move_sprite (sprite, x, y)
  Sprite *sprite;
  int x, y;
#endif
{
  AnySprite *spr = (AnySprite *) sprite;
  AnySprite *ptr;

  if ( (spr->y == y) && (spr->x == x) ) {
    return;
  }

  if (spr->mode & SPM_MAPPED) {
    /* mark sprite as dirty */
    spr->dirty = TRUE;
    /* mark tiles on old position */
    mark_maze_sprite((Sprite *)spr);
  }

  spr->x = x;
  if (spr->y < y) {
    spr->y = y;
    /* sprite has move downwards */
    for (ptr = spr->next;
	 (ptr != NULL) && ( (ptr->y + ptr->ysort) < (spr->y + spr->ysort) );
	 ptr = spr->next) {
      swap_sprite_prev (ptr);
    }
  }  else if (spr->y > y) {
    spr->y = y;
    /* sprite has moved upwards */
    for (ptr = spr->prev;
	 (ptr != NULL) && ( (ptr->y + ptr->ysort) > (spr->y + spr->ysort) );
	 ptr = spr->prev) {
      swap_sprite_prev (spr);
    }
  }

  /* mark tiles on new position */
  if (spr->mode & SPM_MAPPED) {
    mark_maze_sprite((Sprite *)spr);
  }
}


/*
 * public function: set_sprite_mode
 */ 
#ifdef __STDC__
void
set_sprite_mode (Sprite *sprite,
		 int mode)
#else
void
set_sprite_mode (sprite, mode)
  Sprite *sprite;
  int mode;
#endif
{
  if (mode == sprite->any.mode) {
    return;
  }
  mark_maze_sprite ((Sprite *)sprite);
  sprite->any.mode = mode;
  sprite->any.dirty = TRUE;
}
      
/*
 * public function: set_sprite_mode
 */ 
#ifdef __STDC__
void
set_sprite_anime (Sprite *sprite,
		 int anime)
#else
void
set_sprite_anime (sprite, anime)
  Sprite *sprite;
  int anime;
#endif
{
  if (anime == sprite->any.anime) {
    return;
  }
  if (sprite->any.mode & SPM_MAPPED) {
    mark_maze_sprite ((Sprite *)sprite);
    sprite->any.dirty = TRUE;
  }
  sprite->any.anime = anime;
  if (sprite->any.mode & SPM_MAPPED) {
    mark_maze_sprite ((Sprite *)sprite);
  }
}
    
/*
 * local function: sprite_intersect
 */
#ifdef __STDC__
static void 
sprite_intersect (AnySprite *a, AnySprite *b) 
#else
static void 
sprite_intersect (a, b)
  AnySprite *a, *b;
#endif
{
  BMRectangle rect_a, rect_b;
  int left, right, top, bottom;

  if ( (a->mode & SPM_MAPPED) && (b->mode & SPM_MAPPED) ) {
    rect_a = *(*a->rect)((Sprite *)a);
    rect_b = *(*b->rect)((Sprite *)b);
    
    left   = MAX(rect_a.x, rect_b.x);
    right  = MIN(rect_a.x + rect_a.w, rect_b.x + rect_b.w);
    
    if (left < right) {
      top    = MAX(rect_a.y, rect_b.y);
      bottom = MIN(rect_a.y + rect_a.h, rect_b.y + rect_b.h);
      if (top < bottom) {
	a->dirty = TRUE;
	b->dirty = TRUE;
	mark_maze_rect (left, top, right-left, bottom-top);
      }
    }
  }
}


  
/*
 * public function mark_all_sprites
 */
#ifdef __STDC__
void
shuffle_all_sprites (void)
#else
void
shuffle_all_sprites ()
#endif
{
  AnySprite *ptr;

  /* switch sprites on same (y+ysort) */
  if (sprite_first != NULL) {
    ptr = sprite_first;
    while (ptr->next != NULL) {
      if ( (ptr->y + ptr->ysort) == (ptr->next->y + ptr->next->ysort) ) { 
	if ( (! ptr->dirty) && (! ptr->next->dirty) ) {
	  sprite_intersect(ptr, ptr->next);
	}
	swap_sprite_prev(ptr->next);
      } else {
	ptr = ptr->next;
      }
    }  
  }
}

/*
 * public function mark_all_sprites
 */
#ifdef __STDC__
void
mark_all_sprites (void)
#else
void
mark_all_sprites ()
#endif
{
  AnySprite *ptr;

  /* check for non-dirty sprites to be redrawn */
  for (ptr = sprite_first; ptr != NULL; ptr = ptr->next) {
    if (FALSE == ptr->dirty) {
      ptr->dirty = sprite_marked ((Sprite *)ptr);
    }
  }
}

/*
 * public function draw all sprites
 */
#ifdef __STDC__
void
draw_all_sprites (void)
#else
void
draw_all_sprites ()
#endif
{
  AnySprite *ptr;

  for (ptr = sprite_first; ptr != NULL; ptr = ptr->next) {
    if ( (ptr->mode & SPM_MAPPED) && (ptr->dirty) ) {
      (*ptr->draw)((Sprite *)ptr);
    }
    ptr->dirty = FALSE;
  }
}

/*
 * end of sprite.c
 */
