// Preferences dialog box

#include "config.h"
#include "i18n.h"

#include <fox-1.2/fx.h>
#include <fox-1.2/fxkeys.h>

#include "FileDialog.h"
#include "Preferences.h"
#include "XFileExplorer.h"
#include "MessageBox.h"

// Root directory string
#ifndef ROOTDIR
#define ROOTDIR "/"
#endif


FXbool Theme::operator != (const Theme& t)
{
    for(int i=0;i<6;i++)
        if(color[i] != t.color[i])
            return TRUE;
    return FALSE;
}

// Main window
extern FXMainWindow *mainWindow;

// Global Flags
FXbool confirm_quit;
FXbool confirm_del;
FXbool confirm_overwrite;
FXbool ask_before_copy;
FXbool warn_if_root;
#if defined(linux)
FXbool mount_warn;
#endif
FXbool display_thumbnails;

// Map
FXDEFMAP(PreferencesBox) PreferencesMap[]={
                                         FXMAPFUNC(SEL_UPDATE ,PreferencesBox::ID_COLOR,PreferencesBox::onUpdColor),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_ACCEPT,PreferencesBox::onCmdAccept),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_EDIT,PreferencesBox::onCmdBrowse),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_VIEW,PreferencesBox::onCmdBrowse),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_XTERM,PreferencesBox::onCmdBrowse),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_CFM,PreferencesBox::onCmdBrowse),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_COLOR,PreferencesBox::onCmdColor),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_NORMALFONT,PreferencesBox::onCmdNormalFont),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_TEXTFONT,PreferencesBox::onCmdTextFont),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_THEME,PreferencesBox::onCmdTheme),
                                         FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_ICON_PATH,PreferencesBox::onCmdBrowsePath),
                                     };
// Object implementation
FXIMPLEMENT(PreferencesBox,FXDialogBox,PreferencesMap,ARRAYNUMBER(PreferencesMap))

// Construct window for one file
PreferencesBox::PreferencesBox(FXWindow *win): FXDialogBox(win,_("Preferences"), DECOR_TITLE|DECOR_BORDER)
{
    currTheme.name = _("Current Theme");
    currTheme.color[0] = getApp()->getBaseColor();
    currTheme.color[1] = getApp()->getBorderColor();
    currTheme.color[2] = getApp()->getBackColor();
    currTheme.color[3] = getApp()->getForeColor();
    currTheme.color[4] = getApp()->getSelbackColor();
    currTheme.color[5] = getApp()->getSelforeColor();

    Themes[0] = currTheme;
    Themes[1] = Theme("GNOME",FXRGB(214,215,214),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255));
    Themes[2] = Theme("KDE",FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,131),FXRGB(255,255,255));
    Themes[3] = Theme("CDE",FXRGB(156,153,156),FXRGB(0,0,0),FXRGB(131,129,131),FXRGB(255,255,255),FXRGB(49,97,131),FXRGB(255,255,255));
    Themes[4] = Theme("Digital CDE",FXRGB(74,121,131),FXRGB(0,0,0),FXRGB(49,76,74),FXRGB(255,255,255),FXRGB(65,80,90),FXRGB(255,255,255));
    Themes[5] = Theme("Sea Sky",FXRGB(165,178,198),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(49,101,156),FXRGB(255,255,255));
    Themes[6] = Theme("Blue Slate",FXRGB(156,186,205),FXRGB(0,0,0),FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(82,129,148),FXRGB(255,255,255));
    Themes[7] = Theme("iMac",FXRGB(205,206,205),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255));
    Themes[8] = Theme("BeOS",FXRGB(222,218,222),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(172,170,172),FXRGB(255,255,255));
	Themes[9] = Theme("Windows 95",FXRGB(192,192,192),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255));


    // Buttons
    FXHorizontalFrame *buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X,0,0,0,0,10,10,5,5);

    // Contents
    FXHorizontalFrame *contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH);

	// Accept
    FXButton *ok = new FXButton(buttons,_("&Accept"),NULL,this,PreferencesBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    ok->addHotKey(KEY_Return);
    
    // Cancel
    new FXButton(buttons,_("&Cancel"),NULL,this,ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    
	// Switcher
    FXTabBook *tabbook = new FXTabBook(contents,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT);

    // First tab - Programs
    new FXTabItem(tabbook,_("&Programs"),NULL);
    FXVerticalFrame *programs=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *group=new FXGroupBox(programs,_("Programs"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXMatrix *matrix = new FXMatrix(group,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    group=new FXGroupBox(programs,_("Search icons in"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);

	// Find iconpath from the Xfe registry settings or set it to "/usr/lib/foxicons"
    iconpath = new FXTextField(group,20,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_X);
    new FXButton(group,_(" Select..."),NULL,this,ID_BROWSE_ICON_PATH,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
	oldiconpath=getApp()->reg().readStringEntry("SETTINGS","iconpath","/usr/lib/foxicons");
    iconpath->setText(oldiconpath);

    new FXLabel(matrix,_("Default text editor:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    editor = new FXTextField(matrix,15,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    new FXButton(matrix,_(" Select..."),NULL,this,ID_BROWSE_EDIT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldeditor=getApp()->reg().readStringEntry("PROGS","editor","nedit ");
    editor->setText(oldeditor);

    new FXLabel(matrix,_("Default text viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    viewer = new FXTextField(matrix,15,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXButton(matrix,_(" Select..."),NULL,this,ID_BROWSE_VIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//0,0,0,0,20,20);
    oldviewer=getApp()->reg().readStringEntry("PROGS","viewer","xfv ");
    viewer->setText(oldviewer);

    new FXLabel(matrix,_("Terminal program:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    xterm = new FXTextField(matrix,15,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    new FXButton(matrix,_(" Select..."),NULL,this,ID_BROWSE_XTERM,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldxterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb ");
    xterm->setText(oldxterm);

    new FXLabel(matrix,_("Console file manager program:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    cfm = new FXTextField(matrix,15,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    new FXButton(matrix,_(" Select..."),NULL,this,ID_BROWSE_XTERM,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldcfm=getApp()->reg().readStringEntry("PROGS","cfm","xterm -e mc -x");
    cfm->setText(oldcfm);

    // Second tab - Options
    new FXTabItem(tabbook,_("&Options"),NULL);
    FXVerticalFrame *options=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    group=new FXGroupBox(options,"Confirmation",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    quit=new FXCheckButton(group,_("Confirm quit"));
    del=new FXCheckButton(group,_("Confirm delete"));
    overwrite=new FXCheckButton(group,_("Confirm overwrite"));
    ask=new FXCheckButton(group,_("Always ask before file operation"));
    group=new FXGroupBox(options,_("Warnings"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
#if defined(linux)
    mount=new FXCheckButton (group,_("Warn when mount points are not responding"));
#endif
    root_warn=new FXCheckButton (group,_("Warn if running as root"));

    group=new FXGroupBox(options,"Images",GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    thumbnails=new FXCheckButton (group,_("Display images as thumbnails"));

    if(getuid())//running as a user?
        root_warn->disable();
    else
        root_warn->setCheck(warn_if_root);

    quit->setCheck(confirm_quit);
    del->setCheck(confirm_del);
    overwrite->setCheck(confirm_overwrite);
    ask->setCheck(ask_before_copy);
#if defined(linux)
	mount->setCheck(mount_warn);
#endif
	thumbnails->setCheck(display_thumbnails);

    // Third tab - Visual
    new FXTabItem(tabbook,_("Co&lors"),NULL);
    FXVerticalFrame *visual=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *colors=new FXGroupBox(visual,_("Colors"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXHorizontalFrame *col=new FXHorizontalFrame(colors,LAYOUT_FILL_X);

    colorsBox = new FXComboBox(col,8,NULL,0,COMBOBOX_NO_REPLACE|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_SIDE_RIGHT);
  	colorsBox->setNumVisible(5);
    FXPacker *pack = new FXPacker(col,LAYOUT_SIDE_LEFT|FRAME_SUNKEN|LAYOUT_FILL_Y);
    cwell = new FXButton(pack,"",NULL,this,ID_COLOR,LAYOUT_FIX_WIDTH|LAYOUT_FILL_Y,0,0, 30);

    colorsBox->appendItem(_("Base color"));
    colorsBox->appendItem(_("Border color"));
    colorsBox->appendItem(_("Background color"));
    colorsBox->appendItem(_("Foreground color"));
    colorsBox->appendItem(_("Selection background color"));
    colorsBox->appendItem(_("Selection foreground color"));
    colorsBox->setCurrentItem(0);

    FXGroupBox *themes=new FXGroupBox(visual,_("Color Theme"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);//|LAYOUT_FILL_Y);
    pack = new FXPacker(themes,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
    themesList = new FXList(pack,this,ID_THEME,LIST_SINGLESELECT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    themesList->setNumVisible(5);
	for(int i=0;i<THEMES_NUM;i++)
        themesList->appendItem(Themes[i].name);
    themesList->setCurrentItem(0);

    // Fourth tab - Fonts
    new FXTabItem(tabbook,_("&Fonts"),NULL);
    FXVerticalFrame *fonts=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *fgroup=new FXGroupBox(fonts,_("Fonts"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    FXMatrix *fmatrix = new FXMatrix(fgroup,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(fmatrix,_("Normal font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    normalfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    new FXButton(fmatrix,_(" Select..."),NULL,this,ID_NORMALFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldnormalfont=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
    normalfont->setText(oldnormalfont);

    new FXLabel(fmatrix,_("Text font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    textfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXButton(fmatrix,_(" Select..."),NULL,this,ID_TEXTFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//0,0,0,0,20,20);
    oldtextfont=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
    textfont->setText(oldtextfont);
}


long PreferencesBox::onUpdColor(FXObject* o,FXSelector s,void* p)
{
    FXButton *btn = (FXButton*)o;
    int i = colorsBox->getCurrentItem();
    btn->setBackColor(currTheme.color[i]);
    return 1;
}


long PreferencesBox::onCmdColor(FXObject* o,FXSelector s,void* p)
{
    FXButton *btn = (FXButton*)o;
    FXColorDialog colordlg(this,_("Color Dialog"));
    colordlg.setRGBA(btn->getBackColor());
    if(colordlg.execute())
    {
        int i = colorsBox->getCurrentItem();
        currTheme.color[i] = colordlg.getRGBA();
    }
    return 1;
}


long PreferencesBox::onCmdTheme(FXObject* o,FXSelector s,void* p)
{
    currTheme = Themes[themesList->getCurrentItem()];
    return 1;
}


long PreferencesBox::onCmdBrowsePath(FXObject* o,FXSelector s,void* p)
{
   FileDialog browse(this,_("Select an icon file to set the icon path"));

    const FXchar *patterns[]=
        {
            _("PNG Images"),     "*.png",NULL
        };
   browse.setFilename(iconpath->getText());
   browse.setPatternList(patterns);

   if(browse.execute())
   {
      FXString path=browse.getFilename();
      iconpath->setText(FXFile::directory(path).text());
   }
   return 1;
}


long PreferencesBox::onCmdBrowse(FXObject* o,FXSelector s,void* p)
{
    FileDialog browse(this,_("Select Program"));
    const FXchar *patterns[]=
        {
            _("All files"),     "*",NULL
        };
	browse.setFilename(ROOTDIR);
	browse.setPatternList(patterns);
    if(browse.execute())
    {
        char *path=strdup(browse.getFilename().text());
        switch(FXSELID(s))
        {
        case ID_BROWSE_VIEW:
            viewer->setText(FXFile::name(path).text());
            break;
        case ID_BROWSE_EDIT:
            editor->setText(FXFile::name(path).text());
            break;
        case ID_BROWSE_XTERM:
            xterm->setText(FXFile::name(path).text());
            break;
        }
    }
    return 1;
}

// Change normal font
long PreferencesBox::onCmdNormalFont(FXObject*,FXSelector,void*)
{
    FXFontDialog fontdlg(this,_("Change Normal Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;

	fontspec=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
   	FXFont* nfont=new FXFont(getApp(),fontspec);
	nfont->getFontDesc(fontdesc);
    
	fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		nfont->setFontDesc(fontdesc);
		fontspec=nfont->getFont();
        normalfont->setText(fontspec);
        if(MBOX_CLICKED_CANCEL!=MessageBox::question(this,MBOX_OK_CANCEL,_("Restart"),_("Normal font will be changed after restart.\nRestart X File Explorer now?")))
		{
        	getApp()->reg().writeStringEntry("SETTINGS","font",fontspec.text());
            mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
			getApp()->setNormalFont(nfont);
		}
    }
    return 1;
}

// Change text font
long PreferencesBox::onCmdTextFont(FXObject*,FXSelector,void*)
{
    FXFontDialog fontdlg(this,_("Change Text Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;
	fontspec=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
   	FXFont* tfont=new FXFont(getApp(),fontspec);
	tfont->getFontDesc(fontdesc);
    fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		tfont->setFontDesc(fontdesc);
		fontspec=tfont->getFont();
        textfont->setText(fontspec);
        if(MBOX_CLICKED_CANCEL!=MessageBox::question(this,MBOX_OK_CANCEL,_("Restart"),_("Text font will be changed after restart.\nRestart X File Explorer now?")))
		{
        	getApp()->reg().writeStringEntry("SETTINGS","textfont",fontspec.text());
            mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
		}
    }
    return 1;
}

long PreferencesBox::onCmdAccept(FXObject* o,FXSelector s,void* p)
{
    if(oldiconpath != iconpath->getText())
        getApp()->reg().writeStringEntry("SETTINGS","iconpath",iconpath->getText().text());

    if(oldeditor != editor->getText())
        getApp()->reg().writeStringEntry("PROGS","editor",editor->getText().text());

    if(oldviewer != viewer->getText())
        getApp()->reg().writeStringEntry("PROGS","viewer",viewer->getText().text());

    if(oldxterm != xterm->getText())
        getApp()->reg().writeStringEntry("PROGS","xterm",xterm->getText().text());

    if(oldcfm != cfm->getText())
        getApp()->reg().writeStringEntry("PROGS","cfm",cfm->getText().text());

    confirm_quit=quit->getCheck();
    confirm_del=del->getCheck();
    confirm_overwrite=overwrite->getCheck();
    ask_before_copy=ask->getCheck();
    warn_if_root=root_warn->getCheck();
#if defined(linux)
	mount_warn=mount->getCheck();
#endif
	display_thumbnails=thumbnails->getCheck();
	
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_quit",quit->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_delete",del->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_overwrite",overwrite->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","ask_before_copy",ask->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","root_warn",root_warn->getCheck());
#if defined(linux)
    getApp()->reg().writeUnsignedEntry("OPTIONS","mount_warn",mount->getCheck());
#endif
    getApp()->reg().writeUnsignedEntry("OPTIONS","display_thumbnails",thumbnails->getCheck());

    if(currTheme != Themes[0])
    {
        getApp()->reg().writeColorEntry("SETTINGS","basecolor",currTheme.color[0]);
        getApp()->reg().writeColorEntry("SETTINGS","bordercolor",currTheme.color[1]);
        getApp()->reg().writeColorEntry("SETTINGS","backcolor",currTheme.color[2]);
        getApp()->reg().writeColorEntry("SETTINGS","forecolor",currTheme.color[3]);
        getApp()->reg().writeColorEntry("SETTINGS","selbackcolor",currTheme.color[4]);
        getApp()->reg().writeColorEntry("SETTINGS","selforecolor",currTheme.color[5]);
        if(MBOX_CLICKED_CANCEL!=MessageBox::question(this,MBOX_OK_CANCEL,_("Restart"),_("Colors will be changed after restart.\nRestart X File Explorer now?")))
            mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
    }
    mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RELOAD_PREFS),NULL);
    FXDialogBox::onCmdAccept(o,s,p);
    return 1;
}
