dnl Checks for the --with-regex option on ./configure, if given it sets the 
dnl REGEX_CFLAGS and REGEX_LIBS accordingly.

AC_DEFUN([REGEX], [
AC_MSG_CHECKING(whether to compile with the included regex library)
AC_ARG_WITH(regex, [  --with-regex    Compile with included regex library],
	AC_MSG_RESULT(yes)
	REGEX_LIBS="-L../regex/.libs -lregex"
	REGEX_CFLAGS="-DINCLUDED_REGEX -I../regex"
	cv_regex="yes"
,
	AC_MSG_RESULT(no)
	REGEX_CFLAGS=""
	REGEX_LIBS=""
	cv_regex="no"
)
AC_SUBST(REGEX_CFLAGS)
AC_SUBST(REGEX_LIBS)
AM_CONDITIONAL(BUILD_REGEX, test x$cv_regex = xyes)
])
