/* $Id: mailaddr.h,v 1.5 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/
#ifndef __MAILADDR_H__
#define __MAILADDR_H__

class MailAddress;
typedef list<MailAddress> MailAddressList;

#define MAILADDR_IGNORE_COMMAS	0x01
#define MAILADDR_GET_FIRST		0x02

class MailAddress {
  public:
	class EInvalidAddress {};

	MailAddress();
	MailAddress(string fullAddress, int flags = 0);
	MailAddress(string addr, string name, string comment, string pgpid = "");
	MailAddress(const MailAddressList &maddrlist);
	MailAddress(const struct _mail_addr *addr);

	string Address() const;
	string Name() const;
	string Comment() const;
	string PGPId() const;

	string buildFull() const;
	string buildShort() const;

	void setAddress(string addr);
	void setName(string name);
	void setComment(string comment);
	void setPGPId(string pgpid);
	bool setFromFull(string fullAddress, int flags = 0);

	/* Conversion to struct _mail_addr */
	struct _mail_addr *toOldAddress() const;

	/* Boolean operators */
	bool operator<(const MailAddress &addr);
	bool operator>(const MailAddress &addr);
	bool operator==(const MailAddress &addr);
	bool operator!=(const MailAddress &addr);

  private:
	string _addr, _name, _comment, _pgpid;
};

MailAddressList parseAddressString(string str, int flags = 0);

#endif /* __MAILADDR_H__ */
