// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_pb_single_editor.h
// *
// * Purpose: A single list of phonebook entries that can be edited
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 28.10.2000
// *************************************************************************

#ifndef XGSM_PB_SINGLE_EDITOR_H
#define XGSM_PB_SINGLE_EDITOR_H

#include "xgsm_device.h"
#include "xgsm_dialogs.h"
#include "xgsm_single_editor.h"

#include <gtk--/frame.h>
#include <gtk--/clist.h>
#include <gtk--/optionmenu.h>
#include <sigc++/signal_system.h>
#include <gsmlib/gsm_util.h>
#include <set>

namespace Xgsm
{
  // Phonebook editor

  class PbSingleEditor : public SingleEditor
  {
    // widgets that must be insensitive if no device is open
    // or the device is busy
    Gtk::Entry *_textEntry, *_numberEntry;
    Gtk::MenuItem *_changeIndexMI;

    string _phonebook;
    unsigned int _maxTextLength, _maxTelephoneLength;

    void sensitive(bool deviceIdle);
    void refresh();
    void completeEdit(bool editorClosed = false);

    // device callbacks
    void onRefresh(ResponseRef response);

    // gui callbacks
    void onTextChanged();
    void onNumberChanged();

    void onSelectRow(int row, int col, GdkEvent *event);
    void onUnselectRow(int row, int col, GdkEvent *event);
    void onExtendSelection();
    void onSelectAll();
    void onUnselectAll();
    void onCut();
    void onAdd();
    void onColumnClicked(gint column);
    
    // debugging function
#ifndef NDEBUG
    void dumpEntries();
#endif

    vector<string> getStoreNames(OpenResponse &res)
      {return res.phonebookNames();}

    string currentStoreName() {return _phonebook;}
    
  public:
    PbSingleEditor(MultiEditor *multiEditor, Gtk::Frame *frame, bool isLeft);

    // functions to connect editor to device
    void open(string deviceName, string baudRate, 
              string initString, bool swHandshake, string phonebook);
    void open(string fileName);

    // initialize phonebook editor (must be called if no open())
    void init();

    void copyStore(int operation, gsmlib::Ref<SingleEditor> e);
  };

};

#endif // XGSM_PB_SINGLE_EDITOR_H
