
#include "FourierAnalyzer.h"

#include <math.h>

FourierAnalyzer::FourierAnalyzer( bool inNormalizePower ) {

	mTrigLookup = 0;
	mSinFT = 0;
	mBinRange = 0;
	mN = 0;
	mNumBins = 0;

	mNormalizePower = inNormalizePower;
}


FourierAnalyzer::~FourierAnalyzer() {

	if ( mSinFT )
		delete []mSinFT;

	if ( mTrigLookup )
		delete []mTrigLookup;
}

void FourierAnalyzer::GenerateTrigTables( long inN, long inNumBins, float inBinRange, float inFreqStart ) {

	float* trig, t, sampleScale, w;
	int i, j;

	// Maintain memory buf that holds our trig tables...
	if ( mTrigLookup )
		delete []mTrigLookup;
	mTrigLookup = new float[ 2 * inN * inNumBins ];

	// Maintain our imaginary component freq spectrum memory
	if ( mSinFT )
		delete []mSinFT;
	mSinFT = new float[ inNumBins ];

	mN 				= inN;
	mNumBins		= inNumBins;
	mBinRange		= inBinRange;
	mFreqStart		= inFreqStart;

	// Make the magnitude of the freq spectrum indep of num of sample size
	sampleScale = 1.0 / ( (float) inN );

	// Compute all the sin and cos values and store them in the order they'll be needed
	trig = mTrigLookup;
	for ( i = 0; i < inN; i++ ) {
		for ( j = 0; j < inNumBins; j++ ) {

			// Calculate the corresponding freq for j
			w = inFreqStart + inBinRange * 6.2831853071 * sampleScale * j;
			t = ( (float) i ) * w;

			trig[ 0 ] = sampleScale * cos( t );
			trig[ 1 ] = sampleScale * sin( t );

			if ( mNormalizePower ) {
				trig[ 0 ] *= w;
				trig[ 1 ] *= w;
			}

			trig += 2;
		}
	}
}



#define __inputElementType float
#include "FourierAnalyzer_Trans.cpp"
#undef __inputElementType

#define __inputElementType short
#include "FourierAnalyzer_Trans.cpp"
#undef __inputElementType

/*
float FourierAnalyzer::CalcBass1( float inSample*, long inNumSamples ) {


}

float FourierAnalyzer::CalcBass1( float inFT[], long inLoBin, long inHiBin, long inNumTopBins ) {
	char 	stackArray[ 32 ];
	int*	topBins = stackArray;
	long	i, binRange = inHiBin - inLoBin;
	float	bin, sum, i, j, idx;

	// Don't alloc mem of it's small..
	if ( binRange > 32 )
		chosen = new char[ binRange ];

	// Unselect all the bins
	for ( i = 0; i < binRange; i++ )
		chosen[ i ] = 0;

	// Offset the input array to put the <inLoBin>th element first
	inFT += binRange;

	// Sum the <inNumTopBins> largest bins in the given range...
	sum = 0;
	for ( j = 0; j < inNumTopBins; j++ ) {

		// Default to the bin not selected yet
		for ( idx = 0; chosen[ idx ]; idx++ ) { }
		bin = inFT[ idx ];

		// Find next largest bin, then 'choose' it
		for ( i = idx + 1; i < binRange; i++ ) {
			if ( inFT[ i ] > bin && chosen[ i ] == 0 ) {
				bin = inFT[ i ];
				idx = i;
			}
		}

		// Choose bin that was largest (idx)
		sum += bin;
		chosen[ idx ] = 1;
	}

	// Cleanup any allocs
	if ( chosen != stackArray )
		delete []chosen;

	return sum;
}

float					CalcBass1( float inFT[], long inLo, long inHi, long inNumTopBins );
float					CalcBass2( float inFT[], long inLo, long inHi );


float FourierAnalyzer::CalcBass2( float inFT[], long inLoBin, long inHiBin ) {
	float sum = 0;
	int i;

	// Just sum the range
	for ( i = inLoBin; i < inHiBin; i++ ) {
		sum += inFT[ i ];
	}

	return sum;
}
*/
