/*
# X-BASED DIAL
#
#  DialSqP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Square Dial */

#ifndef _DialSqP_h
#define _DialSqP_h

#include "DialP.h"
#include "DialSq.h"

typedef struct _SquareDialPart
{
  int ignore;
} SquareDialPart;

typedef struct _SquareDialRec
{
  CorePart core;
  DialPart dial;
  SquareDialPart square_dial;
} SquareDialRec;

/* This gets around C's inability to do inheritance */
typedef struct _SquareDialClassPart
{
  int ignore;
} SquareDialClassPart;

typedef struct _SquareDialClassRec
{
  CoreClassPart core_class;
  DialClassPart dial_class;
  SquareDialClassPart square_dial_class;
} SquareDialClassRec;

extern SquareDialClassRec squareDialClassRec;
#endif /* _DialSqP_h */
