/*
 * Mesa 3-D graphics library
 * Version:  5.1
 *
 * Copyright (C) 1999-2003  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * \file arbparse.c
 * ARB_*_program parser syntax 
 * \author Michal Krole
 */


static char arb_grammar_text[] = ".syntax program;\n"
".emtcode REVISION 0x05\n"
".emtcode FRAGMENT_PROGRAM 0x01\n"
".emtcode VERTEX_PROGRAM 0x02\n"
".emtcode OPTION 0x01\n"
".emtcode INSTRUCTION 0x02\n"
".emtcode DECLARATION 0x03\n"
".emtcode END 0x04\n"
".emtcode ARB_PRECISION_HINT_FASTEST 0x01\n"
".emtcode ARB_PRECISION_HINT_NICEST 0x02\n"
".emtcode ARB_FOG_EXP 0x04\n"
".emtcode ARB_FOG_EXP2 0x08\n"
".emtcode ARB_FOG_LINEAR 0x10\n"
".emtcode ARB_POSITION_INVARIANT 0x20\n"
".emtcode OP_ALU_INST 0x00\n"
".emtcode OP_TEX_INST 0x01\n"
".emtcode OP_ALU_VECTOR 0x06\n"
".emtcode OP_ALU_SCALAR 0x03\n"
".emtcode OP_ALU_BINSC 0x02\n"
".emtcode OP_ALU_BIN 0x01\n"
".emtcode OP_ALU_TRI 0x05\n"
".emtcode OP_ALU_SWZ 0x04\n"
".emtcode OP_TEX_SAMPLE 0x07\n"
".emtcode OP_TEX_KIL 0x08\n"
".emtcode OP_ALU_ARL 0x00\n"
".emtcode OP_ABS 0x00\n"
".emtcode OP_ABS_SAT 0x1B\n"
".emtcode OP_FLR 0x09\n"
".emtcode OP_FLR_SAT 0x26\n"
".emtcode OP_FRC 0x0A\n"
".emtcode OP_FRC_SAT 0x27\n"
".emtcode OP_LIT 0x0C\n"
".emtcode OP_LIT_SAT 0x2A\n"
".emtcode OP_MOV 0x11\n"
".emtcode OP_MOV_SAT 0x30\n"
".emtcode OP_COS 0x1F\n"
".emtcode OP_COS_SAT 0x20\n"
".emtcode OP_EX2 0x07\n"
".emtcode OP_EX2_SAT 0x25\n"
".emtcode OP_LG2 0x0B\n"
".emtcode OP_LG2_SAT 0x29\n"
".emtcode OP_RCP 0x14\n"
".emtcode OP_RCP_SAT 0x33\n"
".emtcode OP_RSQ 0x15\n"
".emtcode OP_RSQ_SAT 0x34\n"
".emtcode OP_SIN 0x38\n"
".emtcode OP_SIN_SAT 0x39\n"
".emtcode OP_SCS 0x35\n"
".emtcode OP_SCS_SAT 0x36\n"
".emtcode OP_POW 0x13\n"
".emtcode OP_POW_SAT 0x32\n"
".emtcode OP_ADD 0x01\n"
".emtcode OP_ADD_SAT 0x1C\n"
".emtcode OP_DP3 0x03\n"
".emtcode OP_DP3_SAT 0x21\n"
".emtcode OP_DP4 0x04\n"
".emtcode OP_DP4_SAT 0x22\n"
".emtcode OP_DPH 0x05\n"
".emtcode OP_DPH_SAT 0x23\n"
".emtcode OP_DST 0x06\n"
".emtcode OP_DST_SAT 0x24\n"
".emtcode OP_MAX 0x0F\n"
".emtcode OP_MAX_SAT 0x2E\n"
".emtcode OP_MIN 0x10\n"
".emtcode OP_MIN_SAT 0x2F\n"
".emtcode OP_MUL 0x12\n"
".emtcode OP_MUL_SAT 0x31\n"
".emtcode OP_SGE 0x16\n"
".emtcode OP_SGE_SAT 0x37\n"
".emtcode OP_SLT 0x17\n"
".emtcode OP_SLT_SAT 0x3A\n"
".emtcode OP_SUB 0x18\n"
".emtcode OP_SUB_SAT 0x3B\n"
".emtcode OP_XPD 0x1A\n"
".emtcode OP_XPD_SAT 0x43\n"
".emtcode OP_CMP 0x1D\n"
".emtcode OP_CMP_SAT 0x1E\n"
".emtcode OP_LRP 0x2B\n"
".emtcode OP_LRP_SAT 0x2C\n"
".emtcode OP_MAD 0x0E\n"
".emtcode OP_MAD_SAT 0x2D\n"
".emtcode OP_SWZ 0x19\n"
".emtcode OP_SWZ_SAT 0x3C\n"
".emtcode OP_TEX 0x3D\n"
".emtcode OP_TEX_SAT 0x3E\n"
".emtcode OP_TXB 0x3F\n"
".emtcode OP_TXB_SAT 0x40\n"
".emtcode OP_TXP 0x41\n"
".emtcode OP_TXP_SAT 0x42\n"
".emtcode OP_KIL 0x28\n"
".emtcode OP_ARL 0x02\n"
".emtcode OP_EXP 0x08\n"
".emtcode OP_LOG 0x0D\n"
".emtcode FRAGMENT_ATTRIB_COLOR 0x01\n"
".emtcode FRAGMENT_ATTRIB_TEXCOORD 0x02\n"
".emtcode FRAGMENT_ATTRIB_FOGCOORD 0x03\n"
".emtcode FRAGMENT_ATTRIB_POSITION 0x04\n"
".emtcode VERTEX_ATTRIB_POSITION 0x01\n"
".emtcode VERTEX_ATTRIB_WEIGHT 0x02\n"
".emtcode VERTEX_ATTRIB_NORMAL 0x03\n"
".emtcode VERTEX_ATTRIB_COLOR 0x04\n"
".emtcode VERTEX_ATTRIB_FOGCOORD 0x05\n"
".emtcode VERTEX_ATTRIB_TEXCOORD 0x06\n"
".emtcode VERTEX_ATTRIB_MATRIXINDEX 0x07\n"
".emtcode VERTEX_ATTRIB_GENERIC 0x08\n"
".emtcode FRAGMENT_RESULT_COLOR 0x01\n"
".emtcode FRAGMENT_RESULT_DEPTH 0x02\n"
".emtcode VERTEX_RESULT_POSITION 0x01\n"
".emtcode VERTEX_RESULT_COLOR 0x02\n"
".emtcode VERTEX_RESULT_FOGCOORD 0x03\n"
".emtcode VERTEX_RESULT_POINTSIZE 0x04\n"
".emtcode VERTEX_RESULT_TEXCOORD 0x05\n"
".emtcode TEXTARGET_1D 0x01\n"
".emtcode TEXTARGET_2D 0x02\n"
".emtcode TEXTARGET_3D 0x03\n"
".emtcode TEXTARGET_RECT 0x04\n"
".emtcode TEXTARGET_CUBE 0x05\n"
".emtcode FACE_FRONT 0x00\n"
".emtcode FACE_BACK 0x01\n"
".emtcode COLOR_PRIMARY 0x00\n"
".emtcode COLOR_SECONDARY 0x01\n"
".emtcode COMPONENT_X 0x00\n"
".emtcode COMPONENT_Y 0x01\n"
".emtcode COMPONENT_Z 0x02\n"
".emtcode COMPONENT_W 0x03\n"
".emtcode COMPONENT_0 0x04\n"
".emtcode COMPONENT_1 0x05\n"
".emtcode ARRAY_INDEX_ABSOLUTE 0x00\n"
".emtcode ARRAY_INDEX_RELATIVE 0x01\n"
".emtcode MATRIX_MODELVIEW 0x01\n"
".emtcode MATRIX_PROJECTION 0x02\n"
".emtcode MATRIX_MVP 0x03\n"
".emtcode MATRIX_TEXTURE 0x04\n"
".emtcode MATRIX_PALETTE 0x05\n"
".emtcode MATRIX_PROGRAM 0x06\n"
".emtcode MATRIX_MODIFIER_IDENTITY 0x00\n"
".emtcode MATRIX_MODIFIER_INVERSE 0x01\n"
".emtcode MATRIX_MODIFIER_TRANSPOSE 0x02\n"
".emtcode MATRIX_MODIFIER_INVTRANS 0x03\n"
".emtcode CONSTANT_SCALAR 0x01\n"
".emtcode CONSTANT_VECTOR 0x02\n"
".emtcode PROGRAM_PARAM_ENV 0x01\n"
".emtcode PROGRAM_PARAM_LOCAL 0x02\n"
".emtcode REGISTER_ATTRIB 0x01\n"
".emtcode REGISTER_PARAM 0x02\n"
".emtcode REGISTER_RESULT 0x03\n"
".emtcode REGISTER_ESTABLISHED_NAME 0x04\n"
".emtcode PARAM_NULL 0x00\n"
".emtcode PARAM_ARRAY_ELEMENT 0x01\n"
".emtcode PARAM_STATE_ELEMENT 0x02\n"
".emtcode PARAM_PROGRAM_ELEMENT 0x03\n"
".emtcode PARAM_PROGRAM_ELEMENTS 0x04\n"
".emtcode PARAM_CONSTANT 0x05\n"
".emtcode STATE_MATERIAL 0x01\n"
".emtcode STATE_LIGHT 0x02\n"
".emtcode STATE_LIGHT_MODEL 0x03\n"
".emtcode STATE_LIGHT_PROD 0x04\n"
".emtcode STATE_FOG 0x05\n"
".emtcode STATE_MATRIX_ROWS 0x06\n"
".emtcode STATE_TEX_ENV 0x07\n"
".emtcode STATE_DEPTH 0x08\n"
".emtcode STATE_TEX_GEN 0x09\n"
".emtcode STATE_CLIP_PLANE 0x0A\n"
".emtcode STATE_POINT 0x0B\n"
".emtcode MATERIAL_AMBIENT 0x01\n"
".emtcode MATERIAL_DIFFUSE 0x02\n"
".emtcode MATERIAL_SPECULAR 0x03\n"
".emtcode MATERIAL_EMISSION 0x04\n"
".emtcode MATERIAL_SHININESS 0x05\n"
".emtcode LIGHT_AMBIENT 0x01\n"
".emtcode LIGHT_DIFFUSE 0x02\n"
".emtcode LIGHT_SPECULAR 0x03\n"
".emtcode LIGHT_POSITION 0x04\n"
".emtcode LIGHT_ATTENUATION 0x05\n"
".emtcode LIGHT_HALF 0x06\n"
".emtcode LIGHT_SPOT_DIRECTION 0x07\n"
".emtcode LIGHT_MODEL_AMBIENT 0x01\n"
".emtcode LIGHT_MODEL_SCENECOLOR 0x02\n"
".emtcode LIGHT_PROD_AMBIENT 0x01\n"
".emtcode LIGHT_PROD_DIFFUSE 0x02\n"
".emtcode LIGHT_PROD_SPECULAR 0x03\n"
".emtcode TEX_ENV_COLOR 0x01\n"
".emtcode TEX_GEN_EYE 0x01\n"
".emtcode TEX_GEN_OBJECT 0x02\n"
".emtcode FOG_COLOR 0x01\n"
".emtcode FOG_PARAMS 0x02\n"
".emtcode DEPTH_RANGE 0x01\n"
".emtcode POINT_SIZE 0x01\n"
".emtcode POINT_ATTENUATION 0x02\n"
".emtcode ATTRIB 0x01\n"
".emtcode PARAM 0x02\n"
".emtcode TEMP 0x03\n"
".emtcode OUTPUT 0x04\n"
".emtcode ALIAS 0x05\n"
".emtcode ADDRESS 0x06\n"
".errtext UNKNOWN_PROGRAM_SIGNATURE \"1001: '$e_signature$': unknown program signature\"\n"
".errtext MISSING_END_OR_INVALID_STATEMENT \"1002: '$e_statement$': invalid statement\"\n"
".errtext CODE_AFTER_END \"1003: '$e_statement$': code after 'END' keyword\"\n"
".errtext INVALID_PROGRAM_OPTION \"1004: '$e_identifier$': invalid program option\"\n"
".errtext EXT_SWIZ_COMP_EXPECTED \"1005: extended swizzle component expected but '$e_token$' found\"\n"
".errtext TEX_TARGET_EXPECTED \"1006: texture target expected but '$e_token$' found\"\n"
".errtext TEXTURE_EXPECTED \"1007: 'texture' expected but '$e_identifier$' found\"\n"
".errtext SOURCE_REGISTER_EXPECTED \"1008: source register expected but '$e_token$' found\"\n"
".errtext DESTINATION_REGISTER_EXPECTED \"1009: destination register expected but '$e_token$' found\"\n"
".errtext INVALID_ADDRESS_COMPONENT \"1010: '$e_identifier$': invalid address component\"\n"
".errtext INVALID_ADDRESS_WRITEMASK \"1011: '$e_identifier$': invalid address writemask\"\n"
".errtext INVALID_COMPONENT \"1012: '$e_charordigit$': invalid component\"\n"
".errtext INVALID_SUFFIX \"1013: '$e_identifier$': invalid suffix\"\n"
".errtext INVALID_WRITEMASK \"1014: '$e_identifier$': invalid writemask\"\n"
".errtext FRAGMENT_EXPECTED \"1015: 'fragment' expected but '$e_identifier$' found\"\n"
".errtext VERTEX_EXPECTED \"1016: 'vertex' expected but '$e_identifier$' found\"\n"
".errtext INVALID_FRAGMENT_PROPERTY \"1017: '$e_identifier$': invalid fragment property\"\n"
".errtext INVALID_VERTEX_PROPERTY \"1018: '$e_identifier$': invalid vertex property\"\n"
".errtext INVALID_STATE_PROPERTY \"1019: '$e_identifier$': invalid state property\"\n"
".errtext INVALID_MATERIAL_PROPERTY \"1020: '$e_identifier$': invalid material property\"\n"
".errtext INVALID_LIGHT_PROPERTY \"1021: '$e_identifier$': invalid light property\"\n"
".errtext INVALID_SPOT_PROPERTY \"1022: '$e_identifier$': invalid spot property\"\n"
".errtext INVALID_LIGHTMODEL_PROPERTY \"1023: '$e_identifier$': invalid light model property\"\n"
".errtext INVALID_LIGHTPROD_PROPERTY \"1024: '$e_identifier$': invalid light product property\"\n"
".errtext INVALID_TEXENV_PROPERTY \"1025: '$e_identifier$': invalid texture environment property\"\n"
".errtext INVALID_TEXGEN_PROPERTY \"1026: '$e_identifier$': invalid texture generating property\"\n"
".errtext INVALID_TEXGEN_COORD \"1027: '$e_identifier$': invalid texture generating coord\"\n"
".errtext INVALID_FOG_PROPERTY \"1028: '$e_identifier$': invalid fog property\"\n"
".errtext INVALID_DEPTH_PROPERTY \"1029: '$e_identifier$': invalid depth property\"\n"
".errtext INVALID_CLIPPLANE_PROPERTY \"1030: '$e_identifier$': invalid clip plane property\"\n"
".errtext INVALID_POINT_PROPERTY \"1031: '$e_identifier$': invalid point property\"\n"
".errtext MATRIX_ROW_SELECTOR_OR_MODIFIER_EXPECTED \"1032: matrix row selector or modifier expected but '$e_token$' found\"\n"
".errtext INVALID_MATRIX_NAME \"1033: '$e_identifier$': invalid matrix name\"\n"
".errtext INVALID_PROGRAM_PROPERTY \"1034: '$e_identifier$': invalid program property\"\n"
".errtext RESULT_EXPECTED \"1035: 'result' expected but '$e_token$' found\"\n"
".errtext INVALID_RESULT_PROPERTY \"1036: '$e_identifier$': invalid result property\"\n"
".errtext INVALID_FACE_PROPERTY \"1037: '$e_identifier$': invalid face property\"\n"
".errtext INVALID_COLOR_PROPERTY \"1038: '$e_identifier$': invalid color property\"\n"
".errtext IDENTIFIER_EXPECTED \"1039: identifier expected but '$e_token$' found\"\n"
".errtext RESERVED_KEYWORD \"1040: use of reserved keyword as an identifier\"\n"
".errtext INTEGER_EXPECTED \"1041: integer value expected but '$e_token$' found\"\n"
".errtext MISSING_SEMICOLON \"1042: ';' expected but '$e_token$' found\"\n"
".errtext MISSING_COMMA \"1043: ',' expected but '$e_token$' found\"\n"
".errtext MISSING_LBRACKET \"1044: '[' expected but '$e_token$' found\"\n"
".errtext MISSING_RBRACKET \"1045: ']' expected but '$e_token$' found\"\n"
".errtext MISSING_DOT \"1046: '.' expected but '$e_token$' found\"\n"
".errtext MISSING_EQUAL \"1047: '=' expected but '$e_token$' found\"\n"
".errtext MISSING_LBRACE \"1048: '{' expected but '$e_token$' found\"\n"
".errtext MISSING_RBRACE \"1049: '}' expected but '$e_token$' found\"\n"
".errtext MISSING_DOTDOT \"1050: '..' expected but '$e_token$' found\"\n"
".errtext MISSING_FRACTION_OR_EXPONENT \"1051: missing fraction part or exponent\"\n"
".errtext MISSING_DOT_OR_EXPONENT \"1052: missing '.' or exponent\"\n"
".errtext EXPONENT_VALUE_EXPECTED \"1053: exponent value expected\"\n"
".errtext INTEGER_OUT_OF_RANGE \"1054: integer value out of range\"\n"
"program\n"
" programs .error UNKNOWN_PROGRAM_SIGNATURE .emit REVISION;\n"
"programs\n"
" frag_program_1_0 .emit FRAGMENT_PROGRAM .emit 0x01 .emit 0x00 .or\n"
" vert_program_1_0 .emit VERTEX_PROGRAM .emit 0x01 .emit 0x00;\n"
"frag_program_1_0\n"
" '!' .and '!' .and 'A' .and 'R' .and 'B' .and 'f' .and 'p' .and '1' .and '.' .and '0' .and\n"
" optional_space .and fp_optionSequence .and fp_statementSequence .and\n"
" \"END\" .error MISSING_END_OR_INVALID_STATEMENT .emit END .and optional_space .and\n"
" '\\0' .error CODE_AFTER_END;\n"
"vert_program_1_0\n"
" '!' .and '!' .and 'A' .and 'R' .and 'B' .and 'v' .and 'p' .and '1' .and '.' .and '0' .and\n"
" optional_space .and vp_optionSequence .and vp_statementSequence .and\n"
" \"END\" .error MISSING_END_OR_INVALID_STATEMENT .emit END .and optional_space .and\n"
" '\\0' .error CODE_AFTER_END;\n"
"fp_optionSequence\n"
" .loop fp_option;\n"
"vp_optionSequence\n"
" .loop vp_option;\n"
"fp_option\n"
" \"OPTION\" .emit OPTION .and space .and fp_optionString .error INVALID_PROGRAM_OPTION .and\n"
" semicolon;\n"
"vp_option\n"
" \"OPTION\" .emit OPTION .and space .and vp_optionString .error INVALID_PROGRAM_OPTION .and\n"
" semicolon;\n"
"fp_optionString\n"
" \"ARB_precision_hint_fastest\" .emit ARB_PRECISION_HINT_FASTEST .or\n"
" \"ARB_precision_hint_nicest\" .emit ARB_PRECISION_HINT_NICEST .or\n"
" \"ARB_fog_exp\" .emit ARB_FOG_EXP .or\n"
" \"ARB_fog_exp2\" .emit ARB_FOG_EXP2 .or\n"
" \"ARB_fog_linear\" .emit ARB_FOG_LINEAR;\n"
"vp_optionString\n"
" \"ARB_position_invariant\" .emit ARB_POSITION_INVARIANT;\n"
"fp_statementSequence\n"
" .loop fp_statement;\n"
"vp_statementSequence\n"
" .loop vp_statement;\n"
"fp_statement\n"
" fp_statement_1 .or fp_statement_2;\n"
"vp_statement\n"
" vp_statement_1 .or vp_statement_2;\n"
"fp_statement_1\n"
" fp_instruction .emit INSTRUCTION .emit $ .and semicolon;\n"
"fp_statement_2\n"
" fp_namingStatement .emit DECLARATION .and semicolon;\n"
"vp_statement_1\n"
" vp_instruction .emit INSTRUCTION .emit $ .and semicolon;\n"
"vp_statement_2\n"
" vp_namingStatement .emit DECLARATION .and semicolon;\n"
"fp_instruction\n"
" ALUInstruction .emit OP_ALU_INST .or\n"
" TexInstruction .emit OP_TEX_INST;\n"
"vp_instruction\n"
" ARL_instruction .emit OP_ALU_ARL .or\n"
" vp_VECTORop_instruction .emit OP_ALU_VECTOR .or\n"
" vp_SCALARop_instruction .emit OP_ALU_SCALAR .or\n"
" vp_BINSCop_instruction .emit OP_ALU_BINSC .or\n"
" vp_BINop_instruction .emit OP_ALU_BIN .or\n"
" vp_TRIop_instruction .emit OP_ALU_TRI .or\n"
" vp_SWZ_instruction .emit OP_ALU_SWZ;\n"
"ALUInstruction\n"
" fp_VECTORop_instruction .emit OP_ALU_VECTOR .or\n"
" fp_SCALARop_instruction .emit OP_ALU_SCALAR .or\n"
" fp_BINSCop_instruction .emit OP_ALU_BINSC .or\n"
" fp_BINop_instruction .emit OP_ALU_BIN .or\n"
" fp_TRIop_instruction .emit OP_ALU_TRI .or\n"
" fp_SWZ_instruction .emit OP_ALU_SWZ;\n"
"TexInstruction\n"
" SAMPLE_instruction .emit OP_TEX_SAMPLE .or\n"
" KIL_instruction .emit OP_TEX_KIL;\n"
"ARL_instruction\n"
" \"ARL\" .emit OP_ARL .and space .and maskedAddrReg .and comma .and vp_scalarSrcReg;\n"
"fp_VECTORop_instruction\n"
" fp_VECTORop .and space .and fp_maskedDstReg .and comma .and vectorSrcReg;\n"
"vp_VECTORop_instruction\n"
" vp_VECTORop .and space .and vp_maskedDstReg .and comma .and swizzleSrcReg;\n"
"fp_VECTORop\n"
" \"ABS\" .emit OP_ABS .or \"ABS_SAT\" .emit OP_ABS_SAT .or\n"
" \"FLR\" .emit OP_FLR .or \"FLR_SAT\" .emit OP_FLR_SAT .or\n"
" \"FRC\" .emit OP_FRC .or \"FRC_SAT\" .emit OP_FRC_SAT .or\n"
" \"LIT\" .emit OP_LIT .or \"LIT_SAT\" .emit OP_LIT_SAT .or\n"
" \"MOV\" .emit OP_MOV .or \"MOV_SAT\" .emit OP_MOV_SAT;\n"
"vp_VECTORop\n"
" \"ABS\" .emit OP_ABS .or\n"
" \"FLR\" .emit OP_FLR .or\n"
" \"FRC\" .emit OP_FRC .or\n"
" \"LIT\" .emit OP_LIT .or\n"
" \"MOV\" .emit OP_MOV;\n"
"fp_SCALARop_instruction\n"
" fp_SCALARop .and space .and fp_maskedDstReg .and comma .and fp_scalarSrcReg;\n"
"vp_SCALARop_instruction\n"
" vp_SCALARop .and space .and vp_maskedDstReg .and comma .and vp_scalarSrcReg;\n"
"fp_SCALARop\n"
" \"COS\" .emit OP_COS .or \"COS_SAT\" .emit OP_COS_SAT .or\n"
" \"EX2\" .emit OP_EX2 .or \"EX2_SAT\" .emit OP_EX2_SAT .or\n"
" \"LG2\" .emit OP_LG2 .or \"LG2_SAT\" .emit OP_LG2_SAT .or\n"
" \"RCP\" .emit OP_RCP .or \"RCP_SAT\" .emit OP_RCP_SAT .or\n"
" \"RSQ\" .emit OP_RSQ .or \"RSQ_SAT\" .emit OP_RSQ_SAT .or\n"
" \"SIN\" .emit OP_SIN .or \"SIN_SAT\" .emit OP_SIN_SAT .or\n"
" \"SCS\" .emit OP_SCS .or \"SCS_SAT\" .emit OP_SCS_SAT;\n"
"vp_SCALARop\n"
" \"EX2\" .emit OP_EX2 .or\n"
" \"EXP\" .emit OP_EXP .or\n"
" \"LG2\" .emit OP_LG2 .or\n"
" \"LOG\" .emit OP_LOG .or\n"
" \"RCP\" .emit OP_RCP .or\n"
" \"RSQ\" .emit OP_RSQ;\n"
"fp_BINSCop_instruction\n"
" fp_BINSCop .and space .and fp_maskedDstReg .and comma .and fp_scalarSrcReg .and comma .and\n"
" fp_scalarSrcReg;\n"
"vp_BINSCop_instruction\n"
" vp_BINSCop .and space .and vp_maskedDstReg .and comma .and vp_scalarSrcReg .and comma .and\n"
" vp_scalarSrcReg;\n"
"fp_BINSCop\n"
" \"POW\" .emit OP_POW .or \"POW_SAT\" .emit OP_POW_SAT;\n"
"vp_BINSCop\n"
" \"POW\" .emit OP_POW;\n"
"fp_BINop_instruction\n"
" fp_BINop .and space .and fp_maskedDstReg .and comma .and vectorSrcReg .and comma .and\n"
" vectorSrcReg;\n"
"vp_BINop_instruction\n"
" vp_BINop .and space .and vp_maskedDstReg .and comma .and swizzleSrcReg .and comma .and\n"
" swizzleSrcReg;\n"
"fp_BINop\n"
" \"ADD\" .emit OP_ADD .or \"ADD_SAT\" .emit OP_ADD_SAT .or\n"
" \"DP3\" .emit OP_DP3 .or \"DP3_SAT\" .emit OP_DP3_SAT .or\n"
" \"DP4\" .emit OP_DP4 .or \"DP4_SAT\" .emit OP_DP4_SAT .or\n"
" \"DPH\" .emit OP_DPH .or \"DPH_SAT\" .emit OP_DPH_SAT .or\n"
" \"DST\" .emit OP_DST .or \"DST_SAT\" .emit OP_DST_SAT .or\n"
" \"MAX\" .emit OP_MAX .or \"MAX_SAT\" .emit OP_MAX_SAT .or\n"
" \"MIN\" .emit OP_MIN .or \"MIN_SAT\" .emit OP_MIN_SAT .or\n"
" \"MUL\" .emit OP_MUL .or \"MUL_SAT\" .emit OP_MUL_SAT .or\n"
" \"SGE\" .emit OP_SGE .or \"SGE_SAT\" .emit OP_SGE_SAT .or\n"
" \"SLT\" .emit OP_SLT .or \"SLT_SAT\" .emit OP_SLT_SAT .or\n"
" \"SUB\" .emit OP_SUB .or \"SUB_SAT\" .emit OP_SUB_SAT .or\n"
" \"XPD\" .emit OP_XPD .or \"XPD_SAT\" .emit OP_XPD_SAT;\n"
"vp_BINop\n"
" \"ADD\" .emit OP_ADD .or\n"
" \"DP3\" .emit OP_DP3 .or\n"
" \"DP4\" .emit OP_DP4 .or\n"
" \"DPH\" .emit OP_DPH .or\n"
" \"DST\" .emit OP_DST .or\n"
" \"MAX\" .emit OP_MAX .or\n"
" \"MIN\" .emit OP_MIN .or\n"
" \"MUL\" .emit OP_MUL .or\n"
" \"SGE\" .emit OP_SGE .or\n"
" \"SLT\" .emit OP_SLT .or\n"
" \"SUB\" .emit OP_SUB .or\n"
" \"XPD\" .emit OP_XPD;\n"
"fp_TRIop_instruction\n"
" fp_TRIop .and space .and fp_maskedDstReg .and comma .and vectorSrcReg .and comma .and\n"
" vectorSrcReg .and comma .and vectorSrcReg;\n"
"vp_TRIop_instruction\n"
" vp_TRIop .and space .and vp_maskedDstReg .and comma .and swizzleSrcReg .and comma .and\n"
" swizzleSrcReg .and comma .and swizzleSrcReg;\n"
"fp_TRIop\n"
" \"CMP\" .emit OP_CMP .or \"CMP_SAT\" .emit OP_CMP_SAT .or\n"
" \"LRP\" .emit OP_LRP .or \"LRP_SAT\" .emit OP_LRP_SAT .or\n"
" \"MAD\" .emit OP_MAD .or \"MAD_SAT\" .emit OP_MAD_SAT;\n"
"vp_TRIop\n"
" \"MAD\" .emit OP_MAD;\n"
"fp_SWZ_instruction\n"
" SWZop .and space .and fp_maskedDstReg .and comma .and fp_srcReg .and comma .and\n"
" fp_extendedSwizzle .error EXT_SWIZ_COMP_EXPECTED;\n"
"vp_SWZ_instruction\n"
" \"SWZ\" .emit OP_SWZ .and space .and vp_maskedDstReg .and comma .and vp_srcReg .and comma .and\n"
" vp_extendedSwizzle .error EXT_SWIZ_COMP_EXPECTED;\n"
"SWZop\n"
" \"SWZ\" .emit OP_SWZ .or \"SWZ_SAT\" .emit OP_SWZ_SAT;\n"
"SAMPLE_instruction\n"
" SAMPLEop .and space .and fp_maskedDstReg .and comma .and vectorSrcReg .and comma .and\n"
" texImageUnit .and comma .and texTarget .error TEX_TARGET_EXPECTED;\n"
"SAMPLEop\n"
" \"TEX\" .emit OP_TEX .or \"TEX_SAT\" .emit OP_TEX_SAT .or\n"
" \"TXB\" .emit OP_TXB .or \"TXB_SAT\" .emit OP_TXB_SAT .or\n"
" \"TXP\" .emit OP_TXP .or \"TXP_SAT\" .emit OP_TXP_SAT;\n"
"KIL_instruction\n"
" \"KIL\" .emit OP_KIL .and space .and vectorSrcReg;\n"
"texImageUnit\n"
" \"texture\" .error TEXTURE_EXPECTED .and optTexImageUnitNum;\n"
"texTarget\n"
" \"1D\" .emit TEXTARGET_1D .or\n"
" \"2D\" .emit TEXTARGET_2D .or\n"
" \"3D\" .emit TEXTARGET_3D .or\n"
" \"RECT\" .emit TEXTARGET_RECT .or\n"
" \"CUBE\" .emit TEXTARGET_CUBE;\n"
"optTexImageUnitNum\n"
" optTexImageUnitNum_1 .or .true .emit 0x00;\n"
"optTexImageUnitNum_1\n"
" lbracket_ne .and texImageUnitNum .and rbracket;\n"
"texImageUnitNum\n"
" integer;\n"
"fp_scalarSrcReg\n"
" optionalSign .and fp_srcReg .and fp_scalarSuffix;\n"
"vp_scalarSrcReg\n"
" optionalSign .and vp_srcReg .and vp_scalarSuffix;\n"
"swizzleSrcReg\n"
" optionalSign .and vp_srcReg .and swizzleSuffix;\n"
"vectorSrcReg\n"
" optionalSign .and fp_srcReg .and optionalSuffix;\n"
"fp_maskedDstReg\n"
" fp_dstReg .and fp_optionalMask;\n"
"vp_maskedDstReg\n"
" vp_dstReg .and vp_optionalMask;\n"
"maskedAddrReg\n"
" addrReg .and addrWriteMask;\n"
"fp_extendedSwizzle\n"
" xyzwExtendedSwizzle .or rgbaExtendedSwizzle;\n"
"vp_extendedSwizzle\n"
" extSwizComp .and comma .and\n"
" extSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" extSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" extSwizComp .error EXT_SWIZ_COMP_EXPECTED;\n"
"xyzwExtendedSwizzle\n"
" xyzwExtSwizComp .and comma .and\n"
" xyzwExtSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" xyzwExtSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" xyzwExtSwizComp .error EXT_SWIZ_COMP_EXPECTED;\n"
"rgbaExtendedSwizzle\n"
" rgbaExtSwizComp .and comma .and\n"
" rgbaExtSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" rgbaExtSwizComp .error EXT_SWIZ_COMP_EXPECTED .and comma .and\n"
" rgbaExtSwizComp .error EXT_SWIZ_COMP_EXPECTED;\n"
"xyzwExtSwizComp\n"
" optionalSign .and xyzwExtSwizSel;\n"
"rgbaExtSwizComp\n"
" optionalSign .and rgbaExtSwizSel;\n"
"extSwizComp\n"
" optionalSign .and extSwizSel;\n"
"xyzwExtSwizSel\n"
" \"0\" .emit COMPONENT_0 .or \"1\" .emit COMPONENT_1 .or xyzwComponent_single;\n"
"rgbaExtSwizSel\n"
" \"0\" .emit COMPONENT_0 .or \"1\" .emit COMPONENT_1 .or rgbaComponent_single;\n"
"extSwizSel\n"
" \"0\" .emit COMPONENT_0 .or \"1\" .emit COMPONENT_1 .or vp_component_single;\n"
"fp_srcReg\n"
" fp_srcReg_1 .error SOURCE_REGISTER_EXPECTED;\n"
"vp_srcReg\n"
" vp_srcReg_1 .error SOURCE_REGISTER_EXPECTED;\n"
"fp_srcReg_1\n"
" fragmentAttribReg .emit REGISTER_ATTRIB .or\n"
" fp_progParamReg .emit REGISTER_PARAM .or\n"
" fp_temporaryReg .emit REGISTER_ESTABLISHED_NAME;\n"
"vp_srcReg_1\n"
" vertexAttribReg .emit REGISTER_ATTRIB .or\n"
" vp_progParamReg .emit REGISTER_PARAM .or\n"
" vp_temporaryReg .emit REGISTER_ESTABLISHED_NAME;\n"
"fp_dstReg\n"
" fp_dstReg_1 .error DESTINATION_REGISTER_EXPECTED;\n"
"vp_dstReg\n"
" vp_dstReg_1 .error DESTINATION_REGISTER_EXPECTED;\n"
"fp_dstReg_1\n"
" fragmentResultReg .emit REGISTER_RESULT .or\n"
" fp_temporaryReg .emit REGISTER_ESTABLISHED_NAME;\n"
"vp_dstReg_1\n"
" vertexResultReg .emit REGISTER_RESULT .or\n"
" vp_temporaryReg .emit REGISTER_ESTABLISHED_NAME;\n"
"fragmentAttribReg\n"
" fragAttribBinding;\n"
"vertexAttribReg\n"
" vtxAttribBinding;\n"
"fp_temporaryReg\n"
" fp_establishedName;\n"
"vp_temporaryReg\n"
" vp_establishedName;\n"
"fp_progParamReg\n"
" fp_paramSingleItemUse .or fp_progParamReg_1;\n"
"vp_progParamReg\n"
" vp_paramSingleItemUse .or vp_progParamReg_1;\n"
"fp_progParamReg_1\n"
" fp_progParamArray .emit PARAM_ARRAY_ELEMENT .and lbracket_ne .and progParamArrayAbs .and\n"
" rbracket;\n"
"vp_progParamReg_1\n"
" vp_progParamArray .emit PARAM_ARRAY_ELEMENT .and lbracket_ne .and progParamArrayMem .and\n"
" rbracket;\n"
"fp_progParamArray\n"
" fp_establishedName;\n"
"vp_progParamArray\n"
" vp_establishedName;\n"
"progParamArrayMem\n"
" progParamArrayAbs .or progParamArrayRel;\n"
"progParamArrayAbs\n"
" integer_ne .emit ARRAY_INDEX_ABSOLUTE;\n"
"progParamArrayRel\n"
" addrReg .emit ARRAY_INDEX_RELATIVE .and addrComponent .and addrRegRelOffset;\n"
"addrRegRelOffset\n"
" addrRegRelOffset_1 .or addrRegRelOffset_2 .or .true .emit 0x00;\n"
"addrRegRelOffset_1\n"
" plus_ne .and addrRegPosOffset;\n"
"addrRegRelOffset_2\n"
" minus_ne .and addrRegNegOffset;\n"
"addrRegPosOffset\n"
" integer_0_63;\n"
"addrRegNegOffset\n"
" integer_0_64;\n"
"fragmentResultReg\n"
" fp_resultBinding;\n"
"vertexResultReg\n"
" vp_resultBinding;\n"
"addrReg\n"
" vp_establishedName;\n"
"addrComponent\n"
" dot .and \"x\" .error INVALID_ADDRESS_COMPONENT .emit COMPONENT_X .emit COMPONENT_X\n"
" .emit COMPONENT_X .emit COMPONENT_X;\n"
"addrWriteMask\n"
" dot .and \"x\" .error INVALID_ADDRESS_WRITEMASK .emit 0x08;\n"
"fp_scalarSuffix\n"
" dot .and fp_component_single .error INVALID_COMPONENT;\n"
"vp_scalarSuffix\n"
" dot .and vp_component_single .error INVALID_COMPONENT;\n"
"swizzleSuffix\n"
" swizzleSuffix_1 .or .true .emit COMPONENT_X .emit COMPONENT_Y .emit COMPONENT_Z\n"
" .emit COMPONENT_W;\n"
"swizzleSuffix_1\n"
" dot_ne .and swizzleSuffix_2 .error INVALID_SUFFIX;\n"
"swizzleSuffix_2\n"
" swizzleSuffix_3 .or swizzleSuffix_4;\n"
"swizzleSuffix_3\n"
" vp_component_multi .and vp_component_multi .and vp_component_multi .error INVALID_COMPONENT .and\n"
" vp_component_multi .error INVALID_COMPONENT;\n"
"swizzleSuffix_4\n"
" \"x\" .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .or\n"
" \"y\" .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .or\n"
" \"z\" .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .or\n"
" \"w\" .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W;\n"
"optionalSuffix\n"
" optionalSuffix_1 .or .true .emit COMPONENT_X .emit COMPONENT_Y .emit COMPONENT_Z\n"
" .emit COMPONENT_W;\n"
"optionalSuffix_1\n"
" dot_ne .and optionalSuffix_2 .error INVALID_SUFFIX;\n"
"optionalSuffix_2\n"
" optionalSuffix_3 .or optionalSuffix_4 .or optionalSuffix_5;\n"
"optionalSuffix_3\n"
" xyzwComponent_multi .and xyzwComponent_multi .and\n"
" xyzwComponent_multi .error INVALID_COMPONENT .and xyzwComponent_multi .error INVALID_COMPONENT;\n"
"optionalSuffix_4\n"
" rgbaComponent_multi .and rgbaComponent_multi .and\n"
" rgbaComponent_multi .error INVALID_COMPONENT .and rgbaComponent_multi .error INVALID_COMPONENT;\n"
"optionalSuffix_5\n"
" \"x\" .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .or\n"
" \"y\" .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .or\n"
" \"z\" .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .or\n"
" \"w\" .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W .or\n"
" \"r\" .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .emit COMPONENT_X .or\n"
" \"g\" .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .emit COMPONENT_Y .or\n"
" \"b\" .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .emit COMPONENT_Z .or\n"
" \"a\" .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W .emit COMPONENT_W;\n"
"fp_component_single\n"
" xyzwComponent_single .or rgbaComponent_single;\n"
"vp_component_multi\n"
" 'x' .emit COMPONENT_X .or 'y' .emit COMPONENT_Y .or 'z' .emit COMPONENT_Z .or\n"
" 'w' .emit COMPONENT_W;\n"
"vp_component_single\n"
" \"x\" .emit COMPONENT_X .or \"y\" .emit COMPONENT_Y .or \"z\" .emit COMPONENT_Z .or\n"
" \"w\" .emit COMPONENT_W;\n"
"xyzwComponent_multi\n"
" 'x' .emit COMPONENT_X .or 'y' .emit COMPONENT_Y .or 'z' .emit COMPONENT_Z .or\n"
" 'w' .emit COMPONENT_W;\n"
"xyzwComponent_single\n"
" \"x\" .emit COMPONENT_X .or \"y\" .emit COMPONENT_Y .or \"z\" .emit COMPONENT_Z .or\n"
" \"w\" .emit COMPONENT_W;\n"
"rgbaComponent_multi\n"
" 'r' .emit COMPONENT_X .or 'g' .emit COMPONENT_Y .or 'b' .emit COMPONENT_Z .or\n"
" 'a' .emit COMPONENT_W;\n"
"rgbaComponent_single\n"
" \"r\" .emit COMPONENT_X .or \"g\" .emit COMPONENT_Y .or \"b\" .emit COMPONENT_Z .or\n"
" \"a\" .emit COMPONENT_W;\n"
"fp_optionalMask\n"
" xyzwMask .or rgbaMask .or .true .emit 0x0F;\n"
"vp_optionalMask\n"
" xyzwMask .or .true .emit 0x0F;\n"
"xyzwMask\n"
" dot_ne .and xyzwMask_1 .error INVALID_WRITEMASK;\n"
"xyzwMask_1\n"
" \"xyzw\" .emit 0x0F .or \"xyz\" .emit 0x0E .or \"xyw\" .emit 0x0D .or \"xy\" .emit 0x0C .or\n"
" \"xzw\" .emit 0x0B .or \"xz\" .emit 0x0A .or \"xw\" .emit 0x09 .or \"x\" .emit 0x08 .or\n"
" \"yzw\" .emit 0x07 .or \"yz\" .emit 0x06 .or \"yw\" .emit 0x05 .or \"y\" .emit 0x04 .or\n"
" \"zw\" .emit 0x03 .or \"z\" .emit 0x02 .or \"w\" .emit 0x01;\n"
"rgbaMask\n"
" dot_ne .and rgbaMask_1 .error INVALID_WRITEMASK;\n"
"rgbaMask_1\n"
" \"rgba\" .emit 0x0F .or \"rgb\" .emit 0x0E .or \"rga\" .emit 0x0D .or \"rg\" .emit 0x0C .or\n"
" \"rba\" .emit 0x0B .or \"rb\" .emit 0x0A .or \"ra\" .emit 0x09 .or \"r\" .emit 0x08 .or\n"
" \"gba\" .emit 0x07 .or \"gb\" .emit 0x06 .or \"ga\" .emit 0x05 .or \"g\" .emit 0x04 .or\n"
" \"ba\" .emit 0x03 .or \"b\" .emit 0x02 .or \"a\" .emit 0x01;\n"
"fp_namingStatement\n"
" fp_ATTRIB_statement .emit ATTRIB .or\n"
" fp_PARAM_statement .emit PARAM .or\n"
" fp_TEMP_statement .emit TEMP .or\n"
" fp_OUTPUT_statement .emit OUTPUT .or\n"
" fp_ALIAS_statement .emit ALIAS;\n"
"vp_namingStatement\n"
" vp_ATTRIB_statement .emit ATTRIB .or\n"
" vp_PARAM_statement .emit PARAM .or\n"
" vp_TEMP_statement .emit TEMP .or\n"
" ADDRESS_statement .emit ADDRESS .or\n"
" vp_OUTPUT_statement .emit OUTPUT .or\n"
" vp_ALIAS_statement .emit ALIAS;\n"
"fp_ATTRIB_statement\n"
" \"ATTRIB\" .and space .and fp_establishName .and equal .and\n"
" fragAttribBinding .error FRAGMENT_EXPECTED;\n"
"vp_ATTRIB_statement\n"
" \"ATTRIB\" .and space .and vp_establishName .and equal .and\n"
" vtxAttribBinding .error VERTEX_EXPECTED;\n"
"fragAttribBinding\n"
" \"fragment\" .and dot .and fragAttribItem .error INVALID_FRAGMENT_PROPERTY;\n"
"vtxAttribBinding\n"
" \"vertex\" .and dot .and vtxAttribItem .error INVALID_VERTEX_PROPERTY;\n"
"fragAttribItem\n"
" fragAttribItem_1 .emit FRAGMENT_ATTRIB_COLOR .or\n"
" fragAttribItem_2 .emit FRAGMENT_ATTRIB_TEXCOORD .or\n"
" \"fogcoord\" .emit FRAGMENT_ATTRIB_FOGCOORD .or\n"
" \"position\" .emit FRAGMENT_ATTRIB_POSITION;\n"
"fragAttribItem_1\n"
" \"color\" .and optColorType;\n"
"fragAttribItem_2\n"
" \"texcoord\" .and optTexCoordNum;\n"
"vtxAttribItem\n"
" \"position\" .emit VERTEX_ATTRIB_POSITION .or\n"
" vtxAttribItem_1 .emit VERTEX_ATTRIB_WEIGHT .or\n"
" \"normal\" .emit VERTEX_ATTRIB_NORMAL .or\n"
" vtxAttribItem_2 .emit VERTEX_ATTRIB_COLOR .or\n"
" \"fogcoord\" .emit VERTEX_ATTRIB_FOGCOORD .or\n"
" vtxAttribItem_3 .emit VERTEX_ATTRIB_TEXCOORD .or\n"
" vtxAttribItem_4 .emit VERTEX_ATTRIB_MATRIXINDEX .or\n"
" vtxAttribItem_5 .emit VERTEX_ATTRIB_GENERIC;\n"
"vtxAttribItem_1\n"
" \"weight\" .and vtxOptWeightNum;\n"
"vtxAttribItem_2\n"
" \"color\" .and optColorType;\n"
"vtxAttribItem_3\n"
" \"texcoord\" .and optTexCoordNum;\n"
"vtxAttribItem_4\n"
" \"matrixindex\" .and lbracket .and vtxWeightNum .and rbracket;\n"
"vtxAttribItem_5\n"
" \"attrib\" .and lbracket .and vtxAttribNum .and rbracket;\n"
"vtxAttribNum\n"
" integer;\n"
"vtxOptWeightNum\n"
" vtxOptWeightNum_1 .or .true .emit 0x00;\n"
"vtxOptWeightNum_1\n"
" lbracket_ne .and vtxWeightNum .and rbracket;\n"
"vtxWeightNum\n"
" integer;\n"
"fp_PARAM_statement\n"
" fp_PARAM_multipleStmt .or fp_PARAM_singleStmt;\n"
"vp_PARAM_statement\n"
" vp_PARAM_multipleStmt .or vp_PARAM_singleStmt;\n"
"fp_PARAM_singleStmt\n"
" \"PARAM\" .and space .and fp_establishName .and .true .emit 0x00 .and fp_paramSingleInit .and\n"
" .true .emit PARAM_NULL;\n"
"vp_PARAM_singleStmt\n"
" \"PARAM\" .and space .and vp_establishName .and .true .emit 0x00 .and vp_paramSingleInit .and\n"
" .true .emit PARAM_NULL;\n"
"fp_PARAM_multipleStmt\n"
" \"PARAM\" .and space .and fp_establishName .and lbracket_ne .and optArraySize .and rbracket .and\n"
" fp_paramMultipleInit .and .true .emit PARAM_NULL;\n"
"vp_PARAM_multipleStmt\n"
" \"PARAM\" .and space .and vp_establishName .and lbracket_ne .and optArraySize .and rbracket .and\n"
" vp_paramMultipleInit .and .true .emit PARAM_NULL;\n"
"optArraySize\n"
" optional_integer;\n"
"fp_paramSingleInit\n"
" equal .and fp_paramSingleItemDecl;\n"
"vp_paramSingleInit\n"
" equal .and vp_paramSingleItemDecl;\n"
"fp_paramMultipleInit\n"
" equal .and lbrace .and fp_paramMultInitList .and rbrace;\n"
"vp_paramMultipleInit\n"
" equal .and lbrace .and vp_paramMultInitList .and rbrace;\n"
"fp_paramMultInitList\n"
" fp_paramMultInitList_1 .or fp_paramMultipleItem;\n"
"vp_paramMultInitList\n"
" vp_paramMultInitList_1 .or vp_paramMultipleItem;\n"
"fp_paramMultInitList_1\n"
" fp_paramMultipleItem .and comma_ne .and fp_paramMultInitList;\n"
"vp_paramMultInitList_1\n"
" vp_paramMultipleItem .and comma_ne .and vp_paramMultInitList;\n"
"fp_paramSingleItemDecl\n"
" fp_stateSingleItem .emit PARAM_STATE_ELEMENT .or\n"
" programSingleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstDecl .emit PARAM_CONSTANT;\n"
"vp_paramSingleItemDecl\n"
" vp_stateSingleItem .emit PARAM_STATE_ELEMENT .or\n"
" programSingleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstDecl .emit PARAM_CONSTANT;\n"
"fp_paramSingleItemUse\n"
" fp_stateSingleItem .emit PARAM_STATE_ELEMENT .or\n"
" programSingleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstUse .emit PARAM_CONSTANT;\n"
"vp_paramSingleItemUse\n"
" vp_stateSingleItem .emit PARAM_STATE_ELEMENT .or\n"
" programSingleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstUse .emit PARAM_CONSTANT;\n"
"fp_paramMultipleItem\n"
" fp_stateMultipleItem .emit PARAM_STATE_ELEMENT .or\n"
" programMultipleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstDecl .emit PARAM_CONSTANT;\n"
"vp_paramMultipleItem\n"
" vp_stateMultipleItem .emit PARAM_STATE_ELEMENT .or\n"
" programMultipleItem .emit PARAM_PROGRAM_ELEMENT .or\n"
" paramConstDecl .emit PARAM_CONSTANT;\n"
"fp_stateMultipleItem\n"
" stateMultipleItem_1 .or fp_stateSingleItem;\n"
"vp_stateMultipleItem\n"
" stateMultipleItem_1 .or vp_stateSingleItem;\n"
"stateMultipleItem_1\n"
" \"state\" .and dot .and stateMatrixRows .emit STATE_MATRIX_ROWS;\n"
"fp_stateSingleItem\n"
" \"state\" .and dot .and fp_stateSingleItem_1 .error INVALID_STATE_PROPERTY;\n"
"vp_stateSingleItem\n"
" \"state\" .and dot .and vp_stateSingleItem_1 .error INVALID_STATE_PROPERTY;\n"
"fp_stateSingleItem_1\n"
" stateSingleItem_1 .or stateSingleItem_2 .or stateSingleItem_3 .or stateSingleItem_4 .or\n"
" stateSingleItem_5 .or stateSingleItem_7 .or stateSingleItem_8 .or stateSingleItem_11;\n"
"vp_stateSingleItem_1\n"
" stateSingleItem_1 .or stateSingleItem_2 .or stateSingleItem_3 .or stateSingleItem_4 .or\n"
" stateSingleItem_6 .or stateSingleItem_7 .or stateSingleItem_9 .or stateSingleItem_10 .or\n"
" stateSingleItem_11;\n"
"stateSingleItem_1\n"
" stateMaterialItem .emit STATE_MATERIAL;\n"
"stateSingleItem_2\n"
" stateLightItem .emit STATE_LIGHT;\n"
"stateSingleItem_3\n"
" stateLightModelItem .emit STATE_LIGHT_MODEL;\n"
"stateSingleItem_4\n"
" stateLightProdItem .emit STATE_LIGHT_PROD;\n"
"stateSingleItem_5\n"
" stateTexEnvItem .emit STATE_TEX_ENV;\n"
"stateSingleItem_6\n"
" stateTexGenItem .emit STATE_TEX_GEN;\n"
"stateSingleItem_7\n"
" stateFogItem .emit STATE_FOG;\n"
"stateSingleItem_8\n"
" stateDepthItem .emit STATE_DEPTH;\n"
"stateSingleItem_9\n"
" stateClipPlaneItem .emit STATE_CLIP_PLANE;\n"
"stateSingleItem_10\n"
" statePointItem .emit STATE_POINT;\n"
"stateSingleItem_11\n"
" stateMatrixRow .emit STATE_MATRIX_ROWS;\n"
"stateMaterialItem\n"
" \"material\" .and optFaceType .and dot .and stateMatProperty .error INVALID_MATERIAL_PROPERTY;\n"
"stateMatProperty\n"
" \"ambient\" .emit MATERIAL_AMBIENT .or\n"
" \"diffuse\" .emit MATERIAL_DIFFUSE .or\n"
" \"specular\" .emit MATERIAL_SPECULAR .or\n"
" \"emission\" .emit MATERIAL_EMISSION .or\n"
" \"shininess\" .emit MATERIAL_SHININESS;\n"
"stateLightItem\n"
" \"light\" .and lbracket .and stateLightNumber .and rbracket .and dot .and\n"
" stateLightProperty .error INVALID_LIGHT_PROPERTY;\n"
"stateLightProperty\n"
" \"ambient\" .emit LIGHT_AMBIENT .or\n"
" \"diffuse\" .emit LIGHT_DIFFUSE .or\n"
" \"specular\" .emit LIGHT_SPECULAR .or\n"
" \"position\" .emit LIGHT_POSITION .or\n"
" \"attenuation\" .emit LIGHT_ATTENUATION .or\n"
" stateLightProperty_1 .emit LIGHT_SPOT_DIRECTION .or\n"
" \"half\" .emit LIGHT_HALF;\n"
"stateLightProperty_1\n"
" \"spot\" .and dot .and stateSpotProperty .error INVALID_SPOT_PROPERTY;\n"
"stateSpotProperty\n"
" \"direction\";\n"
"stateLightModelItem\n"
" \"lightmodel\" .and stateLModProperty .error INVALID_LIGHTMODEL_PROPERTY;\n"
"stateLModProperty\n"
" stateLModProperty_1 .or stateLModProperty_2;\n"
"stateLModProperty_1\n"
" dot .and \"ambient\" .emit LIGHT_MODEL_AMBIENT;\n"
"stateLModProperty_2\n"
" stateLModProperty_2A .or stateLModProperty_2B .or stateLModProperty_2C;\n"
"stateLModProperty_2A\n"
" dot .and \"front\" .and dot .and \"scenecolor\" .emit LIGHT_MODEL_SCENECOLOR .emit FACE_FRONT;\n"
"stateLModProperty_2B\n"
" dot .and \"back\" .and dot .and \"scenecolor\" .emit LIGHT_MODEL_SCENECOLOR .emit FACE_BACK;\n"
"stateLModProperty_2C\n"
" dot .and \"scenecolor\" .emit LIGHT_MODEL_SCENECOLOR .emit FACE_FRONT;\n"
"stateLightProdItem\n"
" \"lightprod\" .and lbracket .and stateLightNumber .and rbracket .and optFaceType .and dot .and\n"
" stateLProdProperty .error INVALID_LIGHTPROD_PROPERTY;\n"
"stateLProdProperty\n"
" \"ambient\" .emit LIGHT_PROD_AMBIENT .or\n"
" \"diffuse\" .emit LIGHT_PROD_DIFFUSE .or\n"
" \"specular\" .emit LIGHT_PROD_SPECULAR;\n"
"stateLightNumber\n"
" integer;\n"
"stateTexEnvItem\n"
" \"texenv\" .and optLegacyTexUnitNum .and dot .and\n"
" stateTexEnvProperty .error INVALID_TEXENV_PROPERTY;\n"
"stateTexEnvProperty\n"
" \"color\" .emit TEX_ENV_COLOR;\n"
"optLegacyTexUnitNum\n"
" lbracket_ne .and legacyTexUnitNum .and rbracket;\n"
"legacyTexUnitNum\n"
" integer;\n"
"stateTexGenItem\n"
" \"texgen\" .and optTexCoordNum .and dot .and stateTexGenType .error INVALID_TEXGEN_PROPERTY .and\n"
" dot .and stateTexGenCoord .error INVALID_TEXGEN_COORD;\n"
"stateTexGenType\n"
" \"eye\" .emit TEX_GEN_EYE .or\n"
" \"object\" .emit TEX_GEN_OBJECT;\n"
"stateTexGenCoord\n"
" \"s\" .emit COMPONENT_X .or\n"
" \"t\" .emit COMPONENT_Y .or\n"
" \"r\" .emit COMPONENT_Z .or\n"
" \"q\" .emit COMPONENT_W;\n"
"stateFogItem\n"
" \"fog\" .and dot .and stateFogProperty .error INVALID_FOG_PROPERTY;\n"
"stateFogProperty\n"
" \"color\" .emit FOG_COLOR .or\n"
" \"params\" .emit FOG_PARAMS;\n"
"stateDepthItem\n"
" \"depth\" .and dot .and stateDepthProperty .error INVALID_DEPTH_PROPERTY;\n"
"stateDepthProperty\n"
" \"range\" .emit DEPTH_RANGE;\n"
"stateClipPlaneItem\n"
" \"clip\" .and lbracket .and stateClipPlaneNum .and rbracket .and dot .and\n"
" \"plane\" .error INVALID_CLIPPLANE_PROPERTY;\n"
"stateClipPlaneNum\n"
" integer;\n"
"statePointItem\n"
" \"point\" .and dot .and statePointProperty .error INVALID_POINT_PROPERTY;\n"
"statePointProperty\n"
" \"size\" .emit POINT_SIZE .or\n"
" \"attenuation\" .emit POINT_ATTENUATION;\n"
"stateMatrixRow\n"
" stateMatrixItem .and dot .and \"row\" .error MATRIX_ROW_SELECTOR_OR_MODIFIER_EXPECTED .and\n"
" lbracket .and stateMatrixRowNum .and rbracket .emit 0x0;\n"
"stateMatrixRows\n"
" stateMatrixItem .and optMatrixRows;\n"
"optMatrixRows\n"
" optMatrixRows_1 .or .true .emit 0x0 .emit '3' .emit 0x0 .emit $;\n"
"optMatrixRows_1\n"
" dot_ne .and \"row\" .error MATRIX_ROW_SELECTOR_OR_MODIFIER_EXPECTED .and lbracket .and\n"
" stateMatrixRowNum .and dotdot .and stateMatrixRowNum .and rbracket;\n"
"stateMatrixItem\n"
" \"matrix\" .and dot .and stateMatrixName .error INVALID_MATRIX_NAME .and stateOptMatModifier;\n"
"stateOptMatModifier\n"
" stateOptMatModifier_1 .or .true .emit MATRIX_MODIFIER_IDENTITY;\n"
"stateOptMatModifier_1\n"
" dot_ne .and stateMatModifier;\n"
"stateMatModifier\n"
" \"inverse\" .emit MATRIX_MODIFIER_INVERSE .or\n"
" \"transpose\" .emit MATRIX_MODIFIER_TRANSPOSE .or\n"
" \"invtrans\" .emit MATRIX_MODIFIER_INVTRANS;\n"
"stateMatrixRowNum\n"
" integer_0_3;\n"
"stateMatrixName\n"
" stateMatrixName_1_1 .emit MATRIX_MODELVIEW .or\n"
" \"projection\" .emit MATRIX_PROJECTION .or\n"
" \"mvp\" .emit MATRIX_MVP .or\n"
" stateMatrixName_1_2 .emit MATRIX_TEXTURE .or\n"
" stateMatrixName_1_3 .emit MATRIX_PALETTE .or\n"
" stateMatrixName_1_4 .emit MATRIX_PROGRAM;\n"
"stateMatrixName_1_1\n"
" \"modelview\" .and stateOptModMatNum;\n"
"stateMatrixName_1_2\n"
" \"texture\" .and optTexCoordNum;\n"
"stateMatrixName_1_3\n"
" \"palette\" .and lbracket .and statePaletteMatNum .and rbracket;\n"
"stateMatrixName_1_4\n"
" \"program\" .and lbracket .and stateProgramMatNum .and rbracket;\n"
"stateOptModMatNum\n"
" stateOptModMatNum_1 .or .true .emit 0x00;\n"
"stateOptModMatNum_1\n"
" lbracket_ne .and stateModMatNum .and rbracket;\n"
"stateModMatNum\n"
" integer;\n"
"optTexCoordNum\n"
" optTexCoordNum_1 .or .true .emit 0x00;\n"
"optTexCoordNum_1\n"
" lbracket_ne .and texCoordNum .and rbracket;\n"
"texCoordNum\n"
" integer;\n"
"statePaletteMatNum\n"
" integer;\n"
"stateProgramMatNum\n"
" integer;\n"
"programSingleItem\n"
" \"program\" .and dot .and programSingleItem_1 .error INVALID_PROGRAM_PROPERTY;\n"
"programSingleItem_1\n"
" progEnvParam .or progLocalParam;\n"
"programMultipleItem\n"
" \"program\" .and dot .and programMultipleItem_1 .error INVALID_PROGRAM_PROPERTY;\n"
"programMultipleItem_1\n"
" progEnvParams .or progLocalParams;\n"
"progEnvParams\n"
" \"env\" .emit PROGRAM_PARAM_ENV .and lbracket .and progEnvParamNums .and rbracket;\n"
"progEnvParamNums\n"
" progEnvParamNums_1 .or progEnvParamNums_2;\n"
"progEnvParamNums_1\n"
" progEnvParamNum .and dotdot_ne .and progEnvParamNum;\n"
"progEnvParamNums_2\n"
" progEnvParamNum .and .true .emit 0x00;\n"
"progEnvParam\n"
" \"env\" .emit PROGRAM_PARAM_ENV .and lbracket .and progEnvParamNum .and rbracket .emit 0x00;\n"
"progLocalParams\n"
" \"local\" .emit PROGRAM_PARAM_LOCAL .and lbracket .and progLocalParamNums .and rbracket;\n"
"progLocalParamNums\n"
" progLocalParamNums_1 .or progLocalParamNums_2;\n"
"progLocalParamNums_1\n"
" progLocalParamNum .and dotdot_ne .and progLocalParamNum;\n"
"progLocalParamNums_2\n"
" progLocalParamNum .and .true .emit 0x00;\n"
"progLocalParam\n"
" \"local\" .emit PROGRAM_PARAM_LOCAL .and lbracket .and progLocalParamNum .and rbracket .emit 0x00;\n"
"progEnvParamNum\n"
" integer;\n"
"progLocalParamNum\n"
" integer;\n"
"paramConstDecl\n"
" paramConstScalarDecl .emit CONSTANT_SCALAR .or paramConstVector .emit CONSTANT_VECTOR;\n"
"paramConstUse\n"
" paramConstScalarUse .emit CONSTANT_SCALAR .or paramConstVector .emit CONSTANT_VECTOR;\n"
"paramConstScalarDecl\n"
" signedFloatConstant;\n"
"paramConstScalarUse\n"
" floatConstant;\n"
"paramConstVector\n"
" paramConstVector_4 .emit 0x04 .or paramConstVector_3 .emit 0x03 .or\n"
" paramConstVector_2 .emit 0x02 .or paramConstVector_1 .emit 0x01;\n"
"paramConstVector_1\n"
" lbrace_ne .and signedFloatConstant .and rbrace;\n"
"paramConstVector_2\n"
" lbrace_ne .and signedFloatConstant .and comma_ne .and signedFloatConstant .and rbrace;\n"
"paramConstVector_3\n"
" lbrace_ne .and signedFloatConstant .and comma_ne .and signedFloatConstant .and comma_ne .and\n"
" signedFloatConstant .and rbrace;\n"
"paramConstVector_4\n"
" lbrace_ne .and signedFloatConstant .and comma_ne .and signedFloatConstant .and comma_ne .and\n"
" signedFloatConstant .and comma_ne .and signedFloatConstant .and rbrace;\n"
"signedFloatConstant\n"
" optionalSign .and floatConstant;\n"
"floatConstant\n"
" float;\n"
"optionalSign\n"
" optional_sign_ne;\n"
"fp_TEMP_statement\n"
" \"TEMP\" .and space .and fp_varNameList .and .true .emit 0x00;\n"
"vp_TEMP_statement\n"
" \"TEMP\" .and space .and vp_varNameList .and .true .emit 0x00;\n"
"ADDRESS_statement\n"
" \"ADDRESS\" .and space .and vp_varNameList .and .true .emit 0x00;\n"
"fp_varNameList\n"
" fp_varNameList_1 .or fp_establishName;\n"
"vp_varNameList\n"
" vp_varNameList_1 .or vp_establishName;\n"
"fp_varNameList_1\n"
" fp_establishName .and comma_ne .and fp_varNameList;\n"
"vp_varNameList_1\n"
" vp_establishName .and comma_ne .and vp_varNameList;\n"
"fp_OUTPUT_statement\n"
" \"OUTPUT\" .and space .and fp_establishName .and equal .and\n"
" fp_resultBinding .error RESULT_EXPECTED;\n"
"vp_OUTPUT_statement\n"
" \"OUTPUT\" .and space .and vp_establishName .and equal .and\n"
" vp_resultBinding .error RESULT_EXPECTED;\n"
"fp_resultBinding\n"
" \"result\" .and dot .and fp_resultBinding_1 .error INVALID_RESULT_PROPERTY;\n"
"vp_resultBinding\n"
" \"result\" .and dot .and vp_resultBinding_1 .error INVALID_RESULT_PROPERTY;\n"
"fp_resultBinding_1\n"
" \"color\" .emit FRAGMENT_RESULT_COLOR .or\n"
" \"depth\" .emit FRAGMENT_RESULT_DEPTH;\n"
"vp_resultBinding_1\n"
" \"position\" .emit VERTEX_RESULT_POSITION .or\n"
" resultColBinding .emit VERTEX_RESULT_COLOR .or\n"
" \"fogcoord\" .emit VERTEX_RESULT_FOGCOORD .or\n"
" \"pointsize\" .emit VERTEX_RESULT_POINTSIZE .or\n"
" vp_resultBinding_2 .emit VERTEX_RESULT_TEXCOORD;\n"
"vp_resultBinding_2\n"
" \"texcoord\" .and optTexCoordNum;\n"
"resultColBinding\n"
" \"color\" .and optFaceType .and optColorType;\n"
"optFaceType\n"
" FaceType .or .true .emit FACE_FRONT;\n"
"FaceType\n"
" dot_ne .and FaceProperty;\n"
"FaceProperty\n"
" \"front\" .emit FACE_FRONT .or \"back\" .emit FACE_BACK;\n"
"optColorType\n"
" ColorType .or .true .emit COLOR_PRIMARY;\n"
"ColorType\n"
" dot_ne .and ColorProperty;\n"
"ColorProperty\n"
" \"primary\" .emit COLOR_PRIMARY .or \"secondary\" .emit COLOR_SECONDARY;\n"
"fp_ALIAS_statement\n"
" \"ALIAS\" .and space .and fp_establishName .and equal .and fp_establishedName;\n"
"vp_ALIAS_statement\n"
" \"ALIAS\" .and space .and vp_establishName .and equal .and vp_establishedName;\n"
"fp_establishName\n"
" fp_identifier;\n"
"vp_establishName\n"
" vp_identifier;\n"
"fp_establishedName\n"
" fp_identifier;\n"
"vp_establishedName\n"
" vp_identifier;\n"
"fp_identifier\n"
" fp_not_reserved_identifier .and identifier_ne .error IDENTIFIER_EXPECTED;\n"
"vp_identifier\n"
" vp_not_reserved_identifier .and identifier_ne .error IDENTIFIER_EXPECTED;\n"
"fp_not_reserved_identifier\n"
" fp_not_reserved_identifier_1 .or .true;\n"
"fp_not_reserved_identifier_1\n"
" fp_reserved_identifier .and .false .error RESERVED_KEYWORD;\n"
"vp_not_reserved_identifier\n"
" vp_not_reserved_identifier_1 .or .true;\n"
"vp_not_reserved_identifier_1\n"
" vp_reserved_identifier .and .false .error RESERVED_KEYWORD;\n"
"fp_reserved_identifier\n"
" \"ABS\" .or \"ABS_SAT\" .or \"ADD\" .or \"ADD_SAT\" .or \"ALIAS\" .or \"ATTRIB\" .or \"CMP\" .or \"CMP_SAT\" .or\n"
" \"COS\" .or \"COS_SAT\" .or \"DP3\" .or \"DP3_SAT\" .or \"DP4\" .or \"DP4_SAT\" .or \"DPH\" .or \"DPH_SAT\" .or\n"
" \"DST\" .or \"DST_SAT\" .or \"END\" .or \"EX2\" .or \"EX2_SAT\" .or \"FLR\" .or \"FLR_SAT\" .or \"FRC\" .or\n"
" \"FRC_SAT\" .or \"KIL\" .or \"LG2\" .or \"LG2_SAT\" .or \"LIT\" .or \"LIT_SAT\" .or \"LRP\" .or \"LRP_SAT\" .or\n"
" \"MAD\" .or \"MAD_SAT\" .or \"MAX\" .or \"MAX_SAT\" .or \"MIN\" .or \"MIN_SAT\" .or \"MOV\" .or \"MOV_SAT\" .or\n"
" \"MUL\" .or \"MUL_SAT\" .or \"OPTION\" .or \"OUTPUT\" .or \"PARAM\" .or \"POW\" .or \"POW_SAT\" .or \"RCP\" .or\n"
" \"RCP_SAT\" .or \"RSQ\" .or \"RSQ_SAT\" .or \"SIN\" .or \"SIN_SAT\" .or \"SCS\" .or \"SCS_SAT\" .or \"SGE\" .or\n"
" \"SGE_SAT\" .or \"SLT\" .or \"SLT_SAT\" .or \"SUB\" .or \"SUB_SAT\" .or \"SWZ\" .or \"SWZ_SAT\" .or \"TEMP\" .or\n"
" \"TEX\" .or \"TEX_SAT\" .or \"TXB\" .or \"TXB_SAT\" .or \"TXP\" .or \"TXP_SAT\" .or \"XPD\" .or \"XPD_SAT\" .or\n"
" \"fragment\" .or \"program\" .or \"result\" .or \"state\" .or \"texture\";\n"
"vp_reserved_identifier\n"
" \"ABS\" .or \"ADD\" .or \"ADDRESS\" .or \"ALIAS\" .or \"ARL\" .or \"ATTRIB\" .or \"DP3\" .or \"DP4\" .or\n"
" \"DPH\" .or \"DST\" .or \"END\" .or \"EX2\" .or \"EXP\" .or \"FLR\" .or \"FRC\" .or \"LG2\" .or \"LIT\" .or\n"
" \"LOG\" .or \"MAD\" .or \"MAX\" .or \"MIN\" .or \"MOV\" .or \"MUL\" .or \"OPTION\" .or \"OUTPUT\" .or\n"
" \"PARAM\" .or \"POW\" .or \"RCP\" .or \"RSQ\" .or \"SGE\" .or \"SLT\" .or \"SUB\" .or \"SWZ\" .or \"TEMP\" .or\n"
" \"XPD\" .or \"program\" .or \"result\" .or \"state\" .or \"vertex\";\n"
"integer\n"
" integer_ne .error INTEGER_EXPECTED;\n"
"zero\n"
" '0';\n"
"leading_zeroes\n"
" .loop zero;\n"
"no_digit\n"
" no_digit_1 .or .true;\n"
"no_digit_1\n"
" digit10 .and .false .error INTEGER_OUT_OF_RANGE;\n"
"all_zeroes\n"
" all_zeroes_1 .or no_digit_1;\n"
"all_zeroes_1\n"
" '0' .and .loop zero .and no_digit;\n"
"integer_0_3\n"
" integer_0_3_1 .error INTEGER_EXPECTED .and .true .emit 0x00 .emit $;\n"
"integer_0_3_1\n"
" integer_0_3_2 .or all_zeroes .emit '0';\n"
"integer_0_3_2 \n"
" leading_zeroes .and '1'-'3' .emit * .and no_digit;\n"
"integer_0_63\n"
" integer_0_63_1 .error INTEGER_EXPECTED .and .true .emit 0x00 .emit $;\n"
"integer_0_63_1\n"
" integer_0_63_2 .or integer_0_63_3 .or integer_0_63_4 .or integer_0_63_5 .or\n"
" all_zeroes .emit '0';\n"
"integer_0_63_2 \n"
" leading_zeroes .and '7'-'9' .emit * .and no_digit;\n"
"integer_0_63_3 \n"
" leading_zeroes .and '1'-'5' .emit * .and '0'-'9' .emit * .and no_digit;\n"
"integer_0_63_4 \n"
" leading_zeroes .and '6' .emit * .and '0'-'3' .emit * .and no_digit;\n"
"integer_0_63_5 \n"
" leading_zeroes .and '1'-'6' .emit * .and no_digit;\n"
"integer_0_64\n"
" integer_0_64_1 .error INTEGER_EXPECTED .and .true .emit 0x00 .emit $;\n"
"integer_0_64_1\n"
" integer_0_64_2 .or integer_0_64_3 .or integer_0_64_4 .or integer_0_64_5 .or\n"
" all_zeroes .emit '0';\n"
"integer_0_64_2 \n"
" leading_zeroes .and '7'-'9' .emit * .and no_digit;\n"
"integer_0_64_3 \n"
" leading_zeroes .and '1'-'5' .emit * .and '0'-'9' .emit * .and no_digit;\n"
"integer_0_64_4 \n"
" leading_zeroes .and '6' .emit * .and '0'-'4' .emit * .and no_digit;\n"
"integer_0_64_5 \n"
" leading_zeroes .and '1'-'6' .emit * .and no_digit;\n"
"optional_space\n"
" space .or .true;\n"
"space\n"
" single_space .and .loop single_space;\n"
"single_space\n"
" white_char .or comment_block;\n"
"white_char\n"
" ' ' .or '\\t' .or '\\n' .or '\\r';\n"
"comment_block\n"
" '#' .and .loop comment_char .and new_line;\n"
"comment_char\n"
" '\\x0E'-'\\xFF' .or '\\x01'-'\\x09' .or '\\x0B'-'\\x0C';\n"
"new_line\n"
" '\\n' .or crlf .or '\\0';\n"
"crlf\n"
" '\\r' .and '\\n';\n"
"semicolon\n"
" optional_space .and ';' .error MISSING_SEMICOLON .and optional_space;\n"
"comma\n"
" optional_space .and ',' .error MISSING_COMMA .and optional_space;\n"
"comma_ne\n"
" optional_space .and ',' .and optional_space;\n"
"lbracket\n"
" optional_space .and '[' .error MISSING_LBRACKET .and optional_space;\n"
"lbracket_ne\n"
" optional_space .and '[' .and optional_space;\n"
"rbracket\n"
" optional_space .and ']' .error MISSING_RBRACKET .and optional_space;\n"
"dot\n"
" optional_space .and '.' .error MISSING_DOT .and optional_space;\n"
"dot_ne\n"
" optional_space .and '.' .and optional_space;\n"
"equal\n"
" optional_space .and '=' .error MISSING_EQUAL .and optional_space;\n"
"lbrace\n"
" optional_space .and '{' .error MISSING_LBRACE .and optional_space;\n"
"lbrace_ne\n"
" optional_space .and '{' .and optional_space;\n"
"rbrace\n"
" optional_space .and '}' .error MISSING_RBRACE .and optional_space;\n"
"dotdot\n"
" optional_space .and '.' .and '.' .error MISSING_DOTDOT .and optional_space;\n"
"dotdot_ne\n"
" optional_space .and '.' .and '.' .and optional_space;\n"
"float\n"
" float_1 .or float_2 .or float_legacy;\n"
"float_1\n"
" '.' .emit 0x00 .and integer_ne .error MISSING_FRACTION_OR_EXPONENT .and optional_exponent;\n"
"float_2\n"
" integer_ne .and float_3;\n"
"float_3\n"
" float_4 .or float_5;\n"
"float_4\n"
" '.' .and optional_integer .and optional_exponent;\n"
"float_5\n"
" exponent .emit 0x00;\n"
"float_legacy\n"
" integer_ne .and .true .emit 0x00 .emit 0x00;\n"
"integer_ne\n"
" integer_ne_1 .and .true .emit 0x00 .emit $;\n"
"integer_ne_1\n"
" digit10 .emit * .and .loop digit10 .emit *;\n"
"optional_integer\n"
" integer_ne .or .true .emit 0x00;\n"
"optional_exponent\n"
" exponent .or .true .emit 0x00;\n"
"exponent\n"
" exponent_1 .and optional_sign_ne .and integer_ne .error EXPONENT_VALUE_EXPECTED;\n"
"exponent_1\n"
" 'e' .or 'E';\n"
"optional_sign_ne\n"
" minus_ne .or plus_ne .or .true;\n"
"plus_ne\n"
" optional_space .and '+' .and optional_space;\n"
"minus_ne\n"
" optional_space .and '-' .emit '-' .and optional_space;\n"
"identifier_ne\n"
" first_idchar .emit * .and .loop follow_idchar .emit * .and .true .emit 0x00 .emit $;\n"
"follow_idchar\n"
" first_idchar .or digit10;\n"
"first_idchar\n"
" 'a'-'z' .or 'A'-'Z' .or '_' .or '$';\n"
"digit10\n"
" '0'-'9';\n"
".string __string_filter;\n"
"__string_filter\n"
" .loop __identifier_char;\n"
"__identifier_char\n"
" 'a'-'z' .or 'A'-'Z' .or '_' .or '$' .or '0'-'9';\n"
"e_signature\n"
" e_signature_char .and .loop e_signature_char;\n"
"e_signature_char\n"
" '!' .or '.' .or 'A'-'Z' .or 'a'-'z' .or '0'-'9';\n"
"e_statement\n"
" .loop e_statement_not_term;\n"
"e_statement_not_term\n"
" '\\x3C'-'\\xFF' .or '\\x0E'-'\\x3A' .or '\\x01'-'\\x09' .or '\\x0B'-'\\x0C';\n"
"e_identifier\n"
" e_identifier_first .and .loop e_identifier_next;\n"
"e_identifier_first\n"
" 'a'-'z' .or 'A'-'Z' .or '_' .or '$';\n"
"e_identifier_next\n"
" e_identifier_first .or '0'-'9';\n"
"e_token\n"
" e_identifier .or e_token_number .or '[' .or ']' .or '.' .or '{' .or '}' .or '=' .or '+' .or\n"
" '-' .or ',' .or ';';\n"
"e_token_number\n"
" e_token_digit .and .loop e_token_digit;\n"
"e_token_digit\n"
" '0'-'9';\n"
"e_charordigit\n"
" 'A'-'Z' .or 'a'-'z' .or '0'-'9';\n"
"";
