/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2003  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 

#include "swindow/SWindow.h"


/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit
 */
SWindowListener::SWindowListener()
{
}

SWindowListener::~SWindowListener()
{
}

/**
 * Try to close the window. If return value is true.
 */
bool
SWindowListener::windowClose (SWindow* w)
{
  return false;
}

void
SWindowListener::buttonPressed (SWindow *w, int button, int x, int y)
{
}

void
SWindowListener::buttonReleased (SWindow *w, int button, int x, int y)
{
}

void
SWindowListener::buttonDragged (SWindow *w, int button, int x, int y)
{
}

void
SWindowListener::keyPressed (SWindow * w, SKey key, const SString& s,
          bool ctrl, bool shift, bool meta)
{
}

void
SWindowListener::keyReleased (SWindow * w, SKey key, const SString& s,
          bool ctrl, bool shift, bool meta)
{
}


void
SWindowListener::redraw (SWindow* w, int x, int y, 
    unsigned int width, unsigned int height)
{
}

void
SWindowListener::resized (SWindow* w, int x, int y, 
    unsigned int width, unsigned int height)
{
}

void
SWindowListener::enterWindow (SWindow* w)
{
}

void
SWindowListener::leaveWindow (SWindow* w)
{
}

/**
 * called when a drop event happens.
 * @return true if the event is handled.
 */
bool
SWindowListener::drop (SWindow* w, const SString& mimetype, const SString& data)
{
  return false;
}

/**
 * Sets the targets that can be dropped on this window
 */
void
SWindow::setDroppable (const SStringVector& targets)
{
}

SWindow::SWindow()
{
  modalFlag = false;
  xpos = SD_WIN_X;
  ypos = SD_WIN_Y;
  xwidth = SD_WIN_W;
  yheight = SD_WIN_H;
}

SWindow::~SWindow()
{
}

void
SWindow::show ()
{
}

void
SWindow::hide ()
{
}

void
SWindow::resize (unsigned int _width, unsigned int _height)
{
  xwidth = _width;
  yheight = _height;
}

void
SWindow::move (int x, int y)
{
  xpos = x;
  ypos = y;
}


/**
 * This reqests a redraw, efficiently after all events got processed.
 * @param clear is true if the window needs to be cleared before calling redraw.
 * @param x is the x origin of the event
 * @param y is the y origin of the event
 * @param width is the width of the event
 * @param height is the height of the event
 */
void
SWindow::redraw (bool clear, int x, int y, unsigned int width, unsigned int height)
{
}

void 
SWindow::setParent (SWindow* w, int x, int y)
{
}

/**
 * Clear a reagion (set it to the background)
 * @param x is the upper left corner
 * @param y is the upper top corner
 * @param width is the width of the region to clear
 * @param height is the height of the region to clear
 */
void
SWindow::clear (int x, int y, unsigned int width, unsigned int height)
{
}

/**
 * Copy an area on the window to another area.
 * overlap is ok.
 * @param x is the upper left corner
 * @param y is the upper top corner
 * @param width is the width of the region to copy
 * @param height is the height of the region to copy
 * @param tox is the destination left corner
 * @param toy is the destination top corner
 */
void
SWindow::copy (int x, int y, unsigned int width, unsigned int height, 
  int tox, int toy)
{
}

/**
 * Fill a solid rectangle
 * @param x is the upper left corner
 * @param y is the upper top corner
 * @param width is the width of the region to fill
 * @param height is the height of the region to fill
 */
void
SWindow::bitfill (const SColor& bg, int x, int y, 
 unsigned int width, unsigned int height)
{
}

/**
 * Draw a solid line.
 * @param x is the starting x point
 * @param y is the starting y point
 * @param x is the ending non-exclusive  x point
 * @param y is the ending non-exclusive  y point
 */
void
SWindow::bitline (const SColor& fg, int x, int y, int tox, int toy)
{
}

/**
 * Try to put a cached image with id at x,y 
 * if failed, return false. You should draw it then.
 */
bool
SWindow::newpath (double x, double y, const SString& id)
{
  return false;
}

/**
 * Fill the image with this pen.
 */
void
SWindow::fill (const SPen& pen)
{
}


void
SWindow::stroke(const SPen& pen)
{
}

void
SWindow::moveto (double x, double y)
{
}

void
SWindow::lineto (double x, double y)
{
}

void
SWindow::curveto (double x0, double y0, double x1, 
  double y1, double x2, double y2)
{
}

void
SWindow::closepath()
{
}

void
SWindow::rotate (double angle)
{
}

void
SWindow::scale (double x, double y)
{
}

void
SWindow::translate (double x, double y)
{
}

/**
 * put an image to the scene. originX and OriginY is ignored.
 * @param x is the x corener of the image.
 * @param y is the y corner of the image.
 * @param image is the actual image.
 */
void 
SWindow::putImage (int x, int y, const SImage& image)
{
}

void
SWindow::setBackground(const SColor &color)
{
}

void
SWindow::pushmatrix()
{
}

void
SWindow::popmatrix()
{
}

/**
 * Draw a native font to the screen. This will not delete existing data. 
 * @param x is the origo position 
 * @param y is the origo position 
 * @param native is X11 FID for X11
 * @param data is a XChar2b structure for X11
 * @param len is the unber of chars for X11
 */
void
SWindow::bitfont (const SPen& pen, double x, double y, void* native, char* data, unsigned int len)
{
}

void
SWindow::bitpoint (const SColor& fg, int x, int y)
{
}

void
SWindow::bitpoints (const SColor& fg, const int* x, const int* y, 
         unsigned int size)
{
}

void
SWindow::getKeyboardFocus()
{
  return;
}

void
SWindowListener::lostKeyboardFocus(SWindow* w)
{
}

void
SWindowListener::lostClipSelection(SWindow* w)
{
}

void
SWindowListener::gainedKeyboardFocus(SWindow* w)
{
}

/**
 * Assign a rectangualr clip area. Everithing outside this area will be clipped.
 */
void
SWindow::setClippingArea (int x, int y, unsigned int width, unsigned int height)
{
}

/**
 *  clear the clipping area.
 */
void
SWindow::removeClippingArea ()
{
}
/**
 * This routine is not supposed to be used extensively. This is
 * to check the current matrix.
 */
SS_Matrix2D
SWindow::getCurrentMatrix() const
{
  return SS_Matrix2D();
}

/**
 * Start a native input method.
 * @param name is the name of the input method:
 *  like "kinput2"
 * @param properties provide some attributes to the input method.
 * It contains:
 * InputStyle: root over-the-spot off-the-spot
 * @return true if it could be started.
 */
bool
SWindow::startInputMethod (const SString& name, const SProperties& prop)
{
  return false;
}

void
SWindow::stopInputMethod ()
{
}

/**
 * Change properties of the input method on the fly.
 * @param prop contains properties like:
 * InputStyle: root over-the-spot off-the-spot
 */
void
SWindow::setInputMethodProperties (const SProperties& prop)
{
}

/**
 * Get the current input method.
 * it returns a zero sized string if input method is not started.
 */
SString
SWindow::getInputMethod ()
{
  return SString();
}

bool
SWindow::isVisible ()
{
  return false;
}

/**
 * Get an utf8 encoded text from clipboard.
 */
SString
SWindow::getClipUTF8()
{
  return SString();
}

/**
 * put and utf8-encoded text to clipboard.
 */
void
SWindow::putClipUTF8(const SString& utf8)
{
}

void
SWindow::setMinimumSize (unsigned int width, unsigned int height)
{
}
void
SWindow::setTitle (const SString& title)
{
}

/**
 * add and remove keyboard accelerator
 */
void
SWindow::addAccelerator (const SAccelerator& a, SAcceleratorListener* l)
{
}
void
SWindow::removeAccelerator (const SAccelerator& a, SAcceleratorListener* l)
{
}

/**
 * make an ID for a button from string
 */
int
getButtonID (const SString& string)
{
  if (string.size()==0) return -1;
  switch (string[0])
  {
    case 'A': return SWindowListener::Key_A;
    case 'a': return SWindowListener::Key_a;
    case 'B': return SWindowListener::Key_B;
    case 'b': return SWindowListener::Key_b;
    case 'C': return SWindowListener::Key_C;
    case 'c': return SWindowListener::Key_c;
    case 'D': return SWindowListener::Key_D;
    case 'd': return SWindowListener::Key_d;
    case 'E': return SWindowListener::Key_E;
    case 'e': return SWindowListener::Key_e;
    case 'F': return SWindowListener::Key_F;
    case 'f': return SWindowListener::Key_f;
    case 'G': return SWindowListener::Key_G;
    case 'g': return SWindowListener::Key_g;
    case 'H': return SWindowListener::Key_H;
    case 'h': return SWindowListener::Key_h;
    case 'I': return SWindowListener::Key_I;
    case 'i': return SWindowListener::Key_i;
    case 'J': return SWindowListener::Key_J;
    case 'j': return SWindowListener::Key_j;
    case 'K': return SWindowListener::Key_K;
    case 'k': return SWindowListener::Key_k;
    case 'L': return SWindowListener::Key_L;
    case 'l': return SWindowListener::Key_l;
    case 'M': return SWindowListener::Key_M;
    case 'm': return SWindowListener::Key_m;
    case 'N': return SWindowListener::Key_N;
    case 'n': return SWindowListener::Key_n;
    case 'O': return SWindowListener::Key_O;
    case 'o': return SWindowListener::Key_o;
    case 'P': return SWindowListener::Key_P;
    case 'p': return SWindowListener::Key_p;
    case 'Q': return SWindowListener::Key_Q;
    case 'q': return SWindowListener::Key_q;
    case 'R': return SWindowListener::Key_R;
    case 'r': return SWindowListener::Key_r;
    case 'S': return SWindowListener::Key_S;
    case 's': return SWindowListener::Key_s;
    case 'T': return SWindowListener::Key_T;
    case 't': return SWindowListener::Key_t;
    case 'U': return SWindowListener::Key_U;
    case 'u': return SWindowListener::Key_u;
    case 'V': return SWindowListener::Key_V;
    case 'v': return SWindowListener::Key_v;
    case 'W': return SWindowListener::Key_W;
    case 'w': return SWindowListener::Key_w;
    case 'X': return SWindowListener::Key_X;
    case 'x': return SWindowListener::Key_x;
    case 'Y': return SWindowListener::Key_Y;
    case 'y': return SWindowListener::Key_y;
    case 'Z': return SWindowListener::Key_Z;
    case 'z': return SWindowListener::Key_z;
    case '/': return SWindowListener::Key_slash;	    
    case '.': return SWindowListener::Key_period;	    
    case ',': return SWindowListener::Key_comma;	    
    case ';': return SWindowListener::Key_semicolon;	    
    case ':': return SWindowListener::Key_colon;	    
    case '_': return SWindowListener::Key_underscore;	    
    case '-': return SWindowListener::Key_hash;	    
    case '?': return SWindowListener::Key_questionmark;	    
    case '1': return SWindowListener::Key_1;	    
    case '2': return SWindowListener::Key_2;	    
    case '3': return SWindowListener::Key_3;	    
    case '4': return SWindowListener::Key_4;	    
    case '5': return SWindowListener::Key_5;	    
    case '6': return SWindowListener::Key_6;	    
    case '7': return SWindowListener::Key_7;	    
    case '8': return SWindowListener::Key_8;	    
    case '9': return SWindowListener::Key_9;	    
    case '0': return SWindowListener::Key_0;	    
  }
  return -1;
}
void
SWindow::setModal (SWindow* parent, bool decorated)
{
  modalFlag = true;
}

bool
SWindow::isModal ()
{
  return modalFlag;
}

bool
SWindow::isShown ()
{
  return shown;
}

/**
 * put this window in the middle
 */
void
SWindow::center (SWindow* window)
{
}

/**
 * wait till window is unmapped
 */
void
SWindow::wait ()
{
}

void
SWindow::setSize (unsigned int _width, unsigned int _height)
{
  xwidth =  _width;
  yheight = _height;
};

void
SWindow::setPosition (int _posx, int _posy)
{
  xpos = _posx;
  ypos = _posy;
};

unsigned int
SWindow::getWidth() const
{
  return xwidth;
}
unsigned int
SWindow::getHeight() const
{
  return yheight;
}
int
SWindow::getPositionX() const
{
  return xpos;
}

int
SWindow::getPositionY() const
{
  return ypos;
}
unsigned long
SWindow::getWindowID() const
{
  return (unsigned long) 0;
}
