/*____________________________________________________________________________
        
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1998-1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
        
        $Id: localfileinput.h,v 1.7 2003/09/16 17:35:02 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_LOCALFILEINPUT_H_
#define INCLUDED_LOCALFILEINPUT_H_

/* system headers */
#include <stdlib.h>
#include <string>
#include <vector>

/* project headers */
#include "thread.h"
#include "config.h"
#include "pmi.h"


class FAContext;

class LocalFileInput : public PhysicalMediaInput
{
public:
    enum {
        iMaxFileNameLen = 255
    };

    LocalFileInput(FAContext *context);
    LocalFileInput(char *path);
    virtual ~ LocalFileInput();

	virtual bool  CanHandle(const char *szUrl, char *szTitle);
	virtual bool  IsStreaming()
	              { return false; }
    virtual Error Seek(int32_t offset, int32_t origin);
    virtual Error Tell(int32_t* pos);
    virtual Error GetLength(size_t &iSize);
    
    virtual Error GetOutputBuffer(PullBuffer **pBuffer);

    /** Sets the pmi to get the data from the supplied url.
     */
    virtual Error SetUrl(const std::string& url);

    virtual Error Close();
    virtual void  Clear();
    
    virtual Error Run();
    
    void          WorkerThread();

    virtual vector<string> *GetProtocols();
    
 private:

    virtual Error Open();
    static  void  StartWorkerThread(void *pVoidBuffer);
    void  SkipID3v2Tag();

    FILE           *m_fpFile;
    bool            m_bLoop;
    size_t          m_iFileSize;
    Thread        *m_pBufferThread; 
};

#endif /* _LOCALFILEINPUT_H_ */

/* arch-tag: e739a27d-2355-488e-8cb1-7a254ed54a17
   (do not change this comment) */
