/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

	Portions Copyright (C) 1998-1999 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: lmc.h,v 1.7 2003/09/16 17:35:13 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_LMC_H_
#define INCLUDED_LMC_H_

#include <vector>
#include <string>

#include "pmi.h"
#include "pipeline.h"
#include "errors.h"
#include "eventdata.h"


enum {
    lmcError_MinimumError = 1000, 
    lmcError_DecodeFailed, 
    lmcError_AudioDecodeInitFailed, 
    lmcError_DecoderThreadFailed, 
    lmcError_PMIError, 
    lmcError_PMOError, 
    lmcError_MaximumError 
}; 

typedef struct DecodeInfo
{
  uint32_t downsample; /* 0 = full, 1 = half, 2 = quarter */
  bool   mono;       /* true for mixing to mono output */
  bool   eightbit;   /* true to force it to 8 bit unsigned output */
  bool   sendInfo;   /* false to skip sending [Media/MPEG]InfoEvents */
} _DecodeInfo;

class MediaInfoEvent;
class PullBuffer;
class EventBuffer;
// class PhysicalMediaInput;
class PhysicalMediaOutput;


class LogicalMediaConverter : public PipelineUnit
{
public:
    enum { 
        iMinimumOutputBufferSize = 64
    };


    LogicalMediaConverter(FAContext *context) : PipelineUnit(context) {
        m_pmi = NULL;
        m_decodeInfo.downsample = 0;
        m_decodeInfo.mono = false;
        m_decodeInfo.eightbit = false;
    }

    virtual ~LogicalMediaConverter() {
        Clear();
        if( m_pmi ) {
            m_pmi->Clear();
            delete m_pmi;
        }
    }
    

    virtual void Pause() { 
        PipelineUnit::Pause();
        if( m_pmi != NULL )
            m_pmi->Pause();
    }


    virtual void Resume() { 
        if( m_pmi != NULL )
            m_pmi->Resume();
        PipelineUnit::Resume();
    }


    /** Sets the lmc to get the data from the supplied url.
     *  eventually calls pmi SetTo method.
     *  TODO: move implementation to C-file
     */
    virtual Error SetUrl(const std::string& url) {
        assert(m_pmi != NULL);
        
        Error eRet = m_pmi->SetUrl(url);
        
        // now we have to get a new output buffer
        if (!IsError(eRet))
            eRet = m_pmi->GetOutputBuffer( &m_pInputBuffer );
        
        return eRet;
    }
    
    /** Returns the current Url */
    virtual const std::string& GetUrl() const { return m_pmi->GetUrl(); }

   /** Gets the output buffer of this stream.  Because the output
     *  buffer will be prepared for the caller, this function should
     *  be called only once.
     *
     *  @param pBuffer is set to the output buffer. Normally it will
     *  be prepared for the caller.
     *
     *  @returns Returns an error if one happened.
     */
    virtual Error GetOutputBuffer(PullBuffer **pBuffer) = 0;

    virtual Error ChangePosition(int32_t) = 0;

    virtual Error InitDecoder() = 0;

    virtual void  SetPMI(PhysicalMediaInput *pmi) { m_pmi = pmi; }

    /** Set the equalizer data.
     */
    virtual Error SetEQData(float *, float) { return kError_YouScrewedUp; }

    /** Set usage of equalizer
     */
    virtual Error SetEQData(bool) { return kError_YouScrewedUp; }

    /** Set the decode info
     *  Sorry, I don't really knows what this does 
     *  plus it is never called! (Ralf).
     */
    virtual Error SetDecodeInfo(DecodeInfo &info) {
        m_decodeInfo = info;
        return kError_NoErr;
    };
   
    virtual std::vector<std::string> *GetExtensions() = 0;
    virtual uint32_t CalculateSongLength(const char *) = 0;

protected:

      virtual Error CanDecode() = 0;
      virtual Error ExtractMediaInfo() = 0;
     
      PhysicalMediaInput    *m_pmi;
      DecodeInfo             m_decodeInfo;
};

#endif // _LMC_H_

/* arch-tag: 8e24fd1a-df6e-44ef-8020-1c592eba3553
   (do not change this comment) */
