#ifndef _INCLUDED_GTKLIBRARYTREE_H_
#define _INCLUDED_GTKLIBRARYTREE_H_

#include <vector>

#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>

#include <time.h>

#include "error.h"
#include "event.h"
#include "facontext.h"
#include "gtklibrary.h"
#include "gtkmusiclist.h"

class GTKLibrary::GTKLibraryTree : public GTKMusicList {
 public:
 	GTKLibraryTree(GTKLibrary *library);
	~GTKLibraryTree();
 
 	void Refresh();
 
 private:
 	FAContext *m_context;
 	GTKLibrary *m_library;
 	CatalogRoot library_root;
 
	//Internal Functions
 	virtual void set_list_columns();
 	void delete_cached(const Gtk::TreeModel::Children& items);
 	CatalogInfo* get_row_parent(Gtk::TreeModel::Path& child_path);
 
 	//Fill In Tree Depending On UI Events
 	bool manually_expanding;
 	void check_expanded_children(const Gtk::TreeModel::Children& children, CatalogInfo *parent);
 	void row_expanded(const Gtk::TreeModel::iterator& iter, const Gtk::TreeModel::Path& path);
  	void set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths);
 	void fill_in_child(Gtk::TreeModel::Row& row_child);
	
 	//Other UI Events
 	virtual void show_menu(guint button, guint32 time);
	virtual void cursor_changed(Gtk::TreeModel::Path CursorPath);
 	virtual void selection_changed(Glib::RefPtr<Gtk::TreeView::Selection> selection);
 	virtual void row_activated(Gtk::TreeModel::Path RowPath);
 	
	//Possible Columns
	class LibraryCols : public Gtk::TreeModel::ColumnRecord {
	 public:
		LibraryCols() 
			{ add(icon); add(text); add(CatalogItem); add(last_refresh); }
		
		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> > icon;
		Gtk::TreeModelColumn<Glib::ustring> text;
		Gtk::TreeModelColumn<CatalogInfo *> CatalogItem;
		Gtk::TreeModelColumn<time_t> last_refresh;
	};
	LibraryCols m_LibraryCols;
	
};

#endif
/* arch-tag: 97db2878-32ed-436a-bf21-dc4854fa304d */
