#include <vector>
#include <string>
#include <sstream>
#include <iostream>

#include <time.h>
#include <assert.h>

using namespace std;

#include "gtklibrarytree.h"
#include "gtklibrary.h"
#include "gtktracklist.h"
#include "gtkalbumlist.h"

GTKLibrary::GTKLibraryTree::GTKLibraryTree(GTKLibrary *library) 
	: GTKMusicList()
{
	//Init Variables
	m_context = library->m_context;
	m_library = library;
	manually_expanding = false;
	
	//Create Tree Model
	set_tree_model_columns(&m_LibraryCols);
	
	//Create Base Icons
	Refresh();
	
	//Setup Signal Handlers
	m_listMusic.signal_row_expanded().connect( SigC::slot(*this, &GTKLibraryTree::row_expanded) );

}

GTKLibrary::GTKLibraryTree::~GTKLibraryTree()
{
	//Delete Still Cached Data
	delete_cached(m_treemodelMusic->children());
}

void GTKLibrary::GTKLibraryTree::delete_cached(const Gtk::TreeModel::Children& items)
{
	Gtk::TreeModel::iterator item;
	for(item = items.begin(); item != items.end(); item++) {
		if((*item)[m_LibraryCols.last_refresh] > 0) { //Has Data Assigned
			delete (*item)[m_LibraryCols.CatalogItem];
			//Delete Cache For Rows Children As Well
			delete_cached((*item).children());
		}
	}
}

void GTKLibrary::GTKLibraryTree::set_list_columns()
{
	//Create TreeView Column
	Gtk::TreeView::Column* MainCol = Gtk::manage( new Gtk::TreeView::Column("Library") );
	MainCol->pack_start(m_LibraryCols.icon, false);
	MainCol->pack_end(m_LibraryCols.text);
	m_listMusic.append_column(*MainCol);
	m_listMusic.set_headers_visible(false);
}

void GTKLibrary::GTKLibraryTree::check_expanded_children(const Gtk::TreeModel::Children& children, CatalogInfo* parent)
{
	assert(parent);
	
	uint32_t child_count = parent->child_count();
	
	//Check Correct Amount Of Rows In Children
	if(children.size() != child_count) {
		//Check For Special Case, ChildCount = 0, should_have_children
		if((child_count == 0) && parent->should_have_children())
			child_count = 1; //Empty Row
		while(children.size() < child_count) {
			//Add New Rows
			Gtk::TreeModel::Row new_row = *(m_treemodelMusic->append(children));
			new_row[m_LibraryCols.last_refresh] = 0;
			//Make Sure It Has A Catalog Reference
			//new_row[m_LibraryCols.CatalogItem] = parent->child_item(m_treemodelMusic->get_path(new_row).back());
		}
		while(children.size() > child_count) {
			//Remove Extra Rows
			//Delete Cached Data First
			if((*children.begin())[m_LibraryCols.last_refresh] > 0)
				delete (*children.begin())[m_LibraryCols.CatalogItem];
			
			m_treemodelMusic->erase(children.begin());
		}
	}
	
	//Go Through Children
	Gtk::TreeModel::iterator row;
	for(row = children.begin(); row != children.end(); row++) {
		Gtk::TreeModel::Path row_path = m_treemodelMusic->get_path(row);
		if(m_listMusic.row_expanded(row_path)) {
			//Row Expanded, Check It
			check_expanded_children((*row).children(), (*row)[m_LibraryCols.CatalogItem]);
		}
	}
}

void GTKLibrary::GTKLibraryTree::Refresh()
{
	//Check Each Expanded Row Has Correct Amount Of Rows
	//Base Is Always Expanded, So Start There
	check_expanded_children(m_treemodelMusic->children(), &library_root);	

	scrolledwindow_changed_visible();
}

void GTKLibrary::GTKLibraryTree::row_expanded(const Gtk::TreeModel::iterator& iter, const Gtk::TreeModel::Path& path)
{
	if(manually_expanding)
		return;

	//Check Row Children	
	Gtk::TreeModel::Row expanded_row = *iter;
	CatalogInfo *expanded_data = expanded_row[m_LibraryCols.CatalogItem];
	check_expanded_children(expanded_row.children(), expanded_data);
	
	//Expand Row
	manually_expanding = true;
	m_listMusic.expand_row(path, false);
	manually_expanding = false;
	
}

void GTKLibrary::GTKLibraryTree::set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths)
{
	std::vector<Gtk::TreeModel::Path>::iterator row_path;
	Gtk::TreeModel::Row visible_row;
	
	//Set Info For All Paths
	for(row_path = RowPaths.begin(); row_path != RowPaths.end(); row_path++) {
		visible_row = *(m_treemodelMusic->get_iter(*row_path));
		if(visible_row[m_LibraryCols.last_refresh] < m_library->m_last_change) {
			fill_in_child(visible_row); //Make Sure CatalogItem Current
			CatalogInfo *RowInfo = visible_row[m_LibraryCols.CatalogItem];
			visible_row[m_LibraryCols.icon] = RowInfo->item_icon();
			visible_row[m_LibraryCols.text] = RowInfo->item_text();
			visible_row[m_LibraryCols.last_refresh] = time(NULL);
		}
	}
}

void GTKLibrary::GTKLibraryTree::fill_in_child(Gtk::TreeModel::Row& row_child)
{
	Gtk::TreeModel::Path child_path;
	CatalogInfo *child_info;
	
	//Get Path Of Item
	child_path = m_treemodelMusic->get_path(row_child);
	
	//Get Item Info	
	child_info = get_row_parent(child_path)->child_item(child_path.back());
	
	if(row_child[m_LibraryCols.last_refresh] > 0) //Already Has Data
		delete row_child[m_LibraryCols.CatalogItem];
	//Set New Data
	row_child[m_LibraryCols.CatalogItem] = child_info;
	
	//If Child Should Have Child Items And Isn't Already Expanded
	//Add Empty Child So Can Be Expanded
	if(!m_listMusic.row_expanded(child_path) && child_info->should_have_children()) {
		Gtk::TreeModel::Row new_row;
		new_row = *(m_treemodelMusic->append(row_child.children()));
		new_row[m_LibraryCols.last_refresh] = 0;
	}
}

CatalogInfo* GTKLibrary::GTKLibraryTree::get_row_parent(Gtk::TreeModel::Path& child_path)
{
	//Get Child Parent
	if(child_path.size() == 1) {//Root Items, Parent Is library_root
		return &library_root;
	} else {
		//Get Parent Item
		Gtk::TreeModel::Path parent_path = child_path;
		parent_path.up(); //Go up to parent
		Gtk::TreeModel::Row parent_row = *(m_treemodelMusic->get_iter(parent_path));
		CatalogInfo* parent_info = parent_row[m_LibraryCols.CatalogItem];
		return parent_info;
	}
}

void GTKLibrary::GTKLibraryTree::show_menu(guint button, guint32 time)
{
	if(!m_path_menu_shown_for.empty()) {
		//Refresh Selected
		selection_changed(m_listMusic.get_selection());
		
		//Show Menu
		Gtk::Menu_Helpers::MenuList MenuItems = m_library->m_catalogPopupMenu.items();
		//Enable Remove Edit
		MenuItems[m_library->menu_loc_remove].set_sensitive(true);
		MenuItems[m_library->menu_loc_edit].set_sensitive(true);
		//Look For A Reason To Disable Them
		std::vector<CatalogInfo *>::iterator selected_item;
		for(selected_item = m_library->selected_info.begin(); selected_item != m_library->selected_info.end(); selected_item++) {
			if(!(*selected_item)->can_be_removed_changed()) {
				//Disable Remove Edit
				MenuItems[m_library->menu_loc_remove].set_sensitive(false);
				MenuItems[m_library->menu_loc_edit].set_sensitive(false);
				break;
			}
		}
		
		m_library->m_catalogPopupMenu.popup(button, time);
	}
}
void GTKLibrary::GTKLibraryTree::cursor_changed(Gtk::TreeModel::Path RowPath)
{
	if(!RowPath.empty()) {
		//Get Selected Item
		Gtk::TreeModel::Row temp_row;
		CatalogInfo *item = NULL;
		
		//Get Selected Item
		temp_row = *(m_treemodelMusic->get_iter(RowPath));
		if(temp_row[m_LibraryCols.last_refresh] > 0)
			item = temp_row[m_LibraryCols.CatalogItem];
		
		//Clear Album and Track Lists
		if(m_library->m_TrackList) m_library->m_TrackList->Clear();
		if(m_library->m_AlbumList) m_library->m_AlbumList->Clear();
		
		//Show Child Items In Track List
		if(item && m_library->m_TrackList) 
			m_library->m_TrackList->SetParent(item->track_list_parent());
		//Show Child Items In Album List
		if(item && m_library->m_AlbumList)
			m_library->m_AlbumList->SetParent(item->album_list_parent());
	}
}

void GTKLibrary::GTKLibraryTree::selection_changed(Glib::RefPtr<Gtk::TreeView::Selection> selection)
{
	//Get Selected Rows And Put Information In Vectors For GTKLibrary
	std::vector<CatalogInfo *> catalog_infos;
	std::vector<Gtk::TreeModel::Path> selected_paths;
	std::vector<Gtk::TreeModel::Path>::iterator selected_path;
	
	//Go Through All Selected Rows
	selected_paths = selection->get_selected_rows();
	for(selected_path = selected_paths.begin(); selected_path != selected_paths.end(); selected_path++) {
		//Get Data
		CatalogInfo *NewInfo = get_row_parent(*selected_path)->child_item((*selected_path).back());
		catalog_infos.push_back(NewInfo);
	}
	
	//Tell GTKLibrary Selected Rows
	m_library->set_selection(catalog_infos);
}

void GTKLibrary::GTKLibraryTree::row_activated(Gtk::TreeModel::Path RowPath)
{
	Gtk::TreeModel::Row activated_row;
	activated_row = *(m_treemodelMusic->get_iter(RowPath));
	
	//Tell Library To Information Activated
	m_library->row_activated(activated_row[m_LibraryCols.CatalogItem]);
}
/* arch-tag: b01d765e-0188-4b42-88ee-270c61d2d779 */
