using namespace std;
#include "gtktoolbar.h"
#include "gtkmusicbrowser.h"

GTKMenubar::GTKMenubar(GTKBrowserMusic *musicbrowser)
{

	m_musicbrowser = musicbrowser;
	createMenus();
}


void 
GTKMenubar::createMenus() 
{


    Gtk::Menu::MenuList& fl = m_fileMenu.items();
    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "_New Playlist",  
                     Gtk::Menu::AccelKey("<control>n"),
                     SigC::slot(*this, &GTKMenubar::on_menu_file_new) ));

    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "_Save Playlist",  
                     Gtk::Menu::AccelKey("<control>s"),
                     SigC::slot(*this, &GTKMenubar::on_menu_file_save) ));

    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Save _As Playlist",  
                     Gtk::Menu::AccelKey("<control>a"),
                     SigC::slot(*this, &GTKMenubar::on_menu_file_saveas) ));

    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Import tracks",  
                     SigC::slot(*this, &GTKMenubar::on_menu_file_import) ));
               
    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Export tracks",  
                     SigC::slot(*this, &GTKMenubar::on_menu_file_export) ));

    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Search Computer for Music",
                     SigC::slot(*this, &GTKMenubar::on_menu_file_search) ));

    fl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Close",  
                     SigC::slot(*this, &GTKMenubar::on_menu_file_close) ));



    Gtk::Menu::MenuList el = m_editMenu.items();

    el.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Add Track",
                     SigC::slot(*this, &GTKMenubar::on_menu_edit_add) ));

    el.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Remove Track",
                     SigC::slot(*this, &GTKMenubar::on_menu_edit_remove) ));

    el.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Edit info",
                     SigC::slot(*this, &GTKMenubar::on_menu_edit_info) ));


    Gtk::Menu::MenuList&    vl = m_viewMenu.items();

    vl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Playlist only",
                     SigC::slot(*this, &GTKMenubar::on_menu_view_1) ));

    Gtk::Menu::MenuList&    cl = m_controlMenu.items();

    cl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Play",
                     SigC::slot(*this, &GTKMenubar::on_menu_control_play) ));

    cl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Stop",
                     SigC::slot(*this, &GTKMenubar::on_menu_control_stop) ));


    Gtk::Menu::MenuList&    hl = m_helpMenu.items();
    hl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "Visit zinf website",
                     SigC::slot(*this, &GTKMenubar::on_menu_help_zinf) ));


    hl.push_back(Gtk::Menu_Helpers::MenuElem(
                     "About",
                     SigC::slot(*this, &GTKMenubar::on_menu_help_about) ));


    // Store in menubar
    items().push_back(Gtk::Menu_Helpers::MenuElem("_File", m_fileMenu) );
    items().push_back(Gtk::Menu_Helpers::MenuElem("_Edit", m_editMenu) );
    items().push_back(Gtk::Menu_Helpers::MenuElem("_View", m_viewMenu) );
    items().push_back(Gtk::Menu_Helpers::MenuElem("_Control", m_controlMenu) );
    items().push_back(Gtk::Menu_Helpers::MenuElem("_Help",  m_helpMenu));
}



void
GTKMenubar::on_menu_file_new() 
{
    //cout << "file new" << endl;
    m_musicbrowser->NewPlaylist();
}


void GTKMenubar::on_menu_file_save()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_file_saveas()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_file_import()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_file_export()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_file_close()
{
    cerr << "Please implement me" << endl;
}

void
GTKMenubar::on_menu_file_search() 
{
    cout << "file search" << endl;

	MusicInputDialog searchpath("Search Music", 
                                "Please enter the location of your music library:");
	searchpath.set_entry_text("/home/music");
	if(searchpath.run(true) == Gtk::RESPONSE_OK) {
		std::string path  = searchpath.get_entry_text();

        m_musicbrowser->SearchMusic(path);
    }
}

 void GTKMenubar::on_menu_edit_add()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_edit_remove()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_edit_info()
{
    cerr << "Please implement me" << endl;
}


 void GTKMenubar::on_menu_view_1()
{
    cerr << "Please implement me" << endl;
}
    //virtual void on_menu_view_1()

 void GTKMenubar::on_menu_control_play()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_control_stop()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_control_next()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_control_prev()
{
    cerr << "Please implement me" << endl;
}


 void GTKMenubar::on_menu_help_zinf()
{
    cerr << "Please implement me" << endl;
}
 void GTKMenubar::on_menu_help_about()
{
    cerr << "Please implement me" << endl;
}
/* arch-tag: 34ea749d-88aa-4dbd-be06-2cae4258e640 */
