#include <vector>
#include <gtk/gtktreeview.h>

#include "gtkmusiclist.h"

GTKMusicList::GTKMusicList() : ScrolledWindow()
{
	//Init OwnTreeView
	m_listMusic.m_parent = this;
	
	//Set Policies & Style
	m_listMusic.set_rules_hint();
	m_listMusic.get_selection()->set_mode(Gtk::SELECTION_MULTIPLE);
	set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	add(m_listMusic);
	
	//Create Signal Handlers
	m_listMusic.signal_cursor_changed().connect( SigC::slot(*this, &GTKMusicList::list_cursor_changed) );
	m_listMusic.get_selection()->signal_changed().connect( SigC::slot(*this, &GTKMusicList::list_selection_changed) );
	m_listMusic.signal_row_activated().connect( SigC::slot(*this, &GTKMusicList::list_row_activated) );
	get_vadjustment()->signal_changed().connect( SigC::slot(*this, &GTKMusicList::scrolledwindow_changed_visible) );
	get_vadjustment()->signal_value_changed().connect( SigC::slot(*this, &GTKMusicList::scrolledwindow_changed_visible) );
	
	//Make Sure Realized
	show_all();
}

void GTKMusicList::set_list_model_columns(Gtk::TreeModel::ColumnRecord *Columns)
{
	//Create List Model
	m_listmodelMusic = Gtk::ListStore::create(*Columns);
	m_listMusic.set_model(m_listmodelMusic);
	
	//Create List Colunmns
	set_list_columns();
}

void GTKMusicList::set_tree_model_columns(Gtk::TreeModel::ColumnRecord *Columns)
{
	//Create List Model
	m_treemodelMusic = Gtk::TreeStore::create(*Columns);
	m_listMusic.set_model(m_treemodelMusic);
	
	//Create List Colunmns
	set_list_columns();
}

bool GTKMusicList::OwnTreeView::on_button_press_event(GdkEventButton *event)
{
	//If Right Clicked On Row, Show Menu
	if((event->type == GDK_BUTTON_PRESS) && (event->button == 3) && is_realized()) {
		Gtk::TreeModel::Path RowPath;
		Gtk::TreeViewColumn *TempColumn;
		int temp_x, temp_y;
		if( get_path_at_pos((int)event->x, (int)event->y, RowPath, TempColumn, temp_x, temp_y) ) {
			//Row Clicked On
			m_parent->m_path_menu_shown_for = RowPath;
			
			//If Row Is Not Already Selected, allow list to change
			//selection to it
			if(!get_selection()->is_selected(RowPath))
				TreeView::on_button_press_event(event);
			
			//Make Sure TreeView Dosn't Confuse Mouse Movement on Menu
			//For Dragging
			GdkEventButton *release_event;
			release_event = new GdkEventButton(*event);
			release_event->type = GDK_BUTTON_RELEASE;
			on_button_release_event(release_event);
			delete release_event;
			
			m_parent->show_menu(event->button, event->time);
			return true;
		}	
	} 
	
	//Didn't Show Menu
	return TreeView::on_button_press_event(event);
}

void GTKMusicList::list_cursor_changed()
{
	Gtk::TreeModel::Path CursorPath;
	Gtk::TreeViewColumn *TempColumn;
	
	//Get Position Of Cursor
	m_listMusic.get_cursor(CursorPath, TempColumn);
	
	//Activate Event
	cursor_changed(CursorPath);
}

void GTKMusicList::list_selection_changed()
{
	//Activate Event
	selection_changed(m_listMusic.get_selection());
}

void GTKMusicList::list_row_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn* column)
{
	//Activate Event
	row_activated(path);
}

void GTKMusicList::scrolledwindow_changed_visible()
{
	if(is_visible() && m_listMusic.is_realized()) {
		Gdk::Rectangle VisibleArea, CellArea;
		int widget_x, widget_y;
		int tree_y;
		std::vector<Gtk::TreeModel::Path> VisiblePaths;
		Gtk::TreeModel::Path LastPath;
		Gtk::TreeModel::Path NewPath;
		
		//Get Visible Rectangle
		m_listMusic.get_visible_rect(VisibleArea);
		
		//Get Visible Paths
		for(tree_y = VisibleArea.get_y(); tree_y < (VisibleArea.get_y() + VisibleArea.get_height()); tree_y++) {
			//Convert Coords To Those Used By get_path_at_pos
			m_listMusic.tree_to_widget_coords(VisibleArea.get_x(), tree_y, widget_x, widget_y);
			
			//Get Path
			Gtk::TreeViewColumn* TempColumn=0;
			bool path_returned;
			
			//HACK: Workaround for bug in GTKMM - It Dosn't Free The Returned Path
			//path_returned = m_listMusic.get_path_at_pos(widget_x, widget_y, NewPath, TempColumn, widget_x, widget_y);
			GtkTreePath *gtk_NewPath = NULL;
			GtkTreeViewColumn *gtk_TempColumn = NULL;
			path_returned = gtk_tree_view_get_path_at_pos(m_listMusic.gobj(), widget_x, widget_y, &gtk_NewPath, &gtk_TempColumn, NULL, NULL);
			NewPath = Gtk::TreeModel::Path(gtk_NewPath, false);
			TempColumn = Glib::wrap(gtk_TempColumn);
			
			//If Path Differnet To Last One, Add To List
			if(path_returned 
               && ((LastPath.get_depth() < 1) 
                   || (NewPath != LastPath))) {
				VisiblePaths.push_back(NewPath);
				LastPath = NewPath;
				m_listMusic.get_cell_area(NewPath, *TempColumn, CellArea);
                //For Loop Will Add 1 back on
				tree_y += CellArea.get_height() - 1; 
                //delete TempColumn;
			}
		}
		
		//Set Data For Visible Rows
		set_rows_data(VisiblePaths);
	}
}
/* arch-tag: 42cab0c0-bf5d-45d7-b1c5-98aeca768b67 */
