#include <iostream>
using namespace std;
#include "musiclayout.h"

/********************
 Paned Layout Class
********************/
PanedLayout::PanedLayout()
{
	//Init Contents
	for(int i = 0; i < 4; i++)
		m_positions[i] = NULL;
}

PanedLayout::~PanedLayout()
{
	//Delete Created Panes - Don't Delete Contents
	std::vector<Gtk::Paned *>::iterator pane;
	for(pane = m_panes.begin(); pane != m_panes.end(); pane++)
		delete *pane;
}

/*****************************************************************
 Creates A Container Split Into Maximum 4 Sections
 Positions are: 0  1
                2  3
 Items In Any Position, First Expand Right, Then Down If They Can
 0 Has Highest Priority To Expand,
  i.e. if it can expand right and down, 3 is ignored
*****************************************************************/
void PanedLayout::create()
{
	//This Should Only Be Called Once - So No Need To Reset First
	
	bool split_0_1 = false;
	bool split_0_2 = false;
	bool split_1_3 = false;
	bool split_2_3 = false;
	
	if(m_positions[0]) { //There Is A Base Item
		//See Which Splits Are Needed
		if(m_positions[1]) {
			split_0_1 = true;
			if(m_positions[3]) {
				split_1_3 = true;
			}
		}
		if(m_positions[2]) {
			split_0_2 = true;
			if(m_positions[3]) {
				split_2_3 = true;
			}
		}
		
		//Create Splits
		//Look For Items That Expand If Any
		if(!split_0_1 && !split_0_2) {
			//Base Item Is Not Split With Anything, So Expands To Fill All
			add(*m_positions[0]);
		} else if(split_0_1 && !split_0_2 && !split_1_3) {
			//Both 0 and 1 expand down
			//Create Pane
			Gtk::HPaned *new_pane_0_1 = new Gtk::HPaned;
			m_panes.push_back(new_pane_0_1);
			//Add Items
			new_pane_0_1->pack1(*m_positions[0]);
			new_pane_0_1->pack2(*m_positions[1]);
			//Add Pane
			add(*new_pane_0_1);
		} else if(split_0_1 && !split_0_2 && split_1_3) {
			//0 expands down, 1 dosn't
			Gtk::VPaned *new_pane_1_3 = new Gtk::VPaned;
			m_panes.push_back(new_pane_1_3);
			new_pane_1_3->pack1(*m_positions[1]);
			new_pane_1_3->pack2(*m_positions[3]);
			
			Gtk::HPaned *new_pane_0_13 = new Gtk::HPaned;
			m_panes.push_back(new_pane_0_13);
			new_pane_0_13->pack1(*m_positions[0]);
			new_pane_0_13->pack2(*new_pane_1_3);
			
			add(*new_pane_0_13);
		} else if(split_0_1 && split_0_2 && !split_2_3) {
			//2 expands right, 0 dosn't
			Gtk::HPaned *new_pane_0_1 = new Gtk::HPaned;
			m_panes.push_back(new_pane_0_1);
			new_pane_0_1->pack1(*m_positions[0]);
			new_pane_0_1->pack2(*m_positions[1]);
			
			Gtk::VPaned *new_pane_01_2 = new Gtk::VPaned;
			m_panes.push_back(new_pane_01_2);
			new_pane_01_2->pack1(*new_pane_0_1);
			new_pane_01_2->pack2(*m_positions[2]);
			
			add(*new_pane_01_2);
		} else if(!split_0_1 && split_0_2 && !split_2_3) {
			//0 and 2 expand right
			Gtk::VPaned *new_pane_0_2 = new Gtk::VPaned;
			m_panes.push_back(new_pane_0_2);
			new_pane_0_2->pack1(*m_positions[0]);
			new_pane_0_2->pack2(*m_positions[2]);
			
			add(*new_pane_0_2);
		} else if(!split_0_1 && split_0_2 && split_2_3) {
			//0 expands right, 2 dosn't
			Gtk::HPaned *new_pane_2_3 = new Gtk::HPaned;
			m_panes.push_back(new_pane_2_3);
			new_pane_2_3->pack1(*m_positions[2]);
			new_pane_2_3->pack2(*m_positions[3]);
			
			Gtk::VPaned *new_pane_0_23 = new Gtk::VPaned;
			m_panes.push_back(new_pane_0_23);
			new_pane_0_23->pack1(*m_positions[0]);
			new_pane_0_23->pack2(*new_pane_2_3);
			
			add(*new_pane_0_23);
		} else if(split_0_1 && split_0_2 && split_1_3 && split_2_3) {
			//Nothing Expands - HPaned Is Main Split
			Gtk::VPaned *new_pane_0_2 = new Gtk::VPaned;
			m_panes.push_back(new_pane_0_2);
			new_pane_0_2->pack1(*m_positions[0]);
			new_pane_0_2->pack2(*m_positions[2]);
			
			Gtk::VPaned *new_pane_1_3 = new Gtk::VPaned;
			m_panes.push_back(new_pane_1_3);
			new_pane_1_3->pack1(*m_positions[1]);
			new_pane_1_3->pack2(*m_positions[3]);
			
			Gtk::HPaned *new_pane_02_13 = new Gtk::HPaned;
			m_panes.push_back(new_pane_02_13);
			new_pane_02_13->pack1(*new_pane_0_2);
			new_pane_02_13->pack2(*new_pane_1_3);
			
			add(*new_pane_02_13);
		} else {
			cout << "Feck - It Really Should Be Impossible To Get Here" << endl;
		}
		
		show_all();
	}
}

/********************
 Music Layout Class
 *******************/
MusicLayout::MusicLayout(Preferences *prefs)
{
	//Init Variables
	m_prefs = prefs;
	m_actual_layout = NULL;
	for(int i = 0; i < 4; i++)
		m_second_layouts[i] = NULL;
	
	//Set All Widget Locations To Nothing
	m_library_tree_pos[0] = m_library_tree_pos[1] = -1;
	m_album_list_pos[0] = m_album_list_pos[1] = -1;
	m_track_list_pos[0] = m_track_list_pos[1] = -1;
	m_playlist_pos[0] = m_playlist_pos[1] = -1;
	
}

MusicLayout::~MusicLayout()
{
	//Delete Layouts
	delete m_actual_layout;
	for(int i = 0; i < 4; i++)
		delete m_second_layouts[i];
}

void MusicLayout::read_prefs()
{
	//Read Details Of All Widgets
	set_library_tree_pos(0);
	set_album_list_pos(-1);
	set_track_list_pos(1);
	set_playlist_pos(3);
	m_tab_pos = Gtk::POS_TOP;
	
	m_toolbar_style = Gtk::TOOLBAR_BOTH;
	
	m_show_library = true;
}

void MusicLayout::change_layout()
{
	//Empty Container of All Widgets
	while(!get_children().empty()) {
		remove(*(*(get_children().begin())));
	}
	
	//Delete Old Layouts - Just To Make Sure They're All Reset
	delete m_actual_layout;
	for(int i = 0; i < 4; i++)
		delete m_second_layouts[i];
	
	m_actual_layout = NULL;
	for(int i = 0; i < 4; i++)
		m_second_layouts[i] = NULL;
	
	//Add Top Widgets (Menu Bar, Toolbar,...)
	if(need_menubar())
		pack_start(*m_menu_bar, false, false);
	if(need_toolbar())
		pack_start(*m_toolbar, false, false);
	
	
	//Add Items To Layout
	m_actual_layout = new PanedLayout;
	
	if(m_show_library) {
		//Add Library Items
		if(need_library_tree())
			add_item(m_library_tree, m_library_tree_pos);
		if(need_album_list())
			add_item(m_album_list, m_album_list_pos);
		if(need_track_list())
			add_item(m_track_list, m_track_list_pos);
		//Add Playlist In Specified Position
		if(need_playlist())
			add_item(m_playlist, m_playlist_pos);
	} else {
		//Add Playlist In Position 0
		if(need_playlist()) {
			int pos0[2];
			pos0[0] = 0; pos0[1] = -1;
			add_item(m_playlist, pos0);
		}
	}
	
	//Create Secondry Layouts
	for(int i = 0; i < 4; i++) {
		if(m_second_layouts[i])
			m_second_layouts[i]->create();
	}
	//Add Main Layout
	m_actual_layout->create();
	pack_start(*m_actual_layout);
	
	//Add Bottom Widgets (Status Bar, ...)
	if(need_status_bar())
		pack_end(*m_status_bar, false, false);
	
	//Show All Widgets
	show_all();
}

void MusicLayout::add_item(Gtk::Widget *item, int item_pos[])
{
	if(!is_displayed(item_pos)) //Is Not Shown
		return;
	
	//Add Item To Correct Layout
	if(item_pos[1] == -1) {
		//Uses First Level Only
		m_actual_layout->set_position(item, item_pos[0]);
	} else {
		//Is In Second Level
		PanedLayout *second_level;
		second_level = get_second_level_layout(item_pos[0]);
		second_level->set_position(item, item_pos[1]);
	}
}

PanedLayout *MusicLayout::get_second_level_layout(int first_level)
{
	//Get Second Level/Child Layout For A First Level Position
	PanedLayout *to_return;
	to_return = m_second_layouts[first_level];
	if(!to_return) {
		//Second Level Dosn't Yet Exist - Create It
		to_return = m_second_layouts[first_level] = new PanedLayout;
		m_actual_layout->set_position(to_return, first_level);
	}
	return to_return;
}
/* arch-tag: 82062335-4eeb-48d3-8007-db62b65e9d18 */
