##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string
import sys

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class PDFAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    PDF file abstraction
    """
    
    icon_file = "PDFAttachment.gif"
    small_icon_file = "PDFAttachment_small.gif"
    content_types = ('application/pdf', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => index a PDF file and store it in the index variable.
        This method is called only once (in the __init__) during the class's lifetime.
        """
        try:
            fn = self.writeAttachmentFile()
            ret = self.callConverter(PDF2TEXT_PROGRAM, "%s -" % (fn, ))
        finally:
            self.deleteAttachmentFile()
        return ret


    def isPreviewAvailable(self,):
        return 1


    def convertPreview(self,):
        """
        Let's convert things into pretty HTML !
        """
        try:
            fn = self.writeAttachmentFile()
            if sys.platform == 'win32':
                args = "%s -enc Latin1 -layout -" % (fn, )      # XXX Remove "-enc Latin1" if you want to use another encoding
            else:
                args = "%s -enc Latin1 -" % (fn, )      # XXX Remove "-enc Latin1" if you want to use another encoding
            ret = self.callConverter(PDF2TEXT_PROGRAM, args) 
            ret = self.textToHTML(ret)
        finally:
            self.deleteAttachmentFile()
        return ret


ZAttachmentRegistry.AttachmentRegistry.registerClass(PDFAttachment, globals(), PDF2TEXT_PROGRAM)

