#!/bin/bash
# prepend.sh: Add text at beginning of file.
#
#  Example contributed by Kenny Stauffer,
#  and slightly modified by document author.


E_NOSUCHFILE=65

read -p "File: " file   # -p arg to 'read' displays prompt.
if [ ! -e "$file" ]
then   # Bail out if no such file.
  echo "File $file not found."
  exit $E_NOSUCHFILE
fi

read -p "Title: " title
cat - $file &lt;&lt;&lt;$title &gt; $file.new

echo "Modified file is $file.new"

exit 0

# from "man bash"
# Here Strings
# 	A variant of here documents, the format is:
# 
# 		&lt;&lt;&lt;word
# 
# 	The word is expanded and supplied to the command on its standard input.
