/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: dacs.h 2528 2011-09-23 21:54:05Z brachman $
 */

/*****************************************************************************
 * COPYRIGHT AND PERMISSION NOTICE
 * 
 * Copyright (c) 2001-2003 The Queen in Right of Canada
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, provided that the above copyright notice(s) and this
 * permission notice appear in all copies of the Software and that both the
 * above copyright notice(s) and this permission notice appear in supporting
 * documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE 
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 * 
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization of the
 * copyright holder.
 ***************************************************************************/

#ifndef _DACS_H_
#define _DACS_H_

/*
 * This file defines the DACS API and brings in whatever declarations
 * and definitions are required.
 * All DACS utilities and web services should include this file.
 */

#include "local.h"
#include "ds.h"
#include "kwv.h"
#include "http.h"
#include "group.h"
#include "auth.h"
#include "acs.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Utility functions */
extern int dacs_init(DACS_app_type app, int *argc, char ***argv,
					 Kwv **kwv, char **errmsg);
extern int dacs_initialize(DACS_app_type app, int *argc, char **argv,
						   DACS_app_args *aa);
extern int dacs_app_init(DACS_app_type app_type, char *dacs_conf,
						 char *dacs_site_conf, char *app,
						 char *jurisdiction_name, char *service_uri,
						 Kwv **kwv, char **errmsg);
extern void dacs_abort(char *mesg);
extern void dacs_version(FILE *);
extern int dacs_verify_jurisdiction(char *jurisdiction);

extern Log_level dacs_set_log_startup_level(Log_level level);
extern void dacs_log_init(FILE *fp, char *path, int enabled);

/* ACS functions */
extern int dacs_acs(char *jurisdiction, char *uri, Kwv *kwv, Kwv *args,
					Credentials *credentials,
					Credentials *selected, Scredentials *scredentials,
					Cookie *cookies, Kwv *proxy_kwv, Rlink *rlink,
					Acs_result *result);


/* Group management functions */
extern int dacs_group_get_membership(char *jurisdiction, char *gname,
									 Groups **groups);
extern int dacs_create_group(char *jurisdiction, char *gname, char *gtype);
extern int dacs_delete_group(char *jurisdiction, char *name);
extern Dsvec *dacs_list_groups(char *jurisdiction, Dsvec **gfp);
extern int dacs_add_group_member(char *jurisdiction, char *gname, char *gmname,
								 char *mtype, char *dacs);
extern int dacs_delete_group_member(char *gname, char *jurisdiction,
									char *mname);
extern int dacs_get_group_definition(char *jurisdiction, char *gname,
									 char **def);
extern int dacs_receive_group_definition(char *jurisdiction, char *groups_str);
extern int dacs_send_group_definition(char *group_name_list, Groups **gp);
extern int dacs_change_group_definition(char *jurisdiction, char *gname,
										char *ngname);
extern int dacs_get_roles(Credentials *credentials, Roles_list **roles_list);
extern int dacs_list_group_membership(char *gmname, char *match_jurisdiction,
									  char *match_name, Dsvec **gfp);
extern int dacs_test_group_membership(Credentials *credentials, char *gname);
extern int dacs_apply_deltas(char *jurisdiction);

#ifdef __cplusplus
}
#endif

#endif
