/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.BuildProgramMenu;
import org.emboss.jemboss.gui.DragJTable;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceListTableModel;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.RemoteDragTree;
import org.emboss.jemboss.parser.AjaxUtil;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.CallAjax;
import org.emboss.jemboss.soap.JembossSoapException;

public class SequenceList
extends JFrame
implements TableModelListener {
    private DragJTable table;
    private SequenceListTableModel seqModel;
    protected static JCheckBoxMenuItem storeSeqList;
    final Cursor cbusy = new Cursor(3);
    final Cursor cdone = new Cursor(0);
    final boolean withSoap;
    final JembossParams mysettings;
    Preferences myPreferences;
    protected static JCheckBoxMenuItem getSeqLength;
    private static final String GET_SEQUENCE_LENGTH_AUTO = "GET_SEQUENCE_LENGTH_AUTOMATICALLY";
    private static final String STORE_SEQUENCE_LIST = "STORE_SEQUENCE_LIST";
    private static final String WINDOW_X_KEY = "WINDOW_X";
    private static final String WINDOW_Y_KEY = "WINDOW_Y";
    private static final String WINDOW_WIDTH_KEY = "WINDOW_WIDTH";
    private static final String WINDOW_HEIGHT_KEY = "WINDOW_HEIGHT";

    public SequenceList(boolean withSoap, final JembossParams mysettings) {
        super("Sequence List");
        this.withSoap = withSoap;
        this.mysettings = mysettings;
        this.myPreferences = Preferences.userNodeForPackage(SequenceList.class);
        this.setSize(400, 155);
        getSeqLength = new JCheckBoxMenuItem("Get sequence lengths automatically");
        if (this.myPreferences.getBoolean(GET_SEQUENCE_LENGTH_AUTO, false)) {
            getSeqLength.setSelected(true);
        }
        getSeqLength.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SequenceList.this.myPreferences.putBoolean(SequenceList.GET_SEQUENCE_LENGTH_AUTO, getSeqLength.isSelected());
            }
        });
        storeSeqList = new JCheckBoxMenuItem("Save Sequence List");
        if (this.myPreferences.getBoolean(STORE_SEQUENCE_LIST, false)) {
            storeSeqList.setSelected(true);
        }
        storeSeqList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SequenceList.this.myPreferences.putBoolean(SequenceList.STORE_SEQUENCE_LIST, SequenceList.this.isStoreSequenceList());
            }
        });
        this.seqModel = new SequenceListTableModel();
        this.table = new DragJTable(this.seqModel);
        this.table.setModel(this.seqModel);
        this.table.setSelectionMode(0);
        for (int i = 0; i < SequenceListTableModel.modelColumns.length; ++i) {
            TableColumn column = this.table.getColumn(SequenceListTableModel.modelColumns[i].title);
            column.setPreferredWidth(SequenceListTableModel.modelColumns[i].width);
        }
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.setSize(300, 100);
        this.getContentPane().add((Component)scrollpane, "Center");
        JMenuBar menuPanel = new JMenuBar();
        new BoxLayout(menuPanel, 0);
        this.setJMenuBar(menuPanel);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuPanel.add(fileMenu);
        JMenu toolMenu = new JMenu("Tools");
        toolMenu.setMnemonic(84);
        menuPanel.add(toolMenu);
        JMenuItem openMenuItem = new JMenuItem("Open");
        openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int nrow = SequenceList.this.table.getSelectedRow();
                String fileName = (String)SequenceList.this.table.getValueAt(nrow, SequenceList.this.table.convertColumnIndexToView(0));
                SequenceData row = (SequenceData)SequenceListTableModel.modelVector.elementAt(nrow);
                if (!row.s_remote.booleanValue()) {
                    DragTree.showFilePane(fileName, mysettings);
                } else {
                    RemoteDragTree.showFilePane(fileName, mysettings);
                }
            }
        });
        fileMenu.add(openMenuItem);
        toolMenu.add(getSeqLength);
        JMenuItem addSeq = new JMenuItem("Add sequence");
        addSeq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = SequenceList.this.table.getSelectedRow();
                SequenceList.this.seqModel.insertRow(row + 1);
                SequenceList.this.table.tableChanged(new TableModelEvent(SequenceList.this.seqModel, row + 1, row + 1, -1, 1));
            }
        });
        toolMenu.add(addSeq);
        JMenuItem deleteSeq = new JMenuItem("Delete sequence");
        deleteSeq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = SequenceList.this.table.getSelectedRow();
                if (SequenceList.this.seqModel.deleteRow(row)) {
                    SequenceList.this.table.tableChanged(new TableModelEvent(SequenceList.this.seqModel, row, row, -1, -1));
                }
            }
        });
        toolMenu.add(deleteSeq);
        JMenuItem reset = new JMenuItem("Remove all sequences");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceList.this.seqModel.setDefaultData();
                SequenceList.this.table.repaint();
            }
        });
        toolMenu.add(reset);
        toolMenu.addSeparator();
        File fseq = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        if (!fseq.exists()) {
            try {
                fseq.createNewFile();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (!fseq.canWrite()) {
            storeSeqList.setSelected(false);
            storeSeqList.setEnabled(false);
        }
        toolMenu.add(storeSeqList);
        fileMenu.addSeparator();
        JMenuItem closeFrame = new JMenuItem("Close");
        closeFrame.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceList.this.setVisible(false);
            }
        });
        fileMenu.add(closeFrame);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem fmh = new JMenuItem("About Sequence List");
        fmh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                try {
                    URL inURL = cl.getResource("resources/seqList.html");
                    new Browser(inURL, "resources/seqList.html");
                }
                catch (MalformedURLException mex) {
                    System.out.println("Didn't find resources/seqList.html");
                }
                catch (IOException iex) {
                    System.out.println("Didn't find resources/seqList.html");
                }
            }
        });
        helpMenu.add(fmh);
        menuPanel.add(helpMenu);
        this.table.getModel().addTableModelListener(this);
        this.setBounds();
    }

    private void setBounds() {
        int x = this.myPreferences.getInt(WINDOW_X_KEY, 10);
        int y = this.myPreferences.getInt(WINDOW_Y_KEY, 10);
        int width = this.myPreferences.getInt(WINDOW_WIDTH_KEY, 400);
        int height = this.myPreferences.getInt(WINDOW_HEIGHT_KEY, 200);
        this.setBounds(x, y, width, height);
    }

    public void saveBounds() {
        this.myPreferences.putInt(WINDOW_X_KEY, this.getX());
        this.myPreferences.putInt(WINDOW_Y_KEY, this.getY());
        this.myPreferences.putInt(WINDOW_WIDTH_KEY, this.getWidth());
        this.myPreferences.putInt(WINDOW_HEIGHT_KEY, this.getHeight());
    }

    private int getDefaultRow(int h) {
        int nrow = this.seqModel.getRowCount();
        int j = 0;
        for (int i = 0; i < nrow; ++i) {
            Boolean isDef = (Boolean)this.seqModel.getValueAt(i, 4);
            if (!isDef.booleanValue() || j++ != h) continue;
            return i;
        }
        return -1;
    }

    private int cygwinSeqAttr(String fc, JembossParams mysettings) {
        String[] envp = new String[2];
        String ps = new String(System.getProperty("path.separator"));
        String embossPath = mysettings.getEmbossPath();
        embossPath = new String("PATH" + ps + embossPath + ps + mysettings.getEmbossBin() + ps);
        envp[0] = "PATH=" + embossPath;
        envp[1] = "EMBOSS_DATA=" + mysettings.getEmbossData();
        String command = mysettings.getEmbossBin().concat("infoseq -only -type -length -nohead -auto " + fc);
        RunEmbossApplication2 rea = new RunEmbossApplication2(command, envp, null);
        rea.waitFor();
        String stdout = rea.getProcessStdout();
        if (stdout.trim().equals("")) {
            return -1;
        }
        StringTokenizer stok = new StringTokenizer(stdout, "\n ");
        stok.nextToken();
        return Integer.parseInt(stok.nextToken().trim());
    }

    public static int getSeqAttr(String fc, JembossParams mysettings) {
        String[] envp = BuildProgramMenu.getEnvp();
        String command = mysettings.getEmbossBin().concat("infoseq -only -type -length -nohead -auto " + fc);
        RunEmbossApplication2 rea = new RunEmbossApplication2(command, envp, null);
        rea.waitFor();
        String stdout = rea.getProcessStdout();
        if (stdout.trim().equals("")) {
            return -1;
        }
        StringTokenizer stok = new StringTokenizer(stdout, "\n ");
        int l = 0;
        while (stok.hasMoreElements()) {
            stok.nextToken();
            l += Integer.parseInt(stok.nextToken().trim());
        }
        return l;
    }

    public String getDefaultSequenceName(int h) {
        int ndef = this.getDefaultRow(h);
        if (ndef < 0) {
            return null;
        }
        String seqName = (String)this.seqModel.getValueAt(ndef, 0);
        if (this.table.isListFile(ndef).booleanValue()) {
            seqName = "@".concat(seqName);
        }
        return seqName;
    }

    public int getRowCount() {
        return this.seqModel.getRowCount();
    }

    public SequenceData getSequenceData(int nrow) {
        return this.seqModel.getSequenceData(nrow);
    }

    private void getSequenceLength() {
        int row = this.table.getSelectedRow();
        String fileOrEntryName = (String)this.seqModel.getValueAt(row, 0);
        if (fileOrEntryName != null && !fileOrEntryName.equals("") && !new File(fileOrEntryName).exists()) {
            this.setCursor(this.cbusy);
            String fc = AjaxUtil.getFileOrDatabaseForAjax(fileOrEntryName, BuildProgramMenu.getDatabaseList(), null, this.withSoap);
            boolean ok = false;
            int length = 0;
            if (!this.withSoap && fc != null) {
                if (JembossParams.isCygwin()) {
                    length = this.cygwinSeqAttr(fc, this.mysettings);
                    if (length > -1) {
                        ok = true;
                    }
                } else {
                    length = SequenceList.getSeqAttr(fc, this.mysettings);
                    if (length > -1) {
                        ok = true;
                    }
                }
            } else if (fc != null) {
                try {
                    CallAjax ca = new CallAjax(fc, "sequence", this.mysettings);
                    if (ca.getStatus().equals("0")) {
                        length = ca.getLength();
                        ok = true;
                    }
                }
                catch (JembossSoapException eae) {
                    System.out.println("Call to Ajax library failed");
                    this.setCursor(this.cdone);
                }
            }
            if (!ok && fc != null) {
                if (this.mysettings.getServicePasswdByte() != null || !this.mysettings.getUseAuth()) {
                    JOptionPane.showMessageDialog(null, "Sequence not found!", "Error Message", 0);
                } else {
                    AuthPopup ap = new AuthPopup(this.mysettings, null);
                    ap.setBottomPanel();
                    ap.setSize(380, 170);
                    ap.pack();
                    ap.setVisible(true);
                }
            } else {
                this.seqModel.setValueAt(new Integer(1), row, 1);
                this.seqModel.setValueAt(new Integer(length), row, 2);
                this.seqModel.fireTableDataChanged();
            }
            this.setCursor(this.cdone);
        }
    }

    public boolean isStoreSequenceList() {
        return storeSeqList.isSelected();
    }

    public void tableChanged(TableModelEvent e) {
        if (!getSeqLength.isSelected()) {
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row == -1 || column == -1) {
            return;
        }
        this.getSequenceLength();
    }
}

