#include <glib.h>
#include "edv_context.h"
#include "edv_get.h"
#include "edv_utils.h"
#include "edv_cfg_list.h"


/* Message Output */
void EDVMessage(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
);
void EDVMessageInfo(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
);
void EDVMessageWarning(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
);
void EDVMessageError(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
);
void EDVMessageFromFile(
	edv_context_struct *ctx,
	const gchar *path, const gchar *title,
	gint cdialog_icon,
	gpointer toplevel
);

/* Play Sound */
void EDVBeep(edv_context_struct *ctx);
void EDVPlaySoundBeep(edv_context_struct *ctx);      
void EDVPlaySoundInfo(edv_context_struct *ctx);
void EDVPlaySoundQuestion(edv_context_struct *ctx);
void EDVPlaySoundWarning(edv_context_struct *ctx);
void EDVPlaySoundError(edv_context_struct *ctx);  
void EDVPlaySoundCompleted(edv_context_struct *ctx);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Displays a message and blocks input until a user response.
 */
void EDVMessage(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
)
{
	EDVMessageInfo(ctx, title, message, details, toplevel);
}
void EDVMessageInfo(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
)
{

}

/*
 *	Displays a warning message and blocks input until a user
 *	response.
 */
void EDVMessageWarning(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
)
{

}

/*
 *	Displays an error message and blocks input until a user
 *	response.
 */
void EDVMessageError(
	edv_context_struct *ctx,
	const gchar *title, const gchar *message, const gchar *details,
	gpointer toplevel
)
{

}

/*
 *	Displays the contents of the file in a message dialog and blocks
 *	input until a user response.
 */
void EDVMessageFromFile(
	edv_context_struct *ctx,
	const gchar *path, const gchar *title,
	gint cdialog_icon,
	gpointer toplevel
)
{

}


/*
 *	Plays the "Beep" sound.
 */
void EDVBeep(edv_context_struct *ctx)
{
	EDVPlaySoundBeep(ctx);
}
void EDVPlaySoundBeep(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_BEEP);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}

/*
 *      Plays the "Info" sound.
 */
void EDVPlaySoundInfo(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{   
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_INFO);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}

/*
 *	Plays the "Question" sound.
 */
void EDVPlaySoundQuestion(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{   
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_QUESTION);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}

/*
 *	Plays the "Warning" sound.
 */
void EDVPlaySoundWarning(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{   
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_WARNING);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}

/*
 *	Plays the "Error" sound.
 */
void EDVPlaySoundError(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{   
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_ERROR);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}

/*
 *	Plays the "Completed" sound.
 */
void EDVPlaySoundCompleted(edv_context_struct *ctx)
{
	if(ctx == NULL)
	    return;

	if(EDVGetI(ctx, EDV_CFG_PARM_SOUND_USE_SYSTEM))
	{

	}
	else
	{   
	    const gchar *s = EDVGetS(ctx, EDV_CFG_PARM_SOUND_PLAY_COMPLETED);
	    if(!STRISEMPTY(s))
		EDVSystem(s);
	}
}
