/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.ReaderFilter;
import com.sap.dbtech.util.MessageTranslator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class UnicodeProcedurePutval
extends AbstractProcedurePutval {
    private Reader reader;
    private boolean atBegin;
    private boolean marksupported;
    private int length;

    public UnicodeProcedurePutval(DBTechTranslator dBTechTranslator, char[] cArray) {
        this(dBTechTranslator, new CharArrayReader(cArray), -1);
    }

    public UnicodeProcedurePutval(DBTechTranslator dBTechTranslator, Reader reader, int n) {
        super(dBTechTranslator);
        if (n <= 0) {
            this.reader = reader;
            this.length = Integer.MAX_VALUE;
        } else {
            this.reader = new ReaderFilter(reader, n);
            this.length = n;
        }
        this.atBegin = true;
        this.marksupported = this.reader.markSupported();
    }

    public void transferStream(DataPart dataPart, short s) throws SQLException {
        if (s == -2) {
            if (!this.atBegin) {
                if (this.marksupported) {
                    try {
                        this.reader.reset();
                        this.atBegin = true;
                        this.reader.mark(this.length);
                    }
                    catch (IOException iOException) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.reset.stream"));
                }
            }
            s = Short.MAX_VALUE;
        } else if (this.atBegin && this.marksupported) {
            try {
                this.reader.mark(this.length);
            }
            catch (IOException iOException) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
            }
        }
        if (dataPart.fillWithProcedureReader(this.reader, s)) {
            // empty if block
        }
        this.atBegin = false;
    }

    public void closeStream() throws SQLExceptionSapDB {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
    }
}

