#include <windows.h>
#include <sstream>

#include "lexertest.h"
#include "myxsqltreeitem.h"
#include "myx_sql_parser_public_interface.h"
#include "myx_lex_helpers.h"

void LexerTest::cppunit_assert(bool cond)
{
  if(!cond) {
    throw new LexerTestException();
  }
}

void LexerTest::testLexer()
{
  //basicLexerTest();
  //sqlTest();
  basicParserTest();
  //stmtscanTest();
}

void LexerTest::basicLexerTest()
{
  //yyin = stdin;
  
  //lex_input_stream = new std::ifstream("c:/co/test 20051018 2143.sql");
  //lex_input_stream->rdbuf()->pubsetbuf(new char[10*1024*1024], 10*1024*1024);

  //lex_input_stream = new std::istringstream(
  //  "'some string' ident ident1 1ident 111 x'123456' 111.111 111.222e111 1e1 1d1 `askd@#$53da\x01\x02\xCCs` "
  //  "SELECT select SeLeCt SELECTION");
  
  //h_file= ::CreateFile("d:/test 20051018 2143.sql", GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0, 0);

  //long t1= ::GetTickCount();
  //yylex(0);
  //printf("%d\n", ::GetTickCount() - t1);

  //::CloseHandle(h_file);
}

void LexerTest::sqlTest()
{
  //char *yylval;
  //int token;
  //lex_input_stream = new std::istringstream("select a from tbl ");
  //token= yylex(&yylval);
  //token= yylex(&yylval);
  //token= yylex(&yylval);
  //token= yylex(&yylval);
  //token= yylex(&yylval);
  //std::ifstream s("test1.sql");
  //std::ifstream s("test2.sql");
}

int stmt_parser_cb(const char *sql, void *user_data)
{
  printf("stmt: '%s'\n", sql);
  return 0;
}

void LexerTest::stmtscanTest()
{
  //const char *c;
  //c= "CREATE DATABASE IF NOT EXISTS `i-flow_dev` CHARACTER SET latin1 COLLATE latin1_swedish_ci;";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "select * from a; select * from b; insert into c values (1,2,3); /* comment ; */; ;";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "select * from a; delimiter %%%\n delimiter $$$%%%\n\r select * from a $$$ select ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "select * from a; # comment ; \n\r select * from b";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "/* comment ; ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "\" string ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "\' string ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "-- comment ; something ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "# comment ; something ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_NORMAL_MODE);
  //c= "select * from a; // blablabla ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_DELIMS_REQUIRED);
  //c= "# comment ; something ";
  //myx_process_sql_statements(c, stmt_parser_cb, NULL, MYX_SPM_DELIMS_REQUIRED); //should _not_ call cb

  // crash test
  myx_process_sql_statements_from_file("C:\\test 20051018 2143.sql", stmt_parser_cb, NULL, MYX_SPM_DELIMS_REQUIRED);
}

void LexerTest::basicParserTest()
{
  //"select a into outfile \"file.txt\" fields terminated by \",\" optionally enclosed by \"\\\"\" lines starting by \"x\" terminated by \"y\" from tbl1 inner join tbl2 on a = b inner join tbl3 on b = c where x = b group by x having x = z order by z asc, q desc limit 1, 2"
  //"select a from tbl where x in (1,2,3)"
  //"select a from tbl where x not in (select b from tbl where y in (select c from tbl where z in (a,b,c)))"
  //"select 1+2*3*(4-5)"
  //"select * from a where x like y"
  //"select * from a union select * from b union select * from c"
  //"select tbl1.*, tbl2.* from tbl1 a inner join tbl2 b"
  //"insert into q (a,b,c) values (\"aaa\", 123, \"456\")"
  //"insert into tbl (a,b,c) values (1,2,3) on duplicate key update c=values(a)+values(b)"
  //"delete from tbl"
  //"delete from tbl1 where x = y limit 3"
  //"update tbl set a=x, b=y where c=1"
  //myx_set_parser_source("create table t1 (id int)");

  myx_set_parser_source("use `schema_name`");

  //myx_set_parser_source("create table mycatalog.myschema.mytable (mykey int(10) unsigned NOT NULL auto_increment, mytext varchar(45) NOT NULL default \"\", PRIMARY KEY  (mykey) ) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=DEFAULT AUTO_INCREMENT=2 COMMENT = \"comment string\"");
  //myx_set_parser_source("create table mytable (mykey int(10) unsigned NOT NULL auto_increment, mytext varchar(45) NOT NULL default \"\", PRIMARY KEY  (mykey) ) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=DEFAULT AUTO_INCREMENT=2");
  //myx_set_parser_source("drop tables t1, t2, t3 cascade");
  //myx_set_parser_source("create database if not exists db1");
  //myx_set_parser_source("create fulltext index idx1 using btree on tbl1 (k1, k2, k3)");
  //myx_set_parser_source("create view v1 as select * from t1 where x=y");
  //myx_set_parser_source("create user u1 identified by \"p1\"");
  //myx_set_parser_source("drop index idx1 on tbl1");
  //myx_set_parser_source("drop database db1");
  //myx_set_parser_source("create procedure p1 (in arg1 int(10), out arg2 int(20)) language sql deterministic begin select * into arg2 from tbl; end");
  //myx_set_parser_source("ALTER TABLE t2 DROP COLUMN c, DROP COLUMN d");
  //myx_set_parser_source("ALTER TABLE t1 CHANGE a b INTEGER");
  //myx_set_parser_source("ALTER TABLE t1 CHANGE b b BIGINT NOT NULL");
  //myx_set_parser_source("ALTER TABLE tbl_name CONVERT TO CHARACTER SET charset_name");
  //myx_set_parser_source("ALTER TABLE tbl_name DISCARD TABLESPACE");
  //myx_set_parser_source("SET sort_buffer_size=10000");
  //myx_set_parser_source("SET @@local.sort_buffer_size=10000");
  //myx_set_parser_source("SET GLOBAL sort_buffer_size=1000000, SESSION sort_buffer_size=1000000");
  //myx_set_parser_source("ANALYZE NO_WRITE_TO_BINLOG TABLE t2");
  //myx_set_parser_source("BACKUP TABLE t2 TO \"/path/to/backup/directory\"");
  //myx_set_parser_source("CALL sp_name(p1, p2, p3)");
  //myx_set_parser_source("CHANGE MASTER TO MASTER_PASSWORD=\"new3cret\"");
  //myx_set_parser_source("CHECK TABLE tbl_name QUICK");
  //myx_set_parser_source("COMMIT NO RELEASE");
  //myx_set_parser_source("DESC SELECT * FROM t4");
  //myx_set_parser_source("DO a = 1, b = 2");
  //myx_set_parser_source("EXECUTE stmt1 USING @a, @b");
  //myx_set_parser_source("flush privileges");
  //myx_set_parser_source("GRANT ALL ON test.* TO \"\"@\"localhost\"");
  //myx_set_parser_source("HANDLER tbl_name READ `PRIMARY` > (a, b, c)");
  //myx_set_parser_source("KILL a");
  //myx_set_parser_source("LOAD DATA INFILE \"data.txt\" INTO TABLE db2.my_table");
  //myx_set_parser_source("LOCK TABLE t WRITE, t AS t1 WRITE");
  //myx_set_parser_source("CACHE INDEX t1, t2, t3 IN hot_cache");
  //myx_set_parser_source("LOAD INDEX INTO CACHE t1, t2 IGNORE LEAVES");
  //myx_set_parser_source("PREPARE stmt1 FROM \"SELECT * FROM t1\"");
  //myx_set_parser_source("PURGE MASTER LOGS TO \"mysql-bin.010\"");
  //myx_set_parser_source("RENAME USER old_user TO new_user");
  //myx_set_parser_source("repair table t2 extended");
  //myx_set_parser_source("reset master");
  //myx_set_parser_source("REVOKE ALL PRIVILEGES, GRANT OPTION FROM user ");
  //myx_set_parser_source("ROLLBACK TO SAVEPOINT identifier");
  //myx_set_parser_source("SHOW BINARY LOGS");
  //myx_set_parser_source("STOP SLAVE");
  //myx_set_parser_source("XA ROLLBACK \"xid\"");
  
  myx_parse();
  myx_free_parser_source();
  std::ofstream("treedump.xml") << *static_cast<MyxSQLTreeItem *>(myx_get_parser_tree());
}