unit MyxEditor;

interface

uses
  Forms, MyxBaseForm, Grt, Classes;

type
  TMyxEditorForm = class(TMyxBaseForm)
  private
    { Private declarations }
    FObj,
    FOriginalObj: Pointer;

    FObjStructName: WideString;

    FModified: Boolean;
  protected
    procedure SetModified(Modified: Boolean); virtual;
  public
    { Public declarations }
    property Obj: Pointer read FObj;
    property ObjStructName: WideString read FObjStructName;

    property OriginalObj: Pointer read FOriginalObj;

    property Modified: Boolean read FModified write SetModified;

    constructor Create(AOwner: TComponent); overload; override;

    procedure StartEditObject(Obj: Pointer); virtual;
    procedure EndEditObject; virtual;

    procedure DiscardChanges; virtual;
    procedure ApplyChanges; virtual;

    procedure DoClose(var Action: TCloseAction); override;
  end;

implementation

// -----------------------------------------------------------------------------

constructor TMyxEditorForm.Create(AOwner: TComponent);

begin
  inherited;

  FObj := nil;
  FOriginalObj := nil;
  FModified := False;

  FObjStructName := '';
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.StartEditObject(Obj: Pointer);

begin
  FOriginalObj := Obj;
  Grt.ValueRetain(FOriginalObj);
  FObj := Grt.ValueDuplicate(Obj);

  FObjStructName := Grt.DictStructName[Obj];
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.ApplyChanges;

var
  Diff: Pointer;

begin
  Grt.ShellVar['editObj'] := FOriginalObj;
  Grt.ShellVar['editObjMod'] := FObj;

  // Apply diff to original object
  Diff := Grt.ValueDiffMake(FOriginalObj, FObj);

  Grt.ShellVar['editDiff'] := Diff;
  Grt.ValueDiffApply(FOriginalObj, Diff);

  Grt.ValueRelease(Diff);

  Modified := False;
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.DiscardChanges;

begin
  Grt.ValueRelease(Obj);

  StartEditObject(FOriginalObj);

  Grt.ValueRelease(FOriginalObj);
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.EndEditObject;

begin
  Grt.ValueRelease(Obj);

  Grt.ValueRelease(FOriginalObj);
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.DoClose(var Action: TCloseAction);

begin
  EndEditObject;

  inherited;
end;

// -----------------------------------------------------------------------------

procedure TMyxEditorForm.SetModified(Modified: Boolean);

begin
  FModified := True;
end;

end.
