/*
 * PDFedit - free program for PDF document manipulation.
 * Copyright (C) 2006, 2007, 2008  PDFedit team: Michal Hocko,
 *                                              Miroslav Jahoda,
 *                                              Jozef Misutka,
 *                                              Martin Petricek
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in doc/LICENSE.GPL); if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA
 *
 * Project is hosted on http://sourceforge.net/projects/pdfedit
 */
#ifndef __TREEITEMPAGEOBSERVER_H__
#define __TREEITEMPAGEOBSERVER_H__

#include "treeitemgenericobserver.h"
#include <kernel/cpage.h>
#include <utils/observer.h>

namespace gui {

/**
 This class provides observer monitoring CPage item.<br>
 The observer will reload associated tree item when the observed item changes.
 \brief Observer for TreeItemPage
*/
class TreeItemPageObserver : public TreeItemGenericObserver<pdfobjects::CPage> {
public:
 /**
  Constructor
  @param _parent Object to be reloaded on any change to monitored item
 */
 TreeItemPageObserver(TreeItemAbstract* _parent) : TreeItemGenericObserver<pdfobjects::CPage> (_parent) {
  //No extra initialization
 };
 /** Destructor */
 virtual ~TreeItemPageObserver() throw() {
  //Empty for now
 }
};

} // namespace gui

#endif
