/*
 * browserdlg.h - main dialog for iq:browse protocol
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef BROWSERDLG_H
#define BROWSERDLG_H

#include "ui_browser.h"

#include"xmpp.h"
using namespace XMPP;

class QAction;
class QToolBar;

class PsiAccount;
class BusyWidget;

class BrowserItem;

class BrowserDlg : public BrowserUI
{
	Q_OBJECT

public:
	BrowserDlg(const Jid &, PsiAccount *);
	~BrowserDlg();

public slots:
	void doBrowse(const QString &host = "");

signals:
	void signalRegister(const Jid &);
	void signalSearch(const Jid &);
	void signalJoin(const Jid &);

private slots:
	void itemSelected (QListViewItem *);
	void itemDoubleclicked (QListViewItem *);

public:
	class Private;
private:
	friend class Private;
	friend class BrowserItem;
	Private *d;
};

#endif
