#
# Psi qmake profile
#

# Configuration
TEMPLATE = app
CONFIG  += qt thread x11

#CONFIG += use_crash
#DEFINES += GPG_DEBUG

# Executable name
TARGET    = psi

MOC_DIR        = .moc
OBJECTS_DIR    = .obj
UI_DIR         = .ui

# qconf
exists(../conf.pri) {
	include(../conf.pri)

	# Shared files
	sharedfiles.path  = $$DATADIR
	sharedfiles.files = ../README ../COPYING ../iconsets ../sound ../certs
	INSTALLS += sharedfiles

	# Widgets
	#widgets.path = $$DATADIR/designer
	#widgets.files = ../libpsi/psiwidgets/libpsiwidgets.so
	#INSTALLS += widgets

	# icons and desktop files
	dt.path=$$PREFIX/share/applications/
	dt.files = ../psi.desktop 
	icon1.path=$$PREFIX/share/icons/hicolor/16x16/apps
	icon1.extra = cp -f ../iconsets/system/default/icon_16.png $(INSTALL_ROOT)$$icon1.path/psi.png
	icon2.path=$$PREFIX/share/icons/hicolor/32x32/apps
	icon2.extra = cp -f ../iconsets/system/default/icon_32.png $(INSTALL_ROOT)$$icon2.path/psi.png
	icon3.path=$$PREFIX/share/icons/hicolor/48x48/apps
	icon3.extra = cp -f ../iconsets/system/default/icon_48.png $(INSTALL_ROOT)$$icon3.path/psi.png
	INSTALLS += dt icon1 icon2 icon3
}

win32: {
	include(../conf_win32.pri)
}

# qxml
!isEmpty(QXML_STATIC) {
	unix: {
		INCLUDEPATH += tools/qxml
		HEADERS += tools/qxml/qxml.h tools/qxml/qdom.h
		SOURCES += tools/qxml/qxml.cpp tools/qxml/qdom.cpp
	}
}

# IPv6 ?
#DEFINES += NO_NDNS

# include some of cutestuff
CONFIG += psics
IRISCS_CPP = ../../cutestuff
exists(../cutestuff) {
	IRISCS_CPP = ../cutestuff
}
PSICS_CPP = tools
include(../psics.pri)

# qca
#DEFINES += QCA_STATIC
#QCA_PREFIX = ../qca
#!exists(../qca) {
#	QCA_PREFIX = ../../qca/src
#}
#INCLUDEPATH += $$QCA_PREFIX
#HEADERS += $$QCA_PREFIX/qca.h $$QCA_PREFIX/qcaprovider.h
#SOURCES += $$QCA_PREFIX/qca.cpp

# libxmpp
#CONFIG += xmpp
#XMPP_BASE = ../../xmpp
#exists(../xmpp) {
#	XMPP_BASE = ../xmpp
#}
#include($$XMPP_BASE/xmpp.pri)

# include Iris XMPP library
#CONFIG += iris
IRIS_BASE = ../../iris
exists(../iris) {
	IRIS_BASE = ../iris
}
include(../iris.pri)

# include Psi library
CONFIG += libpsi
LIBPSI_CPP = ../../libpsi
exists(../libpsi) {
	LIBPSI_CPP = ../libpsi
}
include(../libpsi.pri)

# Psi sources
PSI_CPP = .

# Header files
HEADERS += \
	$$PSI_CPP/varlist.h \
	$$PSI_CPP/showtextdlg.h \
	$$PSI_CPP/profiles.h \
	$$PSI_CPP/profiledlg.h \
	$$PSI_CPP/main.h \
	$$PSI_CPP/psiaccount.h \
	$$PSI_CPP/psicon.h \
	$$PSI_CPP/psievent.h \
	$$PSI_CPP/xmlconsole.h \
	$$PSI_CPP/contactview.h \
	$$PSI_CPP/psiiconset.h \
	$$PSI_CPP/userlist.h \
	$$PSI_CPP/mainwin.h \
	$$PSI_CPP/mainwin_p.h \
	$$PSI_CPP/rtparse.h \
	$$PSI_CPP/common.h \
	$$PSI_CPP/proxy.h \
	$$PSI_CPP/accountdlg.h \
	$$PSI_CPP/changepwdlg.h \
	$$PSI_CPP/msgmle.h \
	$$PSI_CPP/statusdlg.h \
	$$PSI_CPP/eventdlg.h \
	$$PSI_CPP/chatdlg.h \
	$$PSI_CPP/tabdlg.h \
	$$PSI_CPP/adduserdlg.h \
	$$PSI_CPP/groupchatdlg.h \
	$$PSI_CPP/infodlg.h \
	$$PSI_CPP/eventdb.h \
	$$PSI_CPP/historydlg.h \
	$$PSI_CPP/servicesdlg.h \
	$$PSI_CPP/jltest.h \
#	$$PSI_CPP/browserdlg.h \
	$$PSI_CPP/psitoolbar.h \
	$$PSI_CPP/passphrasedlg.h \
	$$PSI_CPP/vcardfactory.h \
	$$PSI_CPP/sslcertdlg.h \
	$$PSI_CPP/qwextend.h \
	$$PSI_CPP/tasklist.h \
	$$PSI_CPP/discodlg.h \
	$$PSI_CPP/alerticon.h \
	$$PSI_CPP/psipopup.h \
	$$PSI_CPP/psiapplication.h \
	$$PSI_CPP/filetransdlg.h \
	$$PSI_CPP/avatars.h \
	$$PSI_CPP/actionlist.h \
	$$PSI_CPP/psiactionlist.h \
	$$PSI_CPP/xdata_widget.h \
	$$PSI_CPP/xmpp_xdata.h

# Source files
SOURCES += \
	$$PSI_CPP/varlist.cpp \
	$$PSI_CPP/showtextdlg.cpp \
	$$PSI_CPP/psi_profiles.cpp \
	$$PSI_CPP/profiledlg.cpp \
	$$PSI_CPP/main.cpp \
	$$PSI_CPP/psiaccount.cpp \
	$$PSI_CPP/psicon.cpp \
	$$PSI_CPP/psievent.cpp \
	$$PSI_CPP/xmlconsole.cpp \
	$$PSI_CPP/contactview.cpp \
	$$PSI_CPP/psiiconset.cpp \
	$$PSI_CPP/userlist.cpp \
	$$PSI_CPP/mainwin.cpp \
	$$PSI_CPP/mainwin_p.cpp \
	$$PSI_CPP/rtparse.cpp \
	$$PSI_CPP/common.cpp \
	$$PSI_CPP/proxy.cpp \
	$$PSI_CPP/accountdlg.cpp \
	$$PSI_CPP/changepwdlg.cpp \
	$$PSI_CPP/msgmle.cpp \
	$$PSI_CPP/statusdlg.cpp \
	$$PSI_CPP/eventdlg.cpp \
	$$PSI_CPP/chatdlg.cpp \
	$$PSI_CPP/tabdlg.cpp \
	$$PSI_CPP/adduserdlg.cpp \
	$$PSI_CPP/groupchatdlg.cpp \
	$$PSI_CPP/infodlg.cpp \
	$$PSI_CPP/eventdb.cpp \
	$$PSI_CPP/historydlg.cpp \
	$$PSI_CPP/servicesdlg.cpp \
	$$PSI_CPP/jltest.cpp \
#	$$PSI_CPP/browserdlg.cpp \
	$$PSI_CPP/psitoolbar.cpp \
	$$PSI_CPP/passphrasedlg.cpp \
	$$PSI_CPP/vcardfactory.cpp \
	$$PSI_CPP/sslcertdlg.cpp \
	$$PSI_CPP/qwextend.cpp \
	$$PSI_CPP/discodlg.cpp \
	$$PSI_CPP/alerticon.cpp \
	$$PSI_CPP/psipopup.cpp \
	$$PSI_CPP/psiapplication.cpp \
	$$PSI_CPP/filetransdlg.cpp \
	$$PSI_CPP/avatars.cpp \
	$$PSI_CPP/actionlist.cpp \
	$$PSI_CPP/psiactionlist.cpp \
	$$PSI_CPP/xdata_widget.cpp \
	$$PSI_CPP/xmpp_xdata.cpp
mac {
	contains( DEFINES, HAVE_GROWL ) {
		HEADERS += $$PSI_CPP/psigrowlnotifier.h 
		SOURCES += $$PSI_CPP/psigrowlnotifier.cpp 
	}
}

# Qt Designer interfaces
INTERFACES = \
	$$PSI_CPP/ui_profileopen.ui \
	$$PSI_CPP/ui_profilemanage.ui \
	$$PSI_CPP/ui_profilenew.ui \
	$$PSI_CPP/ui_proxy.ui \
	$$PSI_CPP/ui_pgpkey.ui \
	$$PSI_CPP/ui_accountmanage.ui \
	$$PSI_CPP/ui_accountadd.ui \
	$$PSI_CPP/ui_accountreg.ui \
	$$PSI_CPP/ui_accountremove.ui \
	$$PSI_CPP/ui_accountmodify.ui \
	$$PSI_CPP/ui_changepw.ui \
	$$PSI_CPP/ui_addurl.ui \
	$$PSI_CPP/ui_adduser.ui \
	$$PSI_CPP/ui_gcjoin.ui \
	$$PSI_CPP/ui_info.ui \
	$$PSI_CPP/ui_search.ui \
	$$PSI_CPP/ui_about.ui \
#	$$PSI_CPP/ui_browser.ui \
	$$PSI_CPP/ui_passphrase.ui \
	$$PSI_CPP/ui_sslcert.ui \
	$$PSI_CPP/ui_disco.ui \
	$$PSI_CPP/ui_tip.ui \
	$$PSI_CPP/ui_filetrans.ui

# options dialog
include(options/options.pri)

LANG_PATH = ../lang

# Translations
TRANSLATIONS = \
	$$LANG_PATH/psi_ar.ts \
	$$LANG_PATH/psi_ca.ts \
	$$LANG_PATH/psi_cs.ts \
	$$LANG_PATH/psi_da.ts \
	$$LANG_PATH/psi_de.ts \
	$$LANG_PATH/psi_el.ts \
	$$LANG_PATH/psi_eo.ts \
	$$LANG_PATH/psi_es.ts \
	$$LANG_PATH/psi_fi.ts \
	$$LANG_PATH/psi_fr.ts \
	$$LANG_PATH/psi_it.ts \
	$$LANG_PATH/psi_jp.ts \
	$$LANG_PATH/psi_mk.ts \
	$$LANG_PATH/psi_nl.ts \
	$$LANG_PATH/psi_pl.ts \
	$$LANG_PATH/psi_pt.ts \
	$$LANG_PATH/psi_ptbr.ts \
	$$LANG_PATH/psi_ru.ts \
	$$LANG_PATH/psi_se.ts \
	$$LANG_PATH/psi_sk.ts \
	$$LANG_PATH/psi_sr.ts \
	$$LANG_PATH/psi_zh.ts

# Platform specifics
unix:!mac {
	QMAKE_POST_LINK = rm -f ../psi ; ln -s src/psi ../psi
}
win32: {
	RC_FILE = ../win32/psi_win32.rc

	# buggy MSVC workaround
	contains(MAKEFILE_GENERATOR, MSVC):     QMAKE_LFLAGS += /FORCE:MULTIPLE
	contains(MAKEFILE_GENERATOR, MSVC.NET): QMAKE_LFLAGS += /FORCE:MULTIPLE
}
mac: {
	QMAKE_LFLAGS += -framework Carbon -framework IOKit
	QMAKE_INFO_PLIST = ../mac/Info.plist
	RC_FILE = ../mac/application.icns
	QMAKE_POST_LINK = cp -R ../COPYING ../README ../certs ../iconsets ../sound $(DESTDIR)../Resources ; echo "APPLpsi " > $(DESTDIR)../PkgInfo
}
