/* IconTasklistApplet.c generated by valac 0.32.1, the Vala compiler
 * generated from IconTasklistApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <libwnck/libwnck.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_ICON_TASKLIST (icon_tasklist_get_type ())
#define ICON_TASKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_TASKLIST, IconTasklist))
#define ICON_TASKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_TASKLIST, IconTasklistClass))
#define IS_ICON_TASKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_TASKLIST))
#define IS_ICON_TASKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_TASKLIST))
#define ICON_TASKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_TASKLIST, IconTasklistClass))

typedef struct _IconTasklist IconTasklist;
typedef struct _IconTasklistClass IconTasklistClass;
typedef struct _IconTasklistPrivate IconTasklistPrivate;

#define TYPE_ICON_TASKLIST_APPLET (icon_tasklist_applet_get_type ())
#define ICON_TASKLIST_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet))
#define ICON_TASKLIST_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_TASKLIST_APPLET, IconTasklistAppletClass))
#define IS_ICON_TASKLIST_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_TASKLIST_APPLET))
#define IS_ICON_TASKLIST_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_TASKLIST_APPLET))
#define ICON_TASKLIST_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_TASKLIST_APPLET, IconTasklistAppletClass))

typedef struct _IconTasklistApplet IconTasklistApplet;
typedef struct _IconTasklistAppletClass IconTasklistAppletClass;

#define TYPE_DESKTOP_HELPER (desktop_helper_get_type ())
#define DESKTOP_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_HELPER, DesktopHelper))
#define DESKTOP_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_HELPER, DesktopHelperClass))
#define IS_DESKTOP_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_HELPER))
#define IS_DESKTOP_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_HELPER))
#define DESKTOP_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_HELPER, DesktopHelperClass))

typedef struct _DesktopHelper DesktopHelper;
typedef struct _DesktopHelperClass DesktopHelperClass;
typedef struct _DesktopHelperPrivate DesktopHelperPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _IconTasklistAppletPrivate IconTasklistAppletPrivate;

#define TYPE_ICON_BUTTON (icon_button_get_type ())
#define ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_BUTTON, IconButton))
#define ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_BUTTON, IconButtonClass))
#define IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_BUTTON))
#define IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_BUTTON))
#define ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_BUTTON, IconButtonClass))

typedef struct _IconButton IconButton;
typedef struct _IconButtonClass IconButtonClass;

#define TYPE_PINNED_ICON_BUTTON (pinned_icon_button_get_type ())
#define PINNED_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PINNED_ICON_BUTTON, PinnedIconButton))
#define PINNED_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PINNED_ICON_BUTTON, PinnedIconButtonClass))
#define IS_PINNED_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PINNED_ICON_BUTTON))
#define IS_PINNED_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PINNED_ICON_BUTTON))
#define PINNED_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PINNED_ICON_BUTTON, PinnedIconButtonClass))

typedef struct _PinnedIconButton PinnedIconButton;
typedef struct _PinnedIconButtonClass PinnedIconButtonClass;

#define TYPE_APP_SYSTEM (app_system_get_type ())
#define APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SYSTEM, AppSystem))
#define APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SYSTEM, AppSystemClass))
#define IS_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SYSTEM))
#define IS_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SYSTEM))
#define APP_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SYSTEM, AppSystemClass))

typedef struct _AppSystem AppSystem;
typedef struct _AppSystemClass AppSystemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _IconButtonPrivate IconButtonPrivate;
typedef struct _PinnedIconButtonPrivate PinnedIconButtonPrivate;

#define TYPE_BUTTON_WRAPPER (button_wrapper_get_type ())
#define BUTTON_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUTTON_WRAPPER, ButtonWrapper))
#define BUTTON_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUTTON_WRAPPER, ButtonWrapperClass))
#define IS_BUTTON_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUTTON_WRAPPER))
#define IS_BUTTON_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUTTON_WRAPPER))
#define BUTTON_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUTTON_WRAPPER, ButtonWrapperClass))

typedef struct _ButtonWrapper ButtonWrapper;
typedef struct _ButtonWrapperClass ButtonWrapperClass;
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _IconTasklist {
	PeasExtensionBase parent_instance;
	IconTasklistPrivate * priv;
};

struct _IconTasklistClass {
	PeasExtensionBaseClass parent_class;
};

struct _DesktopHelper {
	GObject parent_instance;
	DesktopHelperPrivate * priv;
};

struct _DesktopHelperClass {
	GObjectClass parent_class;
};

struct _IconTasklistApplet {
	BudgieApplet parent_instance;
	IconTasklistAppletPrivate * priv;
	GtkBox* widget;
	GtkBox* main_layout;
	GtkBox* pinned;
	WnckScreen* screen;
	GHashTable* buttons;
	GHashTable* pin_buttons;
	gint icon_size;
	AppSystem* helper;
};

struct _IconTasklistAppletClass {
	BudgieAppletClass parent_class;
};

struct _IconTasklistAppletPrivate {
	GSettings* settings;
	IconButton* active_button;
	gchar* _uuid;
	gint small_icons;
	gint panel_size;
};

struct _Block1Data {
	int _ref_count_;
	IconTasklistApplet* self;
	IconButton* button;
};

struct _IconButton {
	GtkToggleButton parent_instance;
	IconButtonPrivate * priv;
	GtkImage* image;
	WnckWindow* window;
	WnckActionMenu* menu;
	gint icon_size;
	GDesktopAppInfo* ainfo;
	gboolean requested_pin;
	gboolean should_fade_in;
	GtkAllocation our_alloc;
	gint current_cycles;
	gint panel_size;
	GdkAppLaunchContext* launch_context;
};

struct _IconButtonClass {
	GtkToggleButtonClass parent_class;
	void (*update_icon) (IconButton* self);
	gboolean (*on_button_release) (IconButton* self, GdkEventButton* event);
};

struct _PinnedIconButton {
	IconButton parent_instance;
	PinnedIconButtonPrivate * priv;
	GDesktopAppInfo* app_info;
	gchar* id;
};

struct _PinnedIconButtonClass {
	IconButtonClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	IconTasklistApplet* self;
	WnckWindow* btn_key;
	const gchar* str_key;
	IconButton* val;
	PinnedIconButton* pin_val;
};

struct _Block3Data {
	int _ref_count_;
	IconTasklistApplet* self;
	PinnedIconButton* button;
};


static gpointer icon_tasklist_parent_class = NULL;
static BudgiePluginIface* icon_tasklist_budgie_plugin_parent_iface = NULL;
static GType icon_tasklist_type_id = 0;
static gpointer desktop_helper_parent_class = NULL;
static GType desktop_helper_type_id = 0;
static gpointer icon_tasklist_applet_parent_class = NULL;
static GType icon_tasklist_applet_type_id = 0;

GType icon_tasklist_get_type (void) G_GNUC_CONST;
GType icon_tasklist_register_type (GTypeModule * module);
enum  {
	ICON_TASKLIST_DUMMY_PROPERTY
};
static BudgieApplet* icon_tasklist_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
IconTasklistApplet* icon_tasklist_applet_new (const gchar* uuid);
IconTasklistApplet* icon_tasklist_applet_construct (GType object_type, const gchar* uuid);
GType icon_tasklist_applet_get_type (void) G_GNUC_CONST;
GType icon_tasklist_applet_register_type (GTypeModule * module);
IconTasklist* icon_tasklist_new (void);
IconTasklist* icon_tasklist_construct (GType object_type);
GType desktop_helper_get_type (void) G_GNUC_CONST;
GType desktop_helper_register_type (GTypeModule * module);
enum  {
	DESKTOP_HELPER_DUMMY_PROPERTY
};
void desktop_helper_set_pinned (GSettings* settings, GDesktopAppInfo* app_info, gboolean pinned);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
DesktopHelper* desktop_helper_new (void);
DesktopHelper* desktop_helper_construct (GType object_type);
GType icon_button_get_type (void) G_GNUC_CONST;
GType icon_button_register_type (GTypeModule * module);
GType pinned_icon_button_get_type (void) G_GNUC_CONST;
GType pinned_icon_button_register_type (GTypeModule * module);
GType app_system_get_type (void) G_GNUC_CONST;
GType app_system_register_type (GTypeModule * module);
#define ICON_TASKLIST_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ICON_TASKLIST_APPLET, IconTasklistAppletPrivate))
enum  {
	ICON_TASKLIST_APPLET_DUMMY_PROPERTY,
	ICON_TASKLIST_APPLET_UUID
};
void icon_tasklist_applet_window_opened (IconTasklistApplet* self, WnckWindow* window);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GDesktopAppInfo* app_system_query_window (AppSystem* self, WnckWindow* window);
void icon_button_update_from_window (IconButton* self);
IconButton* icon_button_new (GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size);
IconButton* icon_button_construct (GType object_type, GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size);
GType button_wrapper_get_type (void) G_GNUC_CONST;
GType button_wrapper_register_type (GTypeModule * module);
ButtonWrapper* button_wrapper_new (IconButton* button);
ButtonWrapper* button_wrapper_construct (GType object_type, IconButton* button);
static gboolean __lambda15_ (Block1Data* _data1_);
void icon_button_icon_mapped (IconButton* self);
static gboolean ___lambda15__gsource_func (gpointer self);
void icon_tasklist_applet_window_closed (IconTasklistApplet* self, WnckWindow* window);
void pinned_icon_button_reset (PinnedIconButton* self);
void button_wrapper_gracefully_die (ButtonWrapper* self);
void icon_tasklist_applet_active_window_changed (IconTasklistApplet* self, WnckWindow* previous_window);
AppSystem* app_system_new (void);
AppSystem* app_system_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
void icon_tasklist_applet_on_settings_change (IconTasklistApplet* self, const gchar* key);
static void _icon_tasklist_applet_on_settings_change_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _icon_tasklist_applet_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void _icon_tasklist_applet_window_closed_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void _icon_tasklist_applet_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self);
static void icon_tasklist_applet_on_panel_size_changed (IconTasklistApplet* self, gint panel, gint icon, gint small_icon);
static void _icon_tasklist_applet_on_panel_size_changed_budgie_applet_panel_size_changed (BudgieApplet* _sender, gint panel_size, gint icon_size, gint small_icon_size, gpointer self);
static void icon_tasklist_applet_on_drag_data_received (IconTasklistApplet* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint item, guint time);
static void _icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void icon_tasklist_applet_set_icons_size (IconTasklistApplet* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block2Data* _data2_);
void icon_button_update_icon (IconButton* self);
static gboolean ___lambda17__gsource_func (gpointer self);
static void icon_tasklist_applet_move_launcher (IconTasklistApplet* self, const gchar* app_id, gint position);
static void _g_list_free__g_free0_ (GList* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
PinnedIconButton* pinned_icon_button_new (GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size);
PinnedIconButton* pinned_icon_button_construct (GType object_type, GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size);
static gboolean ____lambda16_ (Block3Data* _data3_);
static gboolean _____lambda16__gsource_func (gpointer self);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
const gchar* icon_tasklist_applet_get_uuid (IconTasklistApplet* self);
void icon_tasklist_applet_set_uuid (IconTasklistApplet* self, const gchar* value);
static void icon_tasklist_applet_finalize (GObject* obj);
static void _vala_icon_tasklist_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_icon_tasklist_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void peas_register_types (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GtkTargetEntry DESKTOP_HELPER_targets[1] = {{"application/x-icon-tasklist-launcher-id", (guint) 0, (guint) 0}};

static BudgieApplet* icon_tasklist_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	IconTasklist * self;
	BudgieApplet* result = NULL;
	const gchar* _tmp0_ = NULL;
	IconTasklistApplet* _tmp1_ = NULL;
	self = (IconTasklist*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	_tmp1_ = icon_tasklist_applet_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (BudgieApplet*) _tmp1_;
	return result;
}


IconTasklist* icon_tasklist_construct (GType object_type) {
	IconTasklist * self = NULL;
	self = (IconTasklist*) g_object_new (object_type, NULL);
	return self;
}


IconTasklist* icon_tasklist_new (void) {
	return icon_tasklist_construct (TYPE_ICON_TASKLIST);
}


static void icon_tasklist_class_init (IconTasklistClass * klass) {
	icon_tasklist_parent_class = g_type_class_peek_parent (klass);
}


static void icon_tasklist_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	icon_tasklist_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) icon_tasklist_real_get_panel_widget;
}


static void icon_tasklist_instance_init (IconTasklist * self) {
}


GType icon_tasklist_get_type (void) {
	return icon_tasklist_type_id;
}


GType icon_tasklist_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklist), 0, (GInstanceInitFunc) icon_tasklist_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) icon_tasklist_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	icon_tasklist_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "IconTasklist", &g_define_type_info, 0);
	g_type_module_add_interface (module, icon_tasklist_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return icon_tasklist_type_id;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void desktop_helper_set_pinned (GSettings* settings, GDesktopAppInfo* app_info, gboolean pinned) {
	gchar** launchers = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint launchers_length1 = 0;
	gint _launchers_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** new_launchers = NULL;
	gchar** _tmp13_ = NULL;
	gint new_launchers_length1 = 0;
	gint _new_launchers_size_ = 0;
	gboolean did_remove = FALSE;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "pinned-launchers");
	launchers = _tmp2_;
	launchers_length1 = _vala_array_length (_tmp1_);
	_launchers_size_ = launchers_length1;
	_tmp3_ = pinned;
	if (_tmp3_) {
		GDesktopAppInfo* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		GDesktopAppInfo* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GSettings* _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		_tmp4_ = app_info;
		_tmp5_ = g_app_info_get_id ((GAppInfo*) _tmp4_);
		_tmp6_ = launchers;
		_tmp6__length1 = launchers_length1;
		if (_vala_string_array_contains (_tmp6_, _tmp6__length1, _tmp5_)) {
			launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		_tmp7_ = launchers;
		_tmp7__length1 = launchers_length1;
		_tmp8_ = app_info;
		_tmp9_ = g_app_info_get_id ((GAppInfo*) _tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_vala_array_add1 (&launchers, &launchers_length1, &_launchers_size_, _tmp10_);
		_tmp11_ = settings;
		_tmp12_ = launchers;
		_tmp12__length1 = launchers_length1;
		g_settings_set_strv (_tmp11_, "pinned-launchers", _tmp12_);
		launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp13_ = g_new0 (gchar*, 0 + 1);
	new_launchers = _tmp13_;
	new_launchers_length1 = 0;
	_new_launchers_size_ = new_launchers_length1;
	did_remove = FALSE;
	_tmp14_ = launchers;
	_tmp14__length1 = launchers_length1;
	{
		gchar** launcher_collection = NULL;
		gint launcher_collection_length1 = 0;
		gint _launcher_collection_size_ = 0;
		gint launcher_it = 0;
		launcher_collection = _tmp14_;
		launcher_collection_length1 = _tmp14__length1;
		for (launcher_it = 0; launcher_it < _tmp14__length1; launcher_it = launcher_it + 1) {
			gchar* _tmp15_ = NULL;
			gchar* launcher = NULL;
			_tmp15_ = g_strdup (launcher_collection[launcher_it]);
			launcher = _tmp15_;
			{
				const gchar* _tmp16_ = NULL;
				GDesktopAppInfo* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				_tmp16_ = launcher;
				_tmp17_ = app_info;
				_tmp18_ = g_app_info_get_id ((GAppInfo*) _tmp17_);
				if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
					gchar** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp19_ = new_launchers;
					_tmp19__length1 = new_launchers_length1;
					_tmp20_ = launcher;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add2 (&new_launchers, &new_launchers_length1, &_new_launchers_size_, _tmp21_);
				} else {
					did_remove = TRUE;
				}
				_g_free0 (launcher);
			}
		}
	}
	_tmp22_ = did_remove;
	if (_tmp22_) {
		GSettings* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		_tmp23_ = settings;
		_tmp24_ = new_launchers;
		_tmp24__length1 = new_launchers_length1;
		g_settings_set_strv (_tmp23_, "pinned-launchers", _tmp24_);
	}
	new_launchers = (_vala_array_free (new_launchers, new_launchers_length1, (GDestroyNotify) g_free), NULL);
	launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
}


DesktopHelper* desktop_helper_construct (GType object_type) {
	DesktopHelper * self = NULL;
	self = (DesktopHelper*) g_object_new (object_type, NULL);
	return self;
}


DesktopHelper* desktop_helper_new (void) {
	return desktop_helper_construct (TYPE_DESKTOP_HELPER);
}


static void desktop_helper_class_init (DesktopHelperClass * klass) {
	desktop_helper_parent_class = g_type_class_peek_parent (klass);
}


static void desktop_helper_instance_init (DesktopHelper * self) {
}


/**
 * Trivial helper for IconTasklist - i.e. desktop lookups
 */
GType desktop_helper_get_type (void) {
	return desktop_helper_type_id;
}


GType desktop_helper_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (DesktopHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopHelper), 0, (GInstanceInitFunc) desktop_helper_instance_init, NULL };
	desktop_helper_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "DesktopHelper", &g_define_type_info, 0);
	return desktop_helper_type_id;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		IconTasklistApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->button);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda15_ (Block1Data* _data1_) {
	IconTasklistApplet* self;
	gboolean result = FALSE;
	IconButton* _tmp0_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->button;
	icon_button_icon_mapped (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
	return result;
}


void icon_tasklist_applet_window_opened (IconTasklistApplet* self, WnckWindow* window) {
	Block1Data* _data1_;
	WnckWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* launch_id = NULL;
	WnckWindow* _tmp2_ = NULL;
	WnckApplication* _tmp3_ = NULL;
	GDesktopAppInfo* pinfo = NULL;
	AppSystem* _tmp8_ = NULL;
	WnckWindow* _tmp9_ = NULL;
	GDesktopAppInfo* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GDesktopAppInfo* _tmp31_ = NULL;
	IconButton* _tmp46_ = NULL;
	GHashTable* _tmp60_ = NULL;
	WnckWindow* _tmp61_ = NULL;
	WnckWindow* _tmp62_ = NULL;
	IconButton* _tmp63_ = NULL;
	IconButton* _tmp64_ = NULL;
	IconButton* _tmp65_ = NULL;
	GtkContainer* _tmp66_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = window;
	_tmp1_ = wnck_window_is_skip_tasklist (_tmp0_);
	if (_tmp1_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	launch_id = NULL;
	_data1_->button = NULL;
	_tmp2_ = window;
	_tmp3_ = wnck_window_get_application (_tmp2_);
	if (_tmp3_ != NULL) {
		WnckWindow* _tmp4_ = NULL;
		WnckApplication* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = window;
		_tmp5_ = wnck_window_get_application (_tmp4_);
		_tmp6_ = wnck_application_get_startup_id (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (launch_id);
		launch_id = _tmp7_;
	}
	_tmp8_ = self->helper;
	_tmp9_ = window;
	_tmp10_ = app_system_query_window (_tmp8_, _tmp9_);
	pinfo = _tmp10_;
	_tmp11_ = launch_id;
	if (_tmp11_ != NULL) {
		PinnedIconButton* btn = NULL;
		PinnedIconButton* pbtn = NULL;
		GHashTableIter iter = {0};
		GHashTable* _tmp12_ = NULL;
		PinnedIconButton* _tmp24_ = NULL;
		btn = NULL;
		pbtn = NULL;
		_tmp12_ = self->pin_buttons;
		g_hash_table_iter_init (&iter, _tmp12_);
		while (TRUE) {
			gconstpointer _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			PinnedIconButton* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			PinnedIconButton* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			_tmp14_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp13_));
			_g_object_unref0 (pbtn);
			_tmp15_ = _g_object_ref0 (_tmp13_);
			pbtn = _tmp15_;
			if (!_tmp14_) {
				break;
			}
			_tmp17_ = pbtn;
			_tmp18_ = _tmp17_->id;
			if (_tmp18_ != NULL) {
				PinnedIconButton* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				_tmp19_ = pbtn;
				_tmp20_ = _tmp19_->id;
				_tmp21_ = launch_id;
				_tmp16_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				PinnedIconButton* _tmp22_ = NULL;
				PinnedIconButton* _tmp23_ = NULL;
				_tmp22_ = pbtn;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (btn);
				btn = _tmp23_;
				break;
			}
		}
		_tmp24_ = btn;
		if (_tmp24_ != NULL) {
			PinnedIconButton* _tmp25_ = NULL;
			WnckWindow* _tmp26_ = NULL;
			PinnedIconButton* _tmp27_ = NULL;
			PinnedIconButton* _tmp28_ = NULL;
			PinnedIconButton* _tmp29_ = NULL;
			IconButton* _tmp30_ = NULL;
			_tmp25_ = btn;
			_tmp26_ = window;
			((IconButton*) _tmp25_)->window = _tmp26_;
			_tmp27_ = btn;
			icon_button_update_from_window ((IconButton*) _tmp27_);
			_tmp28_ = btn;
			_g_free0 (_tmp28_->id);
			_tmp28_->id = NULL;
			_tmp29_ = btn;
			_tmp30_ = _g_object_ref0 ((IconButton*) _tmp29_);
			_g_object_unref0 (_data1_->button);
			_data1_->button = _tmp30_;
		}
		_g_object_unref0 (pbtn);
		_g_object_unref0 (btn);
	}
	_tmp31_ = pinfo;
	if (_tmp31_ != NULL) {
		PinnedIconButton* pinfo2 = NULL;
		GHashTable* _tmp32_ = NULL;
		GDesktopAppInfo* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gconstpointer _tmp35_ = NULL;
		PinnedIconButton* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		PinnedIconButton* _tmp38_ = NULL;
		_tmp32_ = self->pin_buttons;
		_tmp33_ = pinfo;
		_tmp34_ = g_app_info_get_id ((GAppInfo*) _tmp33_);
		_tmp35_ = g_hash_table_lookup (_tmp32_, _tmp34_);
		_tmp36_ = _g_object_ref0 ((PinnedIconButton*) _tmp35_);
		pinfo2 = _tmp36_;
		_tmp38_ = pinfo2;
		if (_tmp38_ != NULL) {
			PinnedIconButton* _tmp39_ = NULL;
			WnckWindow* _tmp40_ = NULL;
			_tmp39_ = pinfo2;
			_tmp40_ = ((IconButton*) _tmp39_)->window;
			_tmp37_ = _tmp40_ == NULL;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			PinnedIconButton* _tmp41_ = NULL;
			WnckWindow* _tmp42_ = NULL;
			PinnedIconButton* _tmp43_ = NULL;
			PinnedIconButton* _tmp44_ = NULL;
			IconButton* _tmp45_ = NULL;
			_tmp41_ = pinfo2;
			_tmp42_ = window;
			((IconButton*) _tmp41_)->window = _tmp42_;
			_tmp43_ = pinfo2;
			icon_button_update_from_window ((IconButton*) _tmp43_);
			_tmp44_ = pinfo2;
			_tmp45_ = _g_object_ref0 ((IconButton*) _tmp44_);
			_g_object_unref0 (_data1_->button);
			_data1_->button = _tmp45_;
		}
		_g_object_unref0 (pinfo2);
	}
	_tmp46_ = _data1_->button;
	if (_tmp46_ == NULL) {
		IconButton* btn = NULL;
		GSettings* _tmp47_ = NULL;
		WnckWindow* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GDesktopAppInfo* _tmp50_ = NULL;
		AppSystem* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		IconButton* _tmp53_ = NULL;
		ButtonWrapper* button_wrap = NULL;
		IconButton* _tmp54_ = NULL;
		ButtonWrapper* _tmp55_ = NULL;
		IconButton* _tmp56_ = NULL;
		IconButton* _tmp57_ = NULL;
		GtkBox* _tmp58_ = NULL;
		ButtonWrapper* _tmp59_ = NULL;
		_tmp47_ = self->priv->settings;
		_tmp48_ = window;
		_tmp49_ = self->icon_size;
		_tmp50_ = pinfo;
		_tmp51_ = self->helper;
		_tmp52_ = self->priv->panel_size;
		_tmp53_ = icon_button_new (_tmp47_, _tmp48_, _tmp49_, _tmp50_, _tmp51_, _tmp52_);
		g_object_ref_sink (_tmp53_);
		btn = _tmp53_;
		_tmp54_ = btn;
		_tmp55_ = button_wrapper_new (_tmp54_);
		g_object_ref_sink (_tmp55_);
		button_wrap = _tmp55_;
		_tmp56_ = btn;
		_tmp57_ = _g_object_ref0 (_tmp56_);
		_g_object_unref0 (_data1_->button);
		_data1_->button = _tmp57_;
		_tmp58_ = self->widget;
		_tmp59_ = button_wrap;
		gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (button_wrap);
		_g_object_unref0 (btn);
	}
	_tmp60_ = self->buttons;
	_tmp61_ = window;
	_tmp62_ = _g_object_ref0 (_tmp61_);
	_tmp63_ = _data1_->button;
	_tmp64_ = _g_object_ref0 (_tmp63_);
	g_hash_table_insert (_tmp60_, _tmp62_, _tmp64_);
	_tmp65_ = _data1_->button;
	_tmp66_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp65_);
	gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _tmp66_) : NULL, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_g_object_unref0 (pinfo);
	_g_free0 (launch_id);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


void icon_tasklist_applet_window_closed (IconTasklistApplet* self, WnckWindow* window) {
	IconButton* btn = NULL;
	GHashTable* _tmp0_ = NULL;
	WnckWindow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GHashTable* _tmp3_ = NULL;
	WnckWindow* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	IconButton* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	IconButton* _tmp8_ = NULL;
	GHashTable* _tmp17_ = NULL;
	WnckWindow* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	btn = NULL;
	_tmp0_ = self->buttons;
	_tmp1_ = window;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		_g_object_unref0 (btn);
		return;
	}
	_tmp3_ = self->buttons;
	_tmp4_ = window;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((IconButton*) _tmp5_);
	_g_object_unref0 (btn);
	btn = _tmp6_;
	_tmp8_ = btn;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_PINNED_ICON_BUTTON)) {
		IconButton* _tmp9_ = NULL;
		GtkContainer* _tmp10_ = NULL;
		GtkBox* _tmp11_ = NULL;
		_tmp9_ = btn;
		_tmp10_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp9_);
		_tmp11_ = self->widget;
		_tmp7_ = _tmp10_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		PinnedIconButton* pbtn = NULL;
		IconButton* _tmp12_ = NULL;
		PinnedIconButton* _tmp13_ = NULL;
		PinnedIconButton* _tmp14_ = NULL;
		_tmp12_ = btn;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_PINNED_ICON_BUTTON) ? ((PinnedIconButton*) _tmp12_) : NULL);
		pbtn = _tmp13_;
		_tmp14_ = pbtn;
		pinned_icon_button_reset (_tmp14_);
		_g_object_unref0 (pbtn);
	} else {
		IconButton* _tmp15_ = NULL;
		GtkContainer* _tmp16_ = NULL;
		_tmp15_ = btn;
		_tmp16_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp15_);
		button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_BUTTON_WRAPPER) ? ((ButtonWrapper*) _tmp16_) : NULL);
	}
	_tmp17_ = self->buttons;
	_tmp18_ = window;
	g_hash_table_remove (_tmp17_, _tmp18_);
	_g_object_unref0 (btn);
}


/**
     * Just update the active state on the buttons
     */
void icon_tasklist_applet_active_window_changed (IconTasklistApplet* self, WnckWindow* previous_window) {
	IconButton* btn = NULL;
	WnckWindow* new_active = NULL;
	WnckWindow* _tmp0_ = NULL;
	WnckScreen* _tmp9_ = NULL;
	WnckWindow* _tmp10_ = NULL;
	WnckWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	WnckWindow* _tmp13_ = NULL;
	GHashTable* _tmp17_ = NULL;
	WnckWindow* _tmp18_ = NULL;
	gconstpointer _tmp19_ = NULL;
	IconButton* _tmp20_ = NULL;
	IconButton* _tmp21_ = NULL;
	IconButton* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	IconButton* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = previous_window;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_ = NULL;
		WnckWindow* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->buttons;
		_tmp2_ = previous_window;
		_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
		if (_tmp3_) {
			GHashTable* _tmp4_ = NULL;
			WnckWindow* _tmp5_ = NULL;
			gconstpointer _tmp6_ = NULL;
			IconButton* _tmp7_ = NULL;
			IconButton* _tmp8_ = NULL;
			_tmp4_ = self->buttons;
			_tmp5_ = previous_window;
			_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
			_tmp7_ = _g_object_ref0 ((IconButton*) _tmp6_);
			_g_object_unref0 (btn);
			btn = _tmp7_;
			_tmp8_ = btn;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, FALSE);
		}
	}
	_tmp9_ = self->screen;
	_tmp10_ = wnck_screen_get_active_window (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (new_active);
	new_active = _tmp11_;
	_tmp13_ = new_active;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		GHashTable* _tmp14_ = NULL;
		WnckWindow* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp14_ = self->buttons;
		_tmp15_ = new_active;
		_tmp16_ = g_hash_table_contains (_tmp14_, _tmp15_);
		_tmp12_ = !_tmp16_;
	}
	if (_tmp12_) {
		self->priv->active_button = NULL;
		gtk_widget_queue_draw ((GtkWidget*) self);
		_g_object_unref0 (new_active);
		_g_object_unref0 (btn);
		return;
	}
	_tmp17_ = self->buttons;
	_tmp18_ = new_active;
	_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
	_tmp20_ = _g_object_ref0 ((IconButton*) _tmp19_);
	_g_object_unref0 (btn);
	btn = _tmp20_;
	_tmp21_ = btn;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp21_, TRUE);
	_tmp22_ = btn;
	_tmp23_ = gtk_widget_get_realized ((GtkWidget*) _tmp22_);
	if (!_tmp23_) {
		IconButton* _tmp24_ = NULL;
		IconButton* _tmp25_ = NULL;
		_tmp24_ = btn;
		gtk_widget_realize ((GtkWidget*) _tmp24_);
		_tmp25_ = btn;
		gtk_widget_queue_resize ((GtkWidget*) _tmp25_);
	}
	_tmp26_ = btn;
	self->priv->active_button = _tmp26_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (new_active);
	_g_object_unref0 (btn);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _icon_tasklist_applet_on_settings_change_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	icon_tasklist_applet_on_settings_change ((IconTasklistApplet*) self, key);
}


static void _icon_tasklist_applet_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	icon_tasklist_applet_window_opened ((IconTasklistApplet*) self, window);
}


static void _icon_tasklist_applet_window_closed_wnck_screen_window_closed (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	icon_tasklist_applet_window_closed ((IconTasklistApplet*) self, window);
}


static void _icon_tasklist_applet_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self) {
	icon_tasklist_applet_active_window_changed ((IconTasklistApplet*) self, previous_window);
}


static void _icon_tasklist_applet_on_panel_size_changed_budgie_applet_panel_size_changed (BudgieApplet* _sender, gint panel_size, gint icon_size, gint small_icon_size, gpointer self) {
	icon_tasklist_applet_on_panel_size_changed ((IconTasklistApplet*) self, panel_size, icon_size, small_icon_size);
}


static void _icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	icon_tasklist_applet_on_drag_data_received ((IconTasklistApplet*) self, _sender, context, x, y, selection_data, info, time_);
}


IconTasklistApplet* icon_tasklist_applet_construct (GType object_type, const gchar* uuid) {
	IconTasklistApplet * self = NULL;
	const gchar* _tmp0_ = NULL;
	AppSystem* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashFunc _tmp5_ = NULL;
	GEqualFunc _tmp6_ = NULL;
	GHashTable* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkBox* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	GSettings* _tmp23_ = NULL;
	WnckScreen* _tmp24_ = NULL;
	WnckScreen* _tmp25_ = NULL;
	WnckScreen* _tmp26_ = NULL;
	WnckScreen* _tmp27_ = NULL;
	WnckScreen* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkBox* _tmp30_ = NULL;
	GtkStyleContext* _tmp31_ = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	self = (IconTasklistApplet*) g_object_new (object_type, "uuid", _tmp0_, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.icon-tasklist");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/icon-tasklist");
	_tmp1_ = app_system_new ();
	_g_object_unref0 (self->helper);
	self->helper = _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->buttons);
	self->buttons = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->pin_buttons);
	self->pin_buttons = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->main_layout);
	self->main_layout = _tmp8_;
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 4);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->pinned);
	self->pinned = _tmp9_;
	_tmp10_ = self->pinned;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 14);
	_tmp11_ = self->pinned;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_add_class (_tmp12_, "pinned");
	_tmp13_ = self->main_layout;
	_tmp14_ = self->pinned;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 4);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp15_;
	_tmp16_ = self->widget;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "unpinned");
	_tmp18_ = self->main_layout;
	_tmp19_ = self->widget;
	gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, FALSE, FALSE, (guint) 0);
	_tmp20_ = self->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp20_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp21_ = uuid;
	_tmp22_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp21_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp22_;
	_tmp23_ = self->priv->settings;
	g_signal_connect_object (_tmp23_, "changed", (GCallback) _icon_tasklist_applet_on_settings_change_g_settings_changed, self, 0);
	icon_tasklist_applet_on_settings_change (self, "pinned-launchers");
	_tmp24_ = wnck_screen_get_default ();
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->screen);
	self->screen = _tmp25_;
	_tmp26_ = self->screen;
	g_signal_connect_object (_tmp26_, "window-opened", (GCallback) _icon_tasklist_applet_window_opened_wnck_screen_window_opened, self, 0);
	_tmp27_ = self->screen;
	g_signal_connect_object (_tmp27_, "window-closed", (GCallback) _icon_tasklist_applet_window_closed_wnck_screen_window_closed, self, 0);
	_tmp28_ = self->screen;
	g_signal_connect_object (_tmp28_, "active-window-changed", (GCallback) _icon_tasklist_applet_active_window_changed_wnck_screen_active_window_changed, self, 0);
	g_signal_connect_object ((BudgieApplet*) self, "panel-size-changed", (GCallback) _icon_tasklist_applet_on_panel_size_changed_budgie_applet_panel_size_changed, self, 0);
	_tmp29_ = self->pinned;
	gtk_drag_dest_set ((GtkWidget*) _tmp29_, GTK_DEST_DEFAULT_ALL, DESKTOP_HELPER_targets, G_N_ELEMENTS (DESKTOP_HELPER_targets), GDK_ACTION_MOVE);
	_tmp30_ = self->pinned;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "drag-data-received", (GCallback) _icon_tasklist_applet_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp31_, "icon-tasklist");
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


IconTasklistApplet* icon_tasklist_applet_new (const gchar* uuid) {
	return icon_tasklist_applet_construct (TYPE_ICON_TASKLIST_APPLET, uuid);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		IconTasklistApplet* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda17_ (Block2Data* _data2_) {
	IconTasklistApplet* self;
	gboolean result = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	GHashTableIter iter2 = {0};
	GHashTable* _tmp6_ = NULL;
	self = _data2_->self;
	_tmp0_ = self->buttons;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		_data2_->btn_key = _tmp1_;
		_data2_->val = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = self->icon_size;
		_data2_->val->icon_size = _tmp4_;
		_tmp5_ = self->priv->panel_size;
		_data2_->val->panel_size = _tmp5_;
		icon_button_update_icon (_data2_->val);
	}
	_tmp6_ = self->pin_buttons;
	g_hash_table_iter_init (&iter2, _tmp6_);
	while (TRUE) {
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp9_ = g_hash_table_iter_next (&iter2, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
		_data2_->str_key = _tmp7_;
		_data2_->pin_val = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = self->icon_size;
		((IconButton*) _data2_->pin_val)->icon_size = _tmp10_;
		_tmp11_ = self->priv->panel_size;
		((IconButton*) _data2_->pin_val)->panel_size = _tmp11_;
		icon_button_update_icon ((IconButton*) _data2_->pin_val);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda17_ (self);
	return result;
}


static void icon_tasklist_applet_set_icons_size (IconTasklistApplet* self) {
	Block2Data* _data2_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->btn_key = NULL;
	_data2_->str_key = NULL;
	_data2_->val = NULL;
	_data2_->pin_val = NULL;
	_tmp0_ = self->priv->small_icons;
	self->icon_size = _tmp0_;
	_tmp1_ = self->icon_size;
	wnck_set_default_icon_size ((gsize) _tmp1_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void icon_tasklist_applet_on_panel_size_changed (IconTasklistApplet* self, gint panel, gint icon, gint small_icon) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = small_icon;
	self->priv->small_icons = _tmp0_;
	_tmp1_ = panel;
	self->priv->panel_size = _tmp1_;
	icon_tasklist_applet_set_icons_size (self);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void icon_tasklist_applet_move_launcher (IconTasklistApplet* self, const gchar* app_id, gint position) {
	gchar** launchers = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint launchers_length1 = 0;
	gint _launchers_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GList* temp_launchers = NULL;
	gint old_index = 0;
	gint new_position = 0;
	gint _tmp7_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	GSettings* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_id != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "pinned-launchers");
	launchers = _tmp2_;
	launchers_length1 = _vala_array_length (_tmp1_);
	_launchers_size_ = launchers_length1;
	_tmp4_ = position;
	_tmp5_ = launchers;
	_tmp5__length1 = launchers_length1;
	if (_tmp4_ > _tmp5__length1) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp6_ = 0;
		_tmp6_ = position;
		_tmp3_ = _tmp6_ < 0;
	}
	if (_tmp3_) {
		launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	temp_launchers = NULL;
	old_index = 0;
	_tmp7_ = position;
	new_position = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = launchers;
				_tmp11__length1 = launchers_length1;
				if (!(_tmp10_ < _tmp11__length1)) {
					break;
				}
				_tmp12_ = launchers;
				_tmp12__length1 = launchers_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = app_id;
				if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp16_ = launchers;
					_tmp16__length1 = launchers_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_];
					_tmp19_ = g_strdup (_tmp18_);
					temp_launchers = g_list_append (temp_launchers, _tmp19_);
				} else {
					gint _tmp20_ = 0;
					_tmp20_ = i;
					old_index = _tmp20_;
				}
			}
		}
	}
	_tmp21_ = new_position;
	_tmp22_ = old_index;
	if (_tmp21_ > _tmp22_) {
		gint _tmp23_ = 0;
		_tmp23_ = new_position;
		new_position = _tmp23_ - 1;
	}
	_tmp24_ = app_id;
	_tmp25_ = g_strdup (_tmp24_);
	_tmp26_ = new_position;
	temp_launchers = g_list_insert (temp_launchers, _tmp25_, _tmp26_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp29_ = 0;
				gchar** _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				GList* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gconstpointer _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = i;
				_tmp30_ = launchers;
				_tmp30__length1 = launchers_length1;
				if (!(_tmp29_ < _tmp30__length1)) {
					break;
				}
				_tmp31_ = launchers;
				_tmp31__length1 = launchers_length1;
				_tmp32_ = i;
				_tmp33_ = temp_launchers;
				_tmp34_ = i;
				_tmp35_ = g_list_nth_data (_tmp33_, (guint) _tmp34_);
				_tmp36_ = g_strdup ((const gchar*) _tmp35_);
				_g_free0 (_tmp31_[_tmp32_]);
				_tmp31_[_tmp32_] = _tmp36_;
				_tmp37_ = _tmp31_[_tmp32_];
			}
		}
	}
	_tmp38_ = self->priv->settings;
	_tmp39_ = launchers;
	_tmp39__length1 = launchers_length1;
	g_settings_set_strv (_tmp38_, "pinned-launchers", _tmp39_);
	__g_list_free__g_free0_0 (temp_launchers);
	launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
}


static void icon_tasklist_applet_on_drag_data_received (IconTasklistApplet* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint item, guint time) {
	gchar** launchers = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint launchers_length1 = 0;
	gint _launchers_size_ = 0;
	GtkAllocation main_layout_allocation = {0};
	GtkBox* _tmp3_ = NULL;
	GtkAllocation _tmp4_ = {0};
	guint _tmp5_ = 0U;
	gchar* app_id = NULL;
	GtkSelectionData* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GdkDragContext* _tmp47_ = NULL;
	guint _tmp48_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "pinned-launchers");
	launchers = _tmp2_;
	launchers_length1 = _vala_array_length (_tmp1_);
	_launchers_size_ = launchers_length1;
	_tmp3_ = self->main_layout;
	gtk_widget_get_allocation ((GtkWidget*) _tmp3_, &_tmp4_);
	main_layout_allocation = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != ((guint) 0)) {
		g_message ("IconTasklistApplet.vala:321: Invalid target type");
		launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp6_ = selection_data;
	_tmp7_ = gtk_selection_data_get_data (_tmp6_);
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	app_id = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				GtkAllocation alloc = {0};
				GHashTable* _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp15_ = 0;
				const gchar* _tmp16_ = NULL;
				gconstpointer _tmp17_ = NULL;
				GtkContainer* _tmp18_ = NULL;
				GtkAllocation _tmp19_ = {0};
				gint _tmp20_ = 0;
				GtkAllocation _tmp21_ = {0};
				gint _tmp22_ = 0;
				GtkAllocation _tmp23_ = {0};
				gint _tmp24_ = 0;
				GtkAllocation _tmp25_ = {0};
				gint _tmp26_ = 0;
				gint _tmp39_ = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = launchers;
				_tmp12__length1 = launchers_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = self->pin_buttons;
				_tmp14_ = launchers;
				_tmp14__length1 = launchers_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = g_hash_table_lookup (_tmp13_, _tmp16_);
				_tmp18_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) ((PinnedIconButton*) _tmp17_));
				gtk_widget_get_allocation ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_BUTTON_WRAPPER) ? ((ButtonWrapper*) _tmp18_) : NULL), &_tmp19_);
				alloc = _tmp19_;
				_tmp20_ = x;
				_tmp21_ = alloc;
				_tmp22_ = _tmp21_.x;
				_tmp23_ = alloc;
				_tmp24_ = _tmp23_.width;
				_tmp25_ = main_layout_allocation;
				_tmp26_ = _tmp25_.x;
				if (_tmp20_ <= ((_tmp22_ + (_tmp24_ / 2)) - _tmp26_)) {
					gchar** _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
					gint _tmp28_ = 0;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
					gint _tmp32_ = 0;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					_tmp27_ = launchers;
					_tmp27__length1 = launchers_length1;
					_tmp28_ = i;
					_tmp29_ = _tmp27_[_tmp28_];
					_tmp30_ = app_id;
					if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
						break;
					}
					_tmp32_ = i;
					if (_tmp32_ > 0) {
						gchar** _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						gint _tmp34_ = 0;
						const gchar* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						_tmp33_ = launchers;
						_tmp33__length1 = launchers_length1;
						_tmp34_ = i;
						_tmp35_ = _tmp33_[_tmp34_ - 1];
						_tmp36_ = app_id;
						_tmp31_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						break;
					}
					_tmp37_ = app_id;
					_tmp38_ = i;
					icon_tasklist_applet_move_launcher (self, _tmp37_, _tmp38_);
					break;
				}
				_tmp39_ = i;
				_tmp40_ = launchers;
				_tmp40__length1 = launchers_length1;
				if (_tmp39_ == (_tmp40__length1 - 1)) {
					gchar** _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					gint _tmp42_ = 0;
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gchar** _tmp46_ = NULL;
					gint _tmp46__length1 = 0;
					_tmp41_ = launchers;
					_tmp41__length1 = launchers_length1;
					_tmp42_ = i;
					_tmp43_ = _tmp41_[_tmp42_];
					_tmp44_ = app_id;
					if (g_strcmp0 (_tmp43_, _tmp44_) == 0) {
						break;
					}
					_tmp45_ = app_id;
					_tmp46_ = launchers;
					_tmp46__length1 = launchers_length1;
					icon_tasklist_applet_move_launcher (self, _tmp45_, _tmp46__length1);
				}
			}
		}
	}
	_tmp47_ = context;
	_tmp48_ = time;
	gtk_drag_finish (_tmp47_, TRUE, TRUE, (guint32) _tmp48_);
	_g_free0 (app_id);
	launchers = (_vala_array_free (launchers, launchers_length1, (GDestroyNotify) g_free), NULL);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		IconTasklistApplet* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->button);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean ____lambda16_ (Block3Data* _data3_) {
	IconTasklistApplet* self;
	gboolean result = FALSE;
	PinnedIconButton* _tmp0_ = NULL;
	self = _data3_->self;
	_tmp0_ = _data3_->button;
	icon_button_icon_mapped ((IconButton*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean _____lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda16_ (self);
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void icon_tasklist_applet_on_settings_change (IconTasklistApplet* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	gchar** files = NULL;
	GSettings* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** removals = NULL;
	gchar** _tmp63_ = NULL;
	gint removals_length1 = 0;
	gint _removals_size_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp64_ = NULL;
	gchar* key_name = NULL;
	PinnedIconButton* btn = NULL;
	gchar** _tmp103_ = NULL;
	gint _tmp103__length1 = 0;
	gint j = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "pinned-launchers") != 0) {
		return;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = key;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp1_, _tmp2_);
	files = _tmp4_;
	files_length1 = _vala_array_length (_tmp3_);
	_files_size_ = files_length1;
	_tmp5_ = self->priv->settings;
	_tmp6_ = key;
	_tmp8_ = _tmp7_ = g_settings_get_strv (_tmp5_, _tmp6_);
	{
		gchar** desktopfile_collection = NULL;
		gint desktopfile_collection_length1 = 0;
		gint _desktopfile_collection_size_ = 0;
		gint desktopfile_it = 0;
		desktopfile_collection = _tmp8_;
		desktopfile_collection_length1 = _vala_array_length (_tmp7_);
		for (desktopfile_it = 0; desktopfile_it < _vala_array_length (_tmp7_); desktopfile_it = desktopfile_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* desktopfile = NULL;
			_tmp9_ = g_strdup (desktopfile_collection[desktopfile_it]);
			desktopfile = _tmp9_;
			{
				Block3Data* _data3_;
				GHashTable* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				GDesktopAppInfo* info = NULL;
				const gchar* _tmp13_ = NULL;
				GDesktopAppInfo* _tmp14_ = NULL;
				GDesktopAppInfo* _tmp15_ = NULL;
				GSettings* _tmp17_ = NULL;
				GDesktopAppInfo* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				AppSystem* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				PinnedIconButton* _tmp22_ = NULL;
				ButtonWrapper* button_wrap = NULL;
				PinnedIconButton* _tmp23_ = NULL;
				ButtonWrapper* _tmp24_ = NULL;
				GHashTable* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				PinnedIconButton* _tmp28_ = NULL;
				PinnedIconButton* _tmp29_ = NULL;
				GtkBox* _tmp30_ = NULL;
				ButtonWrapper* _tmp31_ = NULL;
				GHashTableIter iter = {0};
				GHashTable* _tmp32_ = NULL;
				WnckWindow* keyn = NULL;
				IconButton* btn = NULL;
				PinnedIconButton* _tmp61_ = NULL;
				GtkContainer* _tmp62_ = NULL;
				_data3_ = g_slice_new0 (Block3Data);
				_data3_->_ref_count_ = 1;
				_data3_->self = g_object_ref (self);
				_tmp10_ = self->pin_buttons;
				_tmp11_ = desktopfile;
				_tmp12_ = g_hash_table_contains (_tmp10_, _tmp11_);
				if (_tmp12_) {
					_g_free0 (desktopfile);
					block3_data_unref (_data3_);
					_data3_ = NULL;
					continue;
				}
				_tmp13_ = desktopfile;
				_tmp14_ = g_desktop_app_info_new (_tmp13_);
				info = _tmp14_;
				_tmp15_ = info;
				if (_tmp15_ == NULL) {
					const gchar* _tmp16_ = NULL;
					_tmp16_ = desktopfile;
					g_message ("IconTasklistApplet.vala:382: Invalid application! %s", _tmp16_);
					_g_object_unref0 (info);
					_g_free0 (desktopfile);
					block3_data_unref (_data3_);
					_data3_ = NULL;
					continue;
				}
				_tmp17_ = self->priv->settings;
				_tmp18_ = info;
				_tmp19_ = self->icon_size;
				_tmp20_ = self->helper;
				_tmp21_ = self->priv->panel_size;
				_tmp22_ = pinned_icon_button_new (_tmp17_, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
				g_object_ref_sink (_tmp22_);
				_data3_->button = _tmp22_;
				_tmp23_ = _data3_->button;
				_tmp24_ = button_wrapper_new ((IconButton*) _tmp23_);
				g_object_ref_sink (_tmp24_);
				button_wrap = _tmp24_;
				_tmp25_ = self->pin_buttons;
				_tmp26_ = desktopfile;
				_tmp27_ = g_strdup (_tmp26_);
				_tmp28_ = _data3_->button;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
				_tmp30_ = self->pinned;
				_tmp31_ = button_wrap;
				gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
				_tmp32_ = self->buttons;
				g_hash_table_iter_init (&iter, _tmp32_);
				while (TRUE) {
					gconstpointer _tmp33_ = NULL;
					gconstpointer _tmp34_ = NULL;
					gboolean _tmp35_ = FALSE;
					WnckWindow* _tmp36_ = NULL;
					IconButton* _tmp37_ = NULL;
					IconButton* _tmp38_ = NULL;
					GDesktopAppInfo* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					IconButton* _tmp41_ = NULL;
					GDesktopAppInfo* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					GDesktopAppInfo* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					_tmp35_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp33_), (gpointer*) (&_tmp34_));
					_g_object_unref0 (keyn);
					_tmp36_ = _g_object_ref0 (_tmp33_);
					keyn = _tmp36_;
					_g_object_unref0 (btn);
					_tmp37_ = _g_object_ref0 (_tmp34_);
					btn = _tmp37_;
					if (!_tmp35_) {
						break;
					}
					_tmp38_ = btn;
					_tmp39_ = _tmp38_->ainfo;
					if (_tmp39_ == NULL) {
						continue;
					}
					_tmp41_ = btn;
					_tmp42_ = _tmp41_->ainfo;
					_tmp43_ = g_app_info_get_id ((GAppInfo*) _tmp42_);
					_tmp44_ = info;
					_tmp45_ = g_app_info_get_id ((GAppInfo*) _tmp44_);
					if (g_strcmp0 (_tmp43_, _tmp45_) == 0) {
						IconButton* _tmp46_ = NULL;
						gboolean _tmp47_ = FALSE;
						_tmp46_ = btn;
						_tmp47_ = _tmp46_->requested_pin;
						_tmp40_ = _tmp47_;
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						PinnedIconButton* _tmp48_ = NULL;
						IconButton* _tmp49_ = NULL;
						WnckWindow* _tmp50_ = NULL;
						IconButton* _tmp51_ = NULL;
						GtkContainer* _tmp52_ = NULL;
						GHashTable* _tmp53_ = NULL;
						WnckWindow* _tmp54_ = NULL;
						GHashTable* _tmp55_ = NULL;
						WnckWindow* _tmp56_ = NULL;
						WnckWindow* _tmp57_ = NULL;
						PinnedIconButton* _tmp58_ = NULL;
						IconButton* _tmp59_ = NULL;
						PinnedIconButton* _tmp60_ = NULL;
						_tmp48_ = _data3_->button;
						_tmp49_ = btn;
						_tmp50_ = _tmp49_->window;
						((IconButton*) _tmp48_)->window = _tmp50_;
						_tmp51_ = btn;
						_tmp52_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp51_);
						button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, TYPE_BUTTON_WRAPPER) ? ((ButtonWrapper*) _tmp52_) : NULL);
						_tmp53_ = self->buttons;
						_tmp54_ = keyn;
						g_hash_table_remove (_tmp53_, _tmp54_);
						_tmp55_ = self->buttons;
						_tmp56_ = keyn;
						_tmp57_ = _g_object_ref0 (_tmp56_);
						_tmp58_ = _data3_->button;
						_tmp59_ = _g_object_ref0 ((IconButton*) _tmp58_);
						g_hash_table_insert (_tmp55_, _tmp57_, _tmp59_);
						_tmp60_ = _data3_->button;
						icon_button_update_from_window ((IconButton*) _tmp60_);
						break;
					}
				}
				_tmp61_ = _data3_->button;
				_tmp62_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp61_);
				gtk_revealer_set_reveal_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, gtk_revealer_get_type ()) ? ((GtkRevealer*) _tmp62_) : NULL, TRUE);
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda16__gsource_func, block3_data_ref (_data3_), block3_data_unref);
				_g_object_unref0 (btn);
				_g_object_unref0 (keyn);
				_g_object_unref0 (button_wrap);
				_g_object_unref0 (info);
				_g_free0 (desktopfile);
				block3_data_unref (_data3_);
				_data3_ = NULL;
			}
		}
		desktopfile_collection = (_vala_array_free (desktopfile_collection, desktopfile_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp63_ = g_new0 (gchar*, 0 + 1);
	removals = _tmp63_;
	removals_length1 = 0;
	_removals_size_ = removals_length1;
	_tmp64_ = self->pin_buttons;
	g_hash_table_iter_init (&iter, _tmp64_);
	while (TRUE) {
		gconstpointer _tmp65_ = NULL;
		gconstpointer _tmp66_ = NULL;
		gboolean _tmp67_ = FALSE;
		gchar* _tmp68_ = NULL;
		PinnedIconButton* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		gchar** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		PinnedIconButton* _tmp72_ = NULL;
		WnckWindow* _tmp73_ = NULL;
		gchar** _tmp100_ = NULL;
		gint _tmp100__length1 = 0;
		const gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		_tmp67_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp65_), (gpointer*) (&_tmp66_));
		_g_free0 (key_name);
		_tmp68_ = g_strdup (_tmp65_);
		key_name = _tmp68_;
		_g_object_unref0 (btn);
		_tmp69_ = _g_object_ref0 (_tmp66_);
		btn = _tmp69_;
		if (!_tmp67_) {
			break;
		}
		_tmp70_ = key_name;
		_tmp71_ = files;
		_tmp71__length1 = files_length1;
		if (_vala_string_array_contains (_tmp71_, _tmp71__length1, _tmp70_)) {
			continue;
		}
		_tmp72_ = btn;
		_tmp73_ = ((IconButton*) _tmp72_)->window;
		if (_tmp73_ == NULL) {
			PinnedIconButton* _tmp74_ = NULL;
			GtkContainer* _tmp75_ = NULL;
			_tmp74_ = btn;
			_tmp75_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp74_);
			button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, TYPE_BUTTON_WRAPPER) ? ((ButtonWrapper*) _tmp75_) : NULL);
		} else {
			IconButton* b2 = NULL;
			GSettings* _tmp76_ = NULL;
			PinnedIconButton* _tmp77_ = NULL;
			WnckWindow* _tmp78_ = NULL;
			gint _tmp79_ = 0;
			PinnedIconButton* _tmp80_ = NULL;
			GDesktopAppInfo* _tmp81_ = NULL;
			GDesktopAppInfo* _tmp82_ = NULL;
			AppSystem* _tmp83_ = NULL;
			gint _tmp84_ = 0;
			IconButton* _tmp85_ = NULL;
			IconButton* _tmp86_ = NULL;
			ButtonWrapper* button_wrap = NULL;
			IconButton* _tmp87_ = NULL;
			ButtonWrapper* _tmp88_ = NULL;
			PinnedIconButton* _tmp89_ = NULL;
			GtkContainer* _tmp90_ = NULL;
			GtkBox* _tmp91_ = NULL;
			ButtonWrapper* _tmp92_ = NULL;
			GHashTable* _tmp93_ = NULL;
			IconButton* _tmp94_ = NULL;
			WnckWindow* _tmp95_ = NULL;
			WnckWindow* _tmp96_ = NULL;
			IconButton* _tmp97_ = NULL;
			IconButton* _tmp98_ = NULL;
			ButtonWrapper* _tmp99_ = NULL;
			_tmp76_ = self->priv->settings;
			_tmp77_ = btn;
			_tmp78_ = ((IconButton*) _tmp77_)->window;
			_tmp79_ = self->icon_size;
			_tmp80_ = btn;
			_tmp81_ = _tmp80_->app_info;
			_tmp80_->app_info = NULL;
			_tmp82_ = _tmp81_;
			_tmp83_ = self->helper;
			_tmp84_ = self->priv->panel_size;
			_tmp85_ = icon_button_new (_tmp76_, _tmp78_, _tmp79_, _tmp82_, _tmp83_, _tmp84_);
			g_object_ref_sink (_tmp85_);
			_tmp86_ = _tmp85_;
			_g_object_unref0 (_tmp82_);
			b2 = _tmp86_;
			_tmp87_ = b2;
			_tmp88_ = button_wrapper_new (_tmp87_);
			g_object_ref_sink (_tmp88_);
			button_wrap = _tmp88_;
			_tmp89_ = btn;
			_tmp90_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp89_);
			button_wrapper_gracefully_die (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, TYPE_BUTTON_WRAPPER) ? ((ButtonWrapper*) _tmp90_) : NULL);
			_tmp91_ = self->widget;
			_tmp92_ = button_wrap;
			gtk_box_pack_start (_tmp91_, (GtkWidget*) _tmp92_, FALSE, FALSE, (guint) 0);
			_tmp93_ = self->buttons;
			_tmp94_ = b2;
			_tmp95_ = _tmp94_->window;
			_tmp96_ = _g_object_ref0 (_tmp95_);
			_tmp97_ = b2;
			_tmp98_ = _g_object_ref0 (_tmp97_);
			g_hash_table_insert (_tmp93_, _tmp96_, _tmp98_);
			_tmp99_ = button_wrap;
			gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp99_, TRUE);
			_g_object_unref0 (button_wrap);
			_g_object_unref0 (b2);
		}
		_tmp100_ = removals;
		_tmp100__length1 = removals_length1;
		_tmp101_ = key_name;
		_tmp102_ = g_strdup (_tmp101_);
		_vala_array_add3 (&removals, &removals_length1, &_removals_size_, _tmp102_);
	}
	_tmp103_ = removals;
	_tmp103__length1 = removals_length1;
	{
		gchar** rkey_collection = NULL;
		gint rkey_collection_length1 = 0;
		gint _rkey_collection_size_ = 0;
		gint rkey_it = 0;
		rkey_collection = _tmp103_;
		rkey_collection_length1 = _tmp103__length1;
		for (rkey_it = 0; rkey_it < _tmp103__length1; rkey_it = rkey_it + 1) {
			gchar* _tmp104_ = NULL;
			gchar* rkey = NULL;
			_tmp104_ = g_strdup (rkey_collection[rkey_it]);
			rkey = _tmp104_;
			{
				GHashTable* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				_tmp105_ = self->pin_buttons;
				_tmp106_ = rkey;
				g_hash_table_remove (_tmp105_, _tmp106_);
				_g_free0 (rkey);
			}
		}
	}
	j = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp107_ = FALSE;
			_tmp107_ = TRUE;
			while (TRUE) {
				gint _tmp109_ = 0;
				gchar** _tmp110_ = NULL;
				gint _tmp110__length1 = 0;
				gchar* lkey = NULL;
				gchar** _tmp111_ = NULL;
				gint _tmp111__length1 = 0;
				gint _tmp112_ = 0;
				const gchar* _tmp113_ = NULL;
				gchar* _tmp114_ = NULL;
				GHashTable* _tmp115_ = NULL;
				const gchar* _tmp116_ = NULL;
				gboolean _tmp117_ = FALSE;
				GtkWidget* parent = NULL;
				GHashTable* _tmp118_ = NULL;
				const gchar* _tmp119_ = NULL;
				gconstpointer _tmp120_ = NULL;
				GtkContainer* _tmp121_ = NULL;
				GtkBox* _tmp122_ = NULL;
				GtkWidget* _tmp123_ = NULL;
				gint _tmp124_ = 0;
				gint _tmp125_ = 0;
				if (!_tmp107_) {
					gint _tmp108_ = 0;
					_tmp108_ = i;
					i = _tmp108_ + 1;
				}
				_tmp107_ = FALSE;
				_tmp109_ = i;
				_tmp110_ = files;
				_tmp110__length1 = files_length1;
				if (!(_tmp109_ < _tmp110__length1)) {
					break;
				}
				_tmp111_ = files;
				_tmp111__length1 = files_length1;
				_tmp112_ = i;
				_tmp113_ = _tmp111_[_tmp112_];
				_tmp114_ = g_strdup (_tmp113_);
				lkey = _tmp114_;
				_tmp115_ = self->pin_buttons;
				_tmp116_ = lkey;
				_tmp117_ = g_hash_table_contains (_tmp115_, _tmp116_);
				if (!_tmp117_) {
					_g_free0 (lkey);
					continue;
				}
				_tmp118_ = self->pin_buttons;
				_tmp119_ = lkey;
				_tmp120_ = g_hash_table_lookup (_tmp118_, _tmp119_);
				_tmp121_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) ((PinnedIconButton*) _tmp120_));
				parent = (GtkWidget*) _tmp121_;
				_tmp122_ = self->pinned;
				_tmp123_ = parent;
				_tmp124_ = j;
				gtk_box_reorder_child (_tmp122_, _tmp123_, _tmp124_);
				_tmp125_ = j;
				j = _tmp125_ + 1;
				_g_free0 (lkey);
			}
		}
	}
	_g_object_unref0 (btn);
	_g_free0 (key_name);
	removals = (_vala_array_free (removals, removals_length1, (GDestroyNotify) g_free), NULL);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
}


const gchar* icon_tasklist_applet_get_uuid (IconTasklistApplet* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}


void icon_tasklist_applet_set_uuid (IconTasklistApplet* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uuid);
	self->priv->_uuid = _tmp1_;
	g_object_notify ((GObject *) self, "uuid");
}


static void icon_tasklist_applet_class_init (IconTasklistAppletClass * klass) {
	icon_tasklist_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IconTasklistAppletPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_tasklist_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_tasklist_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = icon_tasklist_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_TASKLIST_APPLET_UUID, g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void icon_tasklist_applet_instance_init (IconTasklistApplet * self) {
	self->priv = ICON_TASKLIST_APPLET_GET_PRIVATE (self);
	self->icon_size = 32;
	self->priv->small_icons = 32;
	self->priv->panel_size = 10;
}


static void icon_tasklist_applet_finalize (GObject* obj) {
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->main_layout);
	_g_object_unref0 (self->pinned);
	_g_object_unref0 (self->screen);
	_g_hash_table_unref0 (self->buttons);
	_g_hash_table_unref0 (self->pin_buttons);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->helper);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (icon_tasklist_applet_parent_class)->finalize (obj);
}


GType icon_tasklist_applet_get_type (void) {
	return icon_tasklist_applet_type_id;
}


GType icon_tasklist_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IconTasklistAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_tasklist_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconTasklistApplet), 0, (GInstanceInitFunc) icon_tasklist_applet_instance_init, NULL };
	icon_tasklist_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "IconTasklistApplet", &g_define_type_info, 0);
	return icon_tasklist_applet_type_id;
}


static void _vala_icon_tasklist_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID:
		g_value_set_string (value, icon_tasklist_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_icon_tasklist_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IconTasklistApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_TASKLIST_APPLET, IconTasklistApplet);
	switch (property_id) {
		case ICON_TASKLIST_APPLET_UUID:
		icon_tasklist_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	app_system_register_type (module);
	icon_tasklist_register_type (module);
	desktop_helper_register_type (module);
	icon_tasklist_applet_register_type (module);
	button_wrapper_register_type (module);
	icon_button_register_type (module);
	pinned_icon_button_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_ICON_TASKLIST);
	_g_object_unref0 (objmodule);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



