/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.sequenceChooser.FileChooser;

public class ListFilePanel
extends JPanel {
    private int nFiles;
    private FileChooser[] fileChooser;

    public ListFilePanel(int nFiles, JembossParams mysettings, boolean getDefaults) {
        super(new BorderLayout());
        this.nFiles = nFiles;
        Box bdown = Box.createVerticalBox();
        this.fileChooser = new FileChooser[nFiles];
        Dimension fcdim = null;
        bdown.add(Box.createVerticalStrut(2));
        for (int i = 0; i < nFiles; ++i) {
            String defaultSeq;
            this.fileChooser[i] = new FileChooser(bdown, "", mysettings);
            if (fcdim == null) {
                fcdim = this.fileChooser[i].getPreferredSize();
                fcdim = new Dimension(210, (int)fcdim.getHeight());
            }
            this.fileChooser[i].setPreferredSize(fcdim);
            String string = defaultSeq = getDefaults ? SetUpMenuBar.seqList.getDefaultSequenceName(i) : null;
            if (defaultSeq != null) {
                this.fileChooser[i].setText(defaultSeq);
            }
            bdown.add(Box.createVerticalStrut(2));
        }
        ScrollPanel sp = new ScrollPanel(new BorderLayout());
        sp.add(bdown);
        JScrollPane scroll = new JScrollPane(sp);
        scroll.setPreferredSize(new Dimension(350, 100));
        this.add((Component)scroll, "West");
        this.setPreferredSize(new Dimension(350, 100));
        this.setMaximumSize(new Dimension(350, 100));
    }

    public String getListFile() {
        String list = "";
        String ls = System.getProperty("line.separator");
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            list = list.concat(this.fileChooser[i].getFileChosen() + ls);
        }
        return list;
    }

    public String[] getArrayListFile() {
        int nseqs = 0;
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            ++nseqs;
        }
        String[] list = new String[nseqs];
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            list[i] = this.fileChooser[i].getFileChosen();
        }
        return list;
    }

    public boolean writeListFile(String fn) {
        boolean writeOK = true;
        try {
            FileWriter out = new FileWriter(fn);
            out.write(this.getListFile());
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            writeOK = false;
        }
        return writeOK;
    }

    public String getSequence(int n) {
        String fn = "";
        int nseqs = 0;
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("") || ++nseqs != n) continue;
            fn = this.fileChooser[i].getFileChosen();
            break;
        }
        return fn;
    }

    public void doReset() {
        for (int i = 0; i < this.nFiles; ++i) {
            this.fileChooser[i].setText("");
        }
    }
}

